/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wrs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WRSResponseReader {
    public List<String> parseSOSEndpoint(InputStream inputStream) throws IOException, DOMHelperException {
        ArrayList<String> sosUri = new ArrayList<String>();
        DOMHelper reader = new DOMHelper(inputStream, false);
        NodeList svcList = reader.getElements("SearchResults/Service");
        for (int i = 0; i < svcList.getLength(); ++i) {
            Element svcElt = (Element)svcList.item(i);
            Element svcBindingElt = reader.getElement(svcElt, "ServiceBinding");
            String accessUri = svcBindingElt.getAttribute("accessURI");
            if (accessUri == null || sosUri.contains(accessUri)) continue;
            sosUri.add(accessUri);
        }
        return sosUri;
    }

    public HashMap<String, String> parseExtrinsicObjects(InputStream inputStream) throws IOException, DOMHelperException {
        HashMap<String, String> eoMap = new HashMap<String, String>();
        DOMHelper reader = new DOMHelper(inputStream, false);
        NodeList objList = reader.getElements("SearchResults/ExtrinsicObject");
        for (int i = 0; i < objList.getLength(); ++i) {
            Element lsElt;
            Element objElt = (Element)objList.item(i);
            Element nameElt = reader.getElement(objElt, "Name");
            if (nameElt == null || (lsElt = reader.getElement(nameElt, "LocalizedString")) == null) continue;
            String name = lsElt.getAttribute("value");
            String id = objElt.getAttribute("id");
            if (id == null) continue;
            eoMap.put(id, name);
        }
        return eoMap;
    }
}

