/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.impl.GMLFactory;
import net.opengis.gml.v32.impl.ReferenceImpl;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.AbstractSettings;
import net.opengis.sensorml.v20.CharacteristicList;
import net.opengis.sensorml.v20.ContactList;
import net.opengis.sensorml.v20.Link;
import net.opengis.sensorml.v20.ObservableProperty;
import net.opengis.sensorml.v20.PhysicalComponent;
import net.opengis.sensorml.v20.PhysicalSystem;
import net.opengis.sensorml.v20.Settings;
import net.opengis.sensorml.v20.SpatialFrame;
import net.opengis.sensorml.v20.Status;
import net.opengis.swe.v20.AllowedValues;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataConstraint;
import net.opengis.swe.v20.DataRecord;
import net.opengis.swe.v20.Quantity;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.isotc211.v2005.gco.CodeListValue;
import org.isotc211.v2005.gco.impl.CodeListValueImpl;
import org.isotc211.v2005.gmd.CIResponsibleParty;
import org.vast.sensorML.SMLHelper;
import org.vast.sensorML.SMLUtils;
import org.vast.swe.SWEHelper;
import org.xml.sax.InputSource;

public class TestSMLBindingsV20
extends XMLTestCase {
    public void setUp() throws Exception {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
    }

    protected void validate(InputStream is, String schemaUrl) throws Exception {
        InputSource saxIs = new InputSource(is);
        Validator v = new Validator(saxIs);
        v.useXMLSchema(true);
        v.setJAXP12SchemaSource((Object)schemaUrl);
        TestSMLBindingsV20.assertTrue((boolean)v.isValid());
    }

    protected void readWriteCompareProcessXml(String path) throws Exception {
        SMLUtils smlUtils = new SMLUtils("2.0");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        AbstractProcess smlObj = smlUtils.readProcess(is);
        is.close();
        System.out.println();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        smlUtils.writeProcess((OutputStream)os, smlObj, false);
        smlUtils.writeProcess((OutputStream)System.out, smlObj, true);
        InputSource src1 = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(path));
        InputSource src2 = new InputSource(new ByteArrayInputStream(os.toByteArray()));
        this.assertXMLEqual(src1, src2);
    }

    public void testReadWriteSimpleSensor() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/SimpleSensor.xml");
    }

    public void testReadWriteGammaSensor() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/gamma2070_more.xml");
    }

    public void testReadWriteCameraSensor() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/KCM-HD_Camera_inline.xml");
    }

    public void testReadWriteConfiguredCameraSensor() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/KCM-HD Camera.xml");
    }

    public void testReadWriteSensorWithModes() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/SensorWithModes.xml");
    }

    public void testReadWriteDerivedInstance() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/OwnerInstance.xml");
    }

    public void testReadWriteDavisSensor() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/Davis_7817_complete.xml");
    }

    public void testReadWriteWeatherStation() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/WeatherStation.xml");
    }

    public void testReadWriteModeInstance() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/ModeInstance.xml");
    }

    public void testReadWriteSensorwithDataStreamOutput() throws Exception {
        this.readWriteCompareProcessXml("examples_v20/SimpleStreaming RS232.xml");
    }

    public void testGenerateInstance() throws Exception {
        SMLUtils smlUtils = new SMLUtils("2.0");
        SMLHelper smlFac = new SMLHelper();
        SWEHelper sweFac = new SWEHelper();
        GMLFactory gmlFac = new GMLFactory();
        PhysicalSystem system = smlFac.newPhysicalSystem();
        system.setId("MY_SYSTEM");
        CharacteristicList mechSpecs = smlFac.newCharacteristicList();
        Quantity weightSpec = sweFac.newQuantity("http://sweet.jpl.nasa.gov/2.3/propMass.owl#Mass", "Weight", null, "kg");
        weightSpec.setValue(12.3);
        mechSpecs.addCharacteristic("weight", (DataComponent)weightSpec);
        system.addCharacteristics("mechanical", mechSpecs);
        ContactList contacts = smlFac.newContactList();
        CIResponsibleParty contact = smlFac.newResponsibleParty();
        contact.setIndividualName("G\u00e9rard Blanquet");
        contact.setOrganisationName("Time Soft S.A.");
        contact.getContactInfo().getAddress().addDeliveryPoint("10 rue du Nord");
        contact.getContactInfo().getAddress().setPostalCode("75896");
        contact.getContactInfo().getAddress().setCity("Paris");
        contact.getContactInfo().getAddress().setCountry("FRANCE");
        contact.setRole((CodeListValue)new CodeListValueImpl("operator"));
        contacts.addContact(contact);
        system.addContacts(contacts);
        ObservableProperty obs = smlFac.newObservableProperty();
        obs.setDefinition("http://mmisw.org/ont/cf/parameter/weather");
        system.addInput("weather_phenomena", obs);
        system.getInputList().add("rain", "http://remotedef.xml", null);
        DataRecord rec = sweFac.newDataRecord();
        rec.setLabel("Weather Data Record");
        rec.setDescription("Record of synchronous weather measurements");
        rec.addField("time", (DataComponent)sweFac.newTimeStampIsoUTC());
        rec.addField("temp", (DataComponent)sweFac.newQuantity("http://mmisw.org/ont/cf/parameter/air_temperature", "Air Temperature", null, "Cel"));
        rec.addField("press", (DataComponent)sweFac.newQuantity("http://mmisw.org/ont/cf/parameter/air_pressure_at_sea_level", "Air Pressure", null, "mbar"));
        rec.addField("wind_speed", (DataComponent)sweFac.newQuantity("http://mmisw.org/ont/cf/parameter/wind_speed", "Wind Speed", null, "km/h"));
        rec.addField("wind_dir", (DataComponent)sweFac.newQuantity("http://mmisw.org/ont/cf/parameter/wind_to_direction", "Wind Direction", null, "deg"));
        Quantity acc = sweFac.newQuantity("http://mmisw.org/ont/cf/parameter/accuracy", "Accuracy", null, "%");
        ((Quantity)rec.getField("temp")).addQuality(acc);
        system.addOutput("weather_data", (DataComponent)rec);
        system.getOutputList().add("status_info", "http://remotedef.xml", null);
        system.addParameter("samplingPeriod", (DataComponent)sweFac.newQuantity("http://sensorml.com/ont/swe/property/SamplingPeriod", "Sampling Period", null, "s"));
        SpatialFrame systemFrame = smlFac.newSpatialFrame();
        systemFrame.setId("SYSTEM_FRAME");
        systemFrame.setLabel("System Reference Frame");
        systemFrame.setDescription("Cartesian reference frame attached to system assembly");
        systemFrame.setOrigin("Origin is located on the red marking at the bottom of the aluminum chassis");
        systemFrame.addAxis("x", "X axis is aligned with the horizontal edge of the chassis (see marking)");
        systemFrame.addAxis("y", "Y axis is orthogonal to both X and Y in order to form a direct orthogonal frame");
        systemFrame.addAxis("z", "Z axis is pointing toward the top of the assembly, aligned with the vertical edge of the aluminum frame");
        system.addLocalReferenceFrame(systemFrame);
        Point pos = gmlFac.newPoint();
        pos.setId("P01");
        pos.setSrsName("http://www.opengis.net/def/crs/EPSG/0/4326");
        pos.setPos(new double[]{45.6, 2.3});
        system.addPositionAsPoint(pos);
        PhysicalComponent sensor = smlFac.newPhysicalComponent();
        sensor.setId("SENS01");
        sensor.setTypeOf((Reference)new ReferenceImpl("http://www.mymanufacturer.net/mysensor001.xml"));
        Settings config = smlFac.newSettings();
        config.addSetValue(smlFac.newValueSetting("parameters/samplingRate", "10.0"));
        config.addSetStatus(smlFac.newStatusSetting("parameters/active", Status.ENABLED));
        config.addSetMode(smlFac.newModeSetting("modes/choice1", "highAccuracy"));
        AllowedValues newConstraint = sweFac.newAllowedValues();
        newConstraint.addValue(5.0);
        newConstraint.addValue(10.0);
        newConstraint.addValue(20.0);
        config.addSetConstraint(smlFac.newConstraintSetting("parameters/samplingRate", (DataConstraint)newConstraint));
        sensor.setConfiguration((AbstractSettings)config);
        system.addComponent("sensor1", (AbstractProcess)sensor);
        Link link = smlFac.newLink();
        link.setSource("sensor1/outputs/temp");
        link.setDestination("outputs/weather_data/temp");
        system.addConnection(link);
        ByteArrayOutputStream os1 = new ByteArrayOutputStream(10000);
        smlUtils.writeProcess((OutputStream)os1, (AbstractProcess)system, false);
        ByteArrayInputStream is = new ByteArrayInputStream(os1.toByteArray());
        system = (PhysicalSystem)smlUtils.readProcess((InputStream)is);
        ByteArrayOutputStream os2 = new ByteArrayOutputStream(10000);
        smlUtils.writeProcess((OutputStream)os2, (AbstractProcess)system, false);
        smlUtils.writeProcess((OutputStream)System.out, (AbstractProcess)system, true);
        System.out.println();
        InputSource src1 = new InputSource(new ByteArrayInputStream(os1.toByteArray()));
        InputSource src2 = new InputSource(new ByteArrayInputStream(os2.toByteArray()));
        this.assertXMLEqual(src1, src2);
    }
}

