/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML.test;

import java.net.URL;
import net.opengis.swe.v20.DataComponent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vast.sensorML.AbstractProcessImpl;
import org.vast.sensorML.ProcessLoader;
import org.vast.sensorML.SMLHelper;
import org.vast.sensorML.SMLUtils;

public class TestSMLProcessing {
    SMLUtils smlUtils = new SMLUtils("2.0");

    @Before
    public void init() throws Exception {
        URL processMapUrl = TestSMLProcessing.class.getResource("ProcessMap.xml");
        ProcessLoader.loadMaps((String)processMapUrl.toString(), (boolean)true);
    }

    protected AbstractProcessImpl getExecutableProcess(String path) throws Exception {
        AbstractProcessImpl process = (AbstractProcessImpl)this.smlUtils.readProcess(TestSMLProcessing.class.getResourceAsStream(path));
        SMLHelper.makeProcessExecutable((AbstractProcessImpl)process);
        process.createNewInputBlocks();
        process.createNewOutputBlocks();
        process.init();
        return process;
    }

    @Test
    public void testExecSimpleProcess() throws Exception {
        AbstractProcessImpl process = this.getExecutableProcess("examples_v20/WindChill.xml");
        for (int i = 0; i < 10; ++i) {
            DataComponent tempIn = process.getInputComponent("weather_inputs").getComponent("temperature");
            tempIn.getData().setDoubleValue(23.5 + (double)i);
            DataComponent windIn = process.getInputComponent("weather_inputs").getComponent("windSpeed");
            windIn.getData().setDoubleValue(4.1 + (double)i);
            process.execute();
        }
    }

    @Test
    public void testExecProcessChainNoThreads() throws Exception {
        AbstractProcessImpl process = this.getExecutableProcess("examples_v20/testAggregateProcess.xml");
        for (int i = 0; i < 10; ++i) {
            double in = i * 2;
            DataComponent valueIn = process.getInputComponent("valueIn");
            valueIn.getData().setDoubleValue(in);
            process.execute();
            double out = process.getOutputComponent("valueOut").getData().getDoubleValue();
            double expected = 2.3 * in + 1.76;
            if (expected < 15.0) {
                expected = Double.NaN;
            }
            Assert.assertEquals((String)"Incorrect output value", (double)expected, (double)out, (double)1.0E-15);
        }
    }
}

