/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML.test;

import org.vast.data.DataValue;
import org.vast.process.SMLException;
import org.vast.sensorML.ExecutableProcessImpl;

public class WindChill_Process
extends ExecutableProcessImpl {
    DataValue inputTemp;
    DataValue inputWindSpeed;
    DataValue outputTemp;

    public void init() throws SMLException {
        try {
            this.inputTemp = (DataValue)this.inputData.getComponent("weather_inputs").getComponent("temperature");
            this.inputWindSpeed = (DataValue)this.inputData.getComponent("weather_inputs").getComponent("windSpeed");
            this.outputTemp = (DataValue)this.outputData.getComponent("windChill");
        }
        catch (Exception e) {
            throw new SMLException("Invalid I/O Structure", (Throwable)e);
        }
    }

    public void execute() throws SMLException {
        double T = this.inputTemp.getData().getDoubleValue();
        double V = this.inputWindSpeed.getData().getDoubleValue();
        double V16 = Math.pow(V, 0.16);
        double Tc = 35.74 + 0.6215 * T - 35.75 * V16 + 0.4275 * T * V16;
        this.outputTemp.getData().setDoubleValue(Tc);
    }
}

