/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.sensorml.v20.bind;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.AbstractXMLStreamBindings;
import net.opengis.HrefResolver;
import net.opengis.HrefResolverXML;
import net.opengis.OgcProperty;
import net.opengis.OgcPropertyImpl;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.TimeInstant;
import net.opengis.gml.v32.TimePeriod;
import net.opengis.sensorml.v20.AbstractAlgorithm;
import net.opengis.sensorml.v20.AbstractMetadataList;
import net.opengis.sensorml.v20.AbstractModes;
import net.opengis.sensorml.v20.AbstractPhysicalProcess;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.AbstractSettings;
import net.opengis.sensorml.v20.AggregateProcess;
import net.opengis.sensorml.v20.ArraySetting;
import net.opengis.sensorml.v20.CapabilityList;
import net.opengis.sensorml.v20.CharacteristicList;
import net.opengis.sensorml.v20.ClassifierList;
import net.opengis.sensorml.v20.ConfigSetting;
import net.opengis.sensorml.v20.ConstraintSetting;
import net.opengis.sensorml.v20.ContactList;
import net.opengis.sensorml.v20.DataInterface;
import net.opengis.sensorml.v20.DescribedObject;
import net.opengis.sensorml.v20.DocumentList;
import net.opengis.sensorml.v20.Event;
import net.opengis.sensorml.v20.EventList;
import net.opengis.sensorml.v20.Factory;
import net.opengis.sensorml.v20.FeatureList;
import net.opengis.sensorml.v20.IdentifierList;
import net.opengis.sensorml.v20.KeywordList;
import net.opengis.sensorml.v20.Link;
import net.opengis.sensorml.v20.Mode;
import net.opengis.sensorml.v20.ModeChoice;
import net.opengis.sensorml.v20.ModeSetting;
import net.opengis.sensorml.v20.ObservableProperty;
import net.opengis.sensorml.v20.PhysicalComponent;
import net.opengis.sensorml.v20.PhysicalSystem;
import net.opengis.sensorml.v20.ProcessMethod;
import net.opengis.sensorml.v20.Settings;
import net.opengis.sensorml.v20.SimpleProcess;
import net.opengis.sensorml.v20.SpatialFrame;
import net.opengis.sensorml.v20.Status;
import net.opengis.sensorml.v20.StatusSetting;
import net.opengis.sensorml.v20.TemporalFrame;
import net.opengis.sensorml.v20.Term;
import net.opengis.sensorml.v20.ValueSetting;
import net.opengis.swe.v20.AbstractSWE;
import net.opengis.swe.v20.AbstractSWEIdentifiable;
import net.opengis.swe.v20.AllowedTimes;
import net.opengis.swe.v20.AllowedTokens;
import net.opengis.swe.v20.AllowedValues;
import net.opengis.swe.v20.DataArray;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataConstraint;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.DataRecord;
import net.opengis.swe.v20.DataStream;
import net.opengis.swe.v20.EncodedValues;
import net.opengis.swe.v20.SimpleComponent;
import net.opengis.swe.v20.Text;
import net.opengis.swe.v20.Time;
import net.opengis.swe.v20.Vector;
import org.isotc211.v2005.gmd.CIOnlineResource;
import org.isotc211.v2005.gmd.CIResponsibleParty;
import org.isotc211.v2005.gmd.MDKeywords;
import org.isotc211.v2005.gmd.MDLegalConstraints;
import org.vast.ogc.gml.GMLStaxBindings;

public class XMLStreamBindings
extends AbstractXMLStreamBindings {
    public static final String NS_URI = "http://www.opengis.net/sensorml/2.0";
    net.opengis.swe.v20.bind.XMLStreamBindings ns1Bindings;
    net.opengis.gml.v32.bind.XMLStreamBindings ns2Bindings;
    org.isotc211.v2005.gmd.bind.XMLStreamBindings ns3Bindings;
    Factory factory;

    public XMLStreamBindings(Factory factory, net.opengis.swe.v20.Factory ns1Factory, net.opengis.gml.v32.Factory ns2Factory, org.isotc211.v2005.gmd.Factory ns3Factory, org.isotc211.v2005.gco.Factory ns4Factory) {
        this.factory = factory;
        this.ns1Bindings = new net.opengis.swe.v20.bind.XMLStreamBindings(ns1Factory);
        this.ns2Bindings = new GMLStaxBindings(ns2Factory);
        this.ns3Bindings = new org.isotc211.v2005.gmd.bind.XMLStreamBindings(ns3Factory, ns4Factory);
    }

    public SimpleProcess readSimpleProcessType(XMLStreamReader reader) throws XMLStreamException {
        SimpleProcess bean = this.factory.newSimpleProcess();
        Map attrMap = this.collectAttributes(reader);
        this.readSimpleProcessTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readSimpleProcessTypeElements(reader, bean);
        return bean;
    }

    public void readSimpleProcessTypeAttributes(Map<String, String> attrMap, SimpleProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeAttributes(attrMap, bean);
    }

    public void readSimpleProcessTypeElements(XMLStreamReader reader, SimpleProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "method");
        if (found) {
            OgcProperty<ProcessMethod> methodProp = bean.getMethodProperty();
            this.readPropertyAttributes(reader, methodProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                methodProp.setValue((Object)this.readProcessMethod(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writeSimpleProcessType(XMLStreamWriter writer, SimpleProcess bean) throws XMLStreamException {
        this.writeSimpleProcessTypeAttributes(writer, bean);
        this.writeSimpleProcessTypeElements(writer, bean);
    }

    public void writeSimpleProcessTypeAttributes(XMLStreamWriter writer, SimpleProcess bean) throws XMLStreamException {
        this.writeAbstractProcessTypeAttributes(writer, bean);
    }

    public void writeSimpleProcessTypeElements(XMLStreamWriter writer, SimpleProcess bean) throws XMLStreamException {
        this.writeAbstractProcessTypeElements(writer, bean);
        if (bean.isSetMethod()) {
            writer.writeStartElement(NS_URI, "method");
            OgcProperty<ProcessMethod> methodProp = bean.getMethodProperty();
            this.writePropertyAttributes(writer, methodProp);
            if (methodProp.hasValue() && !methodProp.hasHref()) {
                this.writeProcessMethod(writer, bean.getMethod());
            }
            writer.writeEndElement();
        }
    }

    public ProcessMethod readProcessMethodType(XMLStreamReader reader) throws XMLStreamException {
        ProcessMethod bean = this.factory.newProcessMethod();
        Map attrMap = this.collectAttributes(reader);
        this.readProcessMethodTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readProcessMethodTypeElements(reader, bean);
        return bean;
    }

    public void readProcessMethodTypeAttributes(Map<String, String> attrMap, ProcessMethod bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
    }

    public void readProcessMethodTypeElements(XMLStreamReader reader, ProcessMethod bean) throws XMLStreamException {
        boolean found;
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
        do {
            if (!(found = this.checkElementName(reader, "algorithm"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addAlgorithm(this.readAbstractAlgorithm(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
    }

    public void writeProcessMethodType(XMLStreamWriter writer, ProcessMethod bean) throws XMLStreamException {
        this.writeProcessMethodTypeAttributes(writer, bean);
        this.writeProcessMethodTypeElements(writer, bean);
    }

    public void writeProcessMethodTypeAttributes(XMLStreamWriter writer, ProcessMethod bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
    }

    public void writeProcessMethodTypeElements(XMLStreamWriter writer, ProcessMethod bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
        int numItems = bean.getAlgorithmList().size();
        for (int i = 0; i < numItems; ++i) {
            AbstractAlgorithm item = bean.getAlgorithmList().get(i);
            writer.writeStartElement(NS_URI, "algorithm");
            this.writeAbstractAlgorithm(writer, item);
            writer.writeEndElement();
        }
    }

    public void readAbstractAlgorithmTypeAttributes(Map<String, String> attrMap, AbstractAlgorithm bean) throws XMLStreamException {
        String val = attrMap.get("id");
        if (val != null) {
            bean.setId(val);
        }
    }

    public void writeAbstractAlgorithmTypeAttributes(XMLStreamWriter writer, AbstractAlgorithm bean) throws XMLStreamException {
        if (bean.isSetId()) {
            writer.writeAttribute("id", this.getStringValue(bean.getId()));
        }
    }

    public Mode readModeType(XMLStreamReader reader) throws XMLStreamException {
        Mode bean = this.factory.newMode();
        Map attrMap = this.collectAttributes(reader);
        this.readModeTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readModeTypeElements(reader, bean);
        return bean;
    }

    public void readModeTypeAttributes(Map<String, String> attrMap, Mode bean) throws XMLStreamException {
        this.readDescribedObjectTypeAttributes(attrMap, bean);
    }

    public void readModeTypeElements(XMLStreamReader reader, Mode bean) throws XMLStreamException {
        this.readDescribedObjectTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "configuration");
        if (found) {
            OgcProperty<Settings> configurationProp = bean.getConfigurationProperty();
            this.readPropertyAttributes(reader, configurationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                configurationProp.setValue((Object)this.readSettings(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writeModeType(XMLStreamWriter writer, Mode bean) throws XMLStreamException {
        this.writeModeTypeAttributes(writer, bean);
        this.writeModeTypeElements(writer, bean);
    }

    public void writeModeTypeAttributes(XMLStreamWriter writer, Mode bean) throws XMLStreamException {
        this.writeDescribedObjectTypeAttributes(writer, bean);
    }

    public void writeModeTypeElements(XMLStreamWriter writer, Mode bean) throws XMLStreamException {
        this.writeDescribedObjectTypeElements(writer, bean);
        writer.writeStartElement(NS_URI, "configuration");
        OgcProperty<Settings> configurationProp = bean.getConfigurationProperty();
        this.writePropertyAttributes(writer, configurationProp);
        if (configurationProp.hasValue() && !configurationProp.hasHref()) {
            this.writeSettings(writer, bean.getConfiguration());
        }
        writer.writeEndElement();
    }

    public ModeChoice readModeChoiceType(XMLStreamReader reader) throws XMLStreamException {
        ModeChoice bean = this.factory.newModeChoice();
        Map attrMap = this.collectAttributes(reader);
        this.readModeChoiceTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readModeChoiceTypeElements(reader, bean);
        return bean;
    }

    public void readModeChoiceTypeAttributes(Map<String, String> attrMap, ModeChoice bean) throws XMLStreamException {
        this.readAbstractModesTypeAttributes(attrMap, bean);
    }

    public void readModeChoiceTypeElements(XMLStreamReader reader, ModeChoice bean) throws XMLStreamException {
        boolean found;
        this.readAbstractModesTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "mode"))) continue;
            OgcPropertyImpl modeProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)modeProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                modeProp.setValue((Object)this.readMode(reader));
                reader.nextTag();
            }
            bean.getModeList().add((OgcProperty)modeProp);
            reader.nextTag();
        } while (found);
    }

    public void writeModeChoiceType(XMLStreamWriter writer, ModeChoice bean) throws XMLStreamException {
        this.writeModeChoiceTypeAttributes(writer, bean);
        this.writeModeChoiceTypeElements(writer, bean);
    }

    public void writeModeChoiceTypeAttributes(XMLStreamWriter writer, ModeChoice bean) throws XMLStreamException {
        this.writeAbstractModesTypeAttributes(writer, bean);
    }

    public void writeModeChoiceTypeElements(XMLStreamWriter writer, ModeChoice bean) throws XMLStreamException {
        this.writeAbstractModesTypeElements(writer, bean);
        int numItems = bean.getModeList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getModeList().getProperty(i);
            writer.writeStartElement(NS_URI, "mode");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeMode(writer, (Mode)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public Settings readSettingsType(XMLStreamReader reader) throws XMLStreamException {
        Settings bean = this.factory.newSettings();
        Map attrMap = this.collectAttributes(reader);
        this.readSettingsTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readSettingsTypeElements(reader, bean);
        return bean;
    }

    public void readSettingsTypeAttributes(Map<String, String> attrMap, Settings bean) throws XMLStreamException {
        this.readAbstractSettingsTypeAttributes(attrMap, bean);
    }

    public void readSettingsTypeElements(XMLStreamReader reader, Settings bean) throws XMLStreamException {
        boolean found;
        this.readAbstractSettingsTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "setValue"))) continue;
            ValueSetting setValue = this.readValueSettingPropertyType(reader);
            if (setValue != null) {
                bean.addSetValue(setValue);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "setArrayValues"))) continue;
            ArraySetting setArrayValues = this.readArraySettingPropertyType(reader);
            if (setArrayValues != null) {
                bean.addSetArrayValues(setArrayValues);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "setConstraint"))) continue;
            ConstraintSetting setConstraint = this.readConstraintSettingPropertyType(reader);
            if (setConstraint != null) {
                bean.addSetConstraint(setConstraint);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "setMode"))) continue;
            ModeSetting setMode = this.readModeSettingPropertyType(reader);
            if (setMode != null) {
                bean.addSetMode(setMode);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "setStatus"))) continue;
            StatusSetting setStatus = this.readStatusSettingPropertyType(reader);
            if (setStatus != null) {
                bean.addSetStatus(setStatus);
            }
            reader.nextTag();
        } while (found);
    }

    public void writeSettingsType(XMLStreamWriter writer, Settings bean) throws XMLStreamException {
        this.writeSettingsTypeAttributes(writer, bean);
        this.writeSettingsTypeElements(writer, bean);
    }

    public void writeSettingsTypeAttributes(XMLStreamWriter writer, Settings bean) throws XMLStreamException {
        this.writeAbstractSettingsTypeAttributes(writer, bean);
    }

    public void writeSettingsTypeElements(XMLStreamWriter writer, Settings bean) throws XMLStreamException {
        ConfigSetting<SimpleComponent> item;
        int i;
        this.writeAbstractSettingsTypeElements(writer, bean);
        int numItems = bean.getSetValueList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSetValueList().get(i);
            writer.writeStartElement(NS_URI, "setValue");
            this.writeValueSettingPropertyType(writer, (ValueSetting)item);
            writer.writeEndElement();
        }
        numItems = bean.getSetArrayValuesList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSetArrayValuesList().get(i);
            writer.writeStartElement(NS_URI, "setArrayValues");
            this.writeArraySettingPropertyType(writer, (ArraySetting)item);
            writer.writeEndElement();
        }
        numItems = bean.getSetConstraintList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSetConstraintList().get(i);
            writer.writeStartElement(NS_URI, "setConstraint");
            this.writeConstraintSettingPropertyType(writer, (ConstraintSetting)item);
            writer.writeEndElement();
        }
        numItems = bean.getSetModeList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSetModeList().get(i);
            writer.writeStartElement(NS_URI, "setMode");
            this.writeModeSettingPropertyType(writer, (ModeSetting)item);
            writer.writeEndElement();
        }
        numItems = bean.getSetStatusList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSetStatusList().get(i);
            writer.writeStartElement(NS_URI, "setStatus");
            this.writeStatusSettingPropertyType(writer, (StatusSetting)item);
            writer.writeEndElement();
        }
    }

    public ModeSetting readModeSettingPropertyType(XMLStreamReader reader) throws XMLStreamException {
        ModeSetting bean = this.factory.newModeSetting();
        Map attrMap = this.collectAttributes(reader);
        String val = (String)attrMap.get("ref");
        if (val != null) {
            bean.setRef(val);
        }
        if ((val = reader.getElementText()) != null) {
            bean.setValue(val);
        }
        return bean;
    }

    public void writeModeSettingPropertyType(XMLStreamWriter writer, ModeSetting bean) throws XMLStreamException {
        writer.writeAttribute("ref", this.getStringValue(bean.getRef()));
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public ValueSetting readValueSettingPropertyType(XMLStreamReader reader) throws XMLStreamException {
        ValueSetting bean = this.factory.newValueSetting();
        Map attrMap = this.collectAttributes(reader);
        String val = (String)attrMap.get("ref");
        if (val != null) {
            bean.setRef(val);
        }
        if ((val = reader.getElementText()) != null) {
            bean.setValue(val);
        }
        return bean;
    }

    public void writeValueSettingPropertyType(XMLStreamWriter writer, ValueSetting bean) throws XMLStreamException {
        writer.writeAttribute("ref", this.getStringValue(bean.getRef()));
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public ConstraintSetting readConstraintSettingPropertyType(XMLStreamReader reader) throws XMLStreamException {
        ConstraintSetting bean = this.factory.newConstraintSetting();
        Map attrMap = this.collectAttributes(reader);
        String val = (String)attrMap.get("ref");
        if (val != null) {
            bean.setRef(val);
        }
        reader.nextTag();
        String localName = reader.getName().getLocalPart();
        if (localName.equals("AllowedTimes")) {
            AllowedTimes constraint = this.ns1Bindings.readAllowedTimes(reader);
            bean.setValueAsAllowedTimes(constraint);
        } else if (localName.equals("AllowedTokens")) {
            AllowedTokens constraint = this.ns1Bindings.readAllowedTokens(reader);
            bean.setValueAsAllowedTokens(constraint);
        } else if (localName.equals("AllowedValues")) {
            AllowedValues constraint = this.ns1Bindings.readAllowedValues(reader);
            bean.setValueAsAllowedValues(constraint);
        } else {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        reader.nextTag();
        return bean;
    }

    public void writeConstraintSettingPropertyType(XMLStreamWriter writer, ConstraintSetting bean) throws XMLStreamException {
        writer.writeAttribute("ref", this.getStringValue(bean.getRef()));
        DataConstraint constraint = bean.getValue();
        if (constraint instanceof AllowedTimes) {
            this.ns1Bindings.writeAllowedTimes(writer, (AllowedTimes)constraint);
        } else if (constraint instanceof AllowedTokens) {
            this.ns1Bindings.writeAllowedTokens(writer, (AllowedTokens)constraint);
        } else if (constraint instanceof AllowedValues) {
            this.ns1Bindings.writeAllowedValues(writer, (AllowedValues)constraint, false);
        }
    }

    public ArraySetting readArraySettingPropertyType(XMLStreamReader reader) throws XMLStreamException {
        ArraySetting bean = this.factory.newArraySetting();
        Map attrMap = this.collectAttributes(reader);
        String val = (String)attrMap.get("ref");
        if (val != null) {
            bean.setRef(val);
        }
        reader.nextTag();
        reader.nextTag();
        boolean found = this.checkElementName(reader, "encoding");
        if (found) {
            reader.nextTag();
            DataEncoding encoding = this.ns1Bindings.readAbstractEncoding(reader);
            if (encoding != null) {
                bean.setEncoding(encoding);
            }
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "value")) {
            EncodedValues values = this.ns1Bindings.readEncodedValuesPropertyType(reader, null, bean.getEncoding());
            if (values != null) {
                bean.setValue(values);
            }
            reader.nextTag();
        }
        reader.nextTag();
        return bean;
    }

    public void writeArraySettingPropertyType(XMLStreamWriter writer, ArraySetting bean) throws XMLStreamException {
        writer.writeAttribute("ref", this.getStringValue(bean.getRef()));
        writer.writeStartElement(NS_URI, "ArrayValues");
        writer.writeStartElement(NS_URI, "encoding");
        this.ns1Bindings.writeAbstractEncoding(writer, bean.getEncoding());
        writer.writeEndElement();
        writer.writeStartElement(NS_URI, "value");
        this.ns1Bindings.writeEncodedValuesPropertyType(writer, (AbstractSWEIdentifiable)bean.getReferencedObject(), bean.getEncoding(), bean.getValue());
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public PhysicalSystem readPhysicalSystemType(XMLStreamReader reader) throws XMLStreamException {
        PhysicalSystem bean = this.factory.newPhysicalSystem();
        Map attrMap = this.collectAttributes(reader);
        this.readPhysicalSystemTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readPhysicalSystemTypeElements(reader, bean);
        return bean;
    }

    public void readPhysicalSystemTypeAttributes(Map<String, String> attrMap, PhysicalSystem bean) throws XMLStreamException {
        this.readAbstractPhysicalProcessTypeAttributes(attrMap, bean);
    }

    public void readPhysicalSystemTypeElements(XMLStreamReader reader, PhysicalSystem bean) throws XMLStreamException {
        this.readAbstractPhysicalProcessTypeElements(reader, bean);
        this.readComponentsAndConnections(reader, bean);
    }

    public void writePhysicalSystemType(XMLStreamWriter writer, PhysicalSystem bean) throws XMLStreamException {
        this.writePhysicalSystemTypeAttributes(writer, bean);
        this.writePhysicalSystemTypeElements(writer, bean);
    }

    public void writePhysicalSystemTypeAttributes(XMLStreamWriter writer, PhysicalSystem bean) throws XMLStreamException {
        this.writeAbstractPhysicalProcessTypeAttributes(writer, bean);
    }

    public void writePhysicalSystemTypeElements(XMLStreamWriter writer, PhysicalSystem bean) throws XMLStreamException {
        this.writeAbstractPhysicalProcessTypeElements(writer, bean);
        this.writeComponentsAndConnections(writer, bean);
    }

    public PhysicalComponent readPhysicalComponentType(XMLStreamReader reader) throws XMLStreamException {
        PhysicalComponent bean = this.factory.newPhysicalComponent();
        Map attrMap = this.collectAttributes(reader);
        this.readPhysicalComponentTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readPhysicalComponentTypeElements(reader, bean);
        return bean;
    }

    public void readPhysicalComponentTypeAttributes(Map<String, String> attrMap, PhysicalComponent bean) throws XMLStreamException {
        this.readAbstractPhysicalProcessTypeAttributes(attrMap, bean);
    }

    public void readPhysicalComponentTypeElements(XMLStreamReader reader, PhysicalComponent bean) throws XMLStreamException {
        this.readAbstractPhysicalProcessTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "method");
        if (found) {
            OgcProperty methodProp = bean.getMethodProperty();
            this.readPropertyAttributes(reader, methodProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                methodProp.setValue((Object)this.readProcessMethod(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writePhysicalComponentType(XMLStreamWriter writer, PhysicalComponent bean) throws XMLStreamException {
        this.writePhysicalComponentTypeAttributes(writer, bean);
        this.writePhysicalComponentTypeElements(writer, bean);
    }

    public void writePhysicalComponentTypeAttributes(XMLStreamWriter writer, PhysicalComponent bean) throws XMLStreamException {
        this.writeAbstractPhysicalProcessTypeAttributes(writer, bean);
    }

    public void writePhysicalComponentTypeElements(XMLStreamWriter writer, PhysicalComponent bean) throws XMLStreamException {
        this.writeAbstractPhysicalProcessTypeElements(writer, bean);
        if (bean.isSetMethod()) {
            writer.writeStartElement(NS_URI, "method");
            OgcProperty methodProp = bean.getMethodProperty();
            this.writePropertyAttributes(writer, methodProp);
            if (methodProp.hasValue() && !methodProp.hasHref()) {
                this.writeProcessMethod(writer, bean.getMethod());
            }
            writer.writeEndElement();
        }
    }

    public void readAbstractPhysicalProcessTypeAttributes(Map<String, String> attrMap, AbstractPhysicalProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeAttributes(attrMap, bean);
    }

    public void readAbstractPhysicalProcessTypeElements(XMLStreamReader reader, AbstractPhysicalProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "attachedTo");
        if (found) {
            bean.setAttachedTo(this.ns2Bindings.readReferenceType(reader));
            reader.nextTag();
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "localReferenceFrame"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addLocalReferenceFrame(this.readSpatialFrame(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "localTimeFrame"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addLocalTimeFrame(this.readTemporalFrame(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "position"))) continue;
            OgcPropertyImpl positionProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)positionProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                Object position;
                String localName = reader.getName().getLocalPart();
                if (localName.equals("Text")) {
                    position = this.ns1Bindings.readText(reader);
                    positionProp.setValue(position);
                } else if (localName.equals("Point")) {
                    position = this.ns2Bindings.readPoint(reader);
                    positionProp.setValue(position);
                } else if (localName.equals("Vector")) {
                    position = this.ns1Bindings.readVector(reader);
                    positionProp.setValue(position);
                } else if (localName.equals("DataRecord")) {
                    position = this.ns1Bindings.readDataRecord(reader);
                    positionProp.setValue(position);
                } else if (localName.equals("DataArray")) {
                    position = this.ns1Bindings.readDataArray(reader);
                    positionProp.setValue(position);
                } else if (localName.equals("AbstractProcess")) {
                    position = this.readAbstractProcess(reader);
                    positionProp.setValue(position);
                } else {
                    throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
                }
                reader.nextTag();
            }
            bean.getPositionList().add((OgcProperty)positionProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "timePosition"))) continue;
            OgcPropertyImpl timePositionProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)timePositionProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                timePositionProp.setValue((Object)this.ns1Bindings.readTime(reader));
                reader.nextTag();
            }
            bean.getTimePositionList().add((OgcProperty)timePositionProp);
            reader.nextTag();
        } while (found);
    }

    public void writeAbstractPhysicalProcessTypeAttributes(XMLStreamWriter writer, AbstractPhysicalProcess bean) throws XMLStreamException {
        this.writeAbstractProcessTypeAttributes(writer, bean);
    }

    public void writeAbstractPhysicalProcessTypeElements(XMLStreamWriter writer, AbstractPhysicalProcess bean) throws XMLStreamException {
        Object item;
        int i;
        this.writeAbstractProcessTypeElements(writer, bean);
        if (bean.isSetAttachedTo()) {
            writer.writeStartElement(NS_URI, "attachedTo");
            this.ns2Bindings.writeReferenceType(writer, bean.getAttachedTo());
            writer.writeEndElement();
        }
        int numItems = bean.getLocalReferenceFrameList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getLocalReferenceFrameList().get(i);
            writer.writeStartElement(NS_URI, "localReferenceFrame");
            this.writeSpatialFrame(writer, (SpatialFrame)item);
            writer.writeEndElement();
        }
        numItems = bean.getLocalTimeFrameList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getLocalTimeFrameList().get(i);
            writer.writeStartElement(NS_URI, "localTimeFrame");
            this.writeTemporalFrame(writer, (TemporalFrame)item);
            writer.writeEndElement();
        }
        numItems = bean.getPositionList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getPositionList().getProperty(i);
            writer.writeStartElement(NS_URI, "position");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                if (item.getValue() instanceof Text) {
                    this.ns1Bindings.writeText(writer, (Text)item.getValue(), true);
                } else if (item.getValue() instanceof Point) {
                    this.ns2Bindings.writePoint(writer, (Point)item.getValue());
                } else if (item.getValue() instanceof Vector) {
                    this.ns1Bindings.writeVector(writer, (Vector)item.getValue(), true);
                } else if (item.getValue() instanceof DataRecord) {
                    this.ns1Bindings.writeDataRecord(writer, (DataRecord)item.getValue(), true);
                } else if (item.getValue() instanceof DataArray) {
                    this.ns1Bindings.writeDataArray(writer, (DataArray)item.getValue(), true);
                } else if (item.getValue() instanceof AbstractProcess) {
                    this.writeAbstractProcess(writer, (AbstractProcess)item.getValue());
                }
            }
            writer.writeEndElement();
        }
        numItems = bean.getTimePositionList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getTimePositionList().getProperty(i);
            writer.writeStartElement(NS_URI, "timePosition");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns1Bindings.writeTime(writer, (Time)item.getValue(), true);
            }
            writer.writeEndElement();
        }
    }

    public TemporalFrame readTemporalFrameType(XMLStreamReader reader) throws XMLStreamException {
        TemporalFrame bean = this.factory.newTemporalFrame();
        Map attrMap = this.collectAttributes(reader);
        this.readTemporalFrameTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readTemporalFrameTypeElements(reader, bean);
        return bean;
    }

    public void readTemporalFrameTypeAttributes(Map<String, String> attrMap, TemporalFrame bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
    }

    public void readTemporalFrameTypeElements(XMLStreamReader reader, TemporalFrame bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
        boolean found = this.checkElementName(reader, "origin");
        if (found) {
            String val = reader.getElementText();
            if (val != null) {
                bean.setOrigin(val);
            }
            reader.nextTag();
        }
    }

    public void writeTemporalFrameType(XMLStreamWriter writer, TemporalFrame bean) throws XMLStreamException {
        this.writeTemporalFrameTypeAttributes(writer, bean);
        this.writeTemporalFrameTypeElements(writer, bean);
    }

    public void writeTemporalFrameTypeAttributes(XMLStreamWriter writer, TemporalFrame bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
    }

    public void writeTemporalFrameTypeElements(XMLStreamWriter writer, TemporalFrame bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
        writer.writeStartElement(NS_URI, "origin");
        writer.writeCharacters(bean.getOrigin());
        writer.writeEndElement();
    }

    public SpatialFrame readSpatialFrameType(XMLStreamReader reader) throws XMLStreamException {
        SpatialFrame bean = this.factory.newSpatialFrame();
        Map attrMap = this.collectAttributes(reader);
        this.readSpatialFrameTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readSpatialFrameTypeElements(reader, bean);
        return bean;
    }

    public void readSpatialFrameTypeAttributes(Map<String, String> attrMap, SpatialFrame bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
    }

    public void readSpatialFrameTypeElements(XMLStreamReader reader, SpatialFrame bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
        boolean found = this.checkElementName(reader, "origin");
        if (found) {
            String val = reader.getElementText();
            if (val != null) {
                bean.setOrigin(val);
            }
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "axis"))) continue;
            OgcPropertyImpl axisProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)axisProp);
            axisProp.setValue((Object)this.readAxis(reader));
            bean.getAxisList().add((OgcProperty)axisProp);
            reader.nextTag();
        } while (found);
    }

    public void writeSpatialFrameType(XMLStreamWriter writer, SpatialFrame bean) throws XMLStreamException {
        this.writeSpatialFrameTypeAttributes(writer, bean);
        this.writeSpatialFrameTypeElements(writer, bean);
    }

    public void writeSpatialFrameTypeAttributes(XMLStreamWriter writer, SpatialFrame bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
    }

    public void writeSpatialFrameTypeElements(XMLStreamWriter writer, SpatialFrame bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
        writer.writeStartElement(NS_URI, "origin");
        writer.writeCharacters(bean.getOrigin());
        writer.writeEndElement();
        int numItems = bean.getAxisList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getAxisList().getProperty(i);
            writer.writeStartElement(NS_URI, "axis");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeAxis(writer, (String)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public AggregateProcess readAggregateProcessType(XMLStreamReader reader) throws XMLStreamException {
        AggregateProcess bean = this.factory.newAggregateProcess();
        Map attrMap = this.collectAttributes(reader);
        this.readAggregateProcessTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readAggregateProcessTypeElements(reader, bean);
        return bean;
    }

    public void readAggregateProcessTypeAttributes(Map<String, String> attrMap, AggregateProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeAttributes(attrMap, bean);
    }

    public void readAggregateProcessTypeElements(XMLStreamReader reader, AggregateProcess bean) throws XMLStreamException {
        this.readAbstractProcessTypeElements(reader, bean);
        this.readComponentsAndConnections(reader, bean);
    }

    protected void readComponentsAndConnections(XMLStreamReader reader, AggregateProcess bean) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "components");
        if (found) {
            reader.nextTag();
            reader.nextTag();
            if (reader.getEventType() == 1) {
                do {
                    if (!(found = this.checkElementName(reader, "component"))) continue;
                    OgcPropertyImpl componentProp = new OgcPropertyImpl();
                    this.readPropertyAttributes(reader, (OgcProperty)componentProp);
                    reader.nextTag();
                    if (reader.getEventType() == 1) {
                        componentProp.setValue((Object)this.readAbstractProcess(reader));
                        reader.nextTag();
                    }
                    bean.getComponentList().add((OgcProperty)componentProp);
                    reader.nextTag();
                } while (found);
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "connections")) {
            reader.nextTag();
            reader.nextTag();
            if (reader.getEventType() == 1) {
                do {
                    if (!(found = this.checkElementName(reader, "connection"))) continue;
                    reader.nextTag();
                    if (reader.getEventType() == 1) {
                        bean.addConnection(this.readLink(reader));
                        reader.nextTag();
                    }
                    reader.nextTag();
                } while (found);
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writeAggregateProcessType(XMLStreamWriter writer, AggregateProcess bean) throws XMLStreamException {
        this.writeAggregateProcessTypeAttributes(writer, bean);
        this.writeAggregateProcessTypeElements(writer, bean);
    }

    public void writeAggregateProcessTypeAttributes(XMLStreamWriter writer, AggregateProcess bean) throws XMLStreamException {
        this.writeAbstractProcessTypeAttributes(writer, bean);
    }

    public void writeAggregateProcessTypeElements(XMLStreamWriter writer, AggregateProcess bean) throws XMLStreamException {
        this.writeAbstractProcessTypeElements(writer, bean);
        this.writeComponentsAndConnections(writer, bean);
    }

    protected void writeComponentsAndConnections(XMLStreamWriter writer, AggregateProcess bean) throws XMLStreamException {
        Object item;
        int i;
        int numItems;
        if (bean.getNumComponents() > 0) {
            writer.writeStartElement(NS_URI, "components");
            writer.writeStartElement(NS_URI, "ComponentList");
            numItems = bean.getComponentList().size();
            for (i = 0; i < numItems; ++i) {
                item = bean.getComponentList().getProperty(i);
                writer.writeStartElement(NS_URI, "component");
                this.writePropertyAttributes(writer, (OgcProperty)item);
                if (item.hasValue() && !item.hasHref()) {
                    this.writeAbstractProcess(writer, (AbstractProcess)item.getValue());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (bean.getNumComponents() > 0) {
            writer.writeStartElement(NS_URI, "connections");
            writer.writeStartElement(NS_URI, "ConnectionList");
            numItems = bean.getConnectionList().size();
            for (i = 0; i < numItems; ++i) {
                item = bean.getConnectionList().get(i);
                writer.writeStartElement(NS_URI, "connection");
                this.writeLink(writer, (Link)item);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    public Link readLinkType(XMLStreamReader reader) throws XMLStreamException {
        Link bean = this.factory.newLink();
        Map attrMap = this.collectAttributes(reader);
        this.readLinkTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readLinkTypeElements(reader, bean);
        return bean;
    }

    public void readLinkTypeAttributes(Map<String, String> attrMap, Link bean) throws XMLStreamException {
        String val = attrMap.get("id");
        if (val != null) {
            bean.setId(val);
        }
    }

    public void readLinkTypeElements(XMLStreamReader reader, Link bean) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "source");
        if (found) {
            bean.setSource(this.readDataComponentRefPropertyType(reader));
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "destination")) {
            bean.setDestination(this.readDataComponentRefPropertyType(reader));
            reader.nextTag();
            reader.nextTag();
        }
    }

    public void writeLinkType(XMLStreamWriter writer, Link bean) throws XMLStreamException {
        this.writeLinkTypeAttributes(writer, bean);
        this.writeLinkTypeElements(writer, bean);
    }

    public void writeLinkTypeAttributes(XMLStreamWriter writer, Link bean) throws XMLStreamException {
        if (bean.isSetId()) {
            writer.writeAttribute("id", this.getStringValue(bean.getId()));
        }
    }

    public void writeLinkTypeElements(XMLStreamWriter writer, Link bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "source");
        this.writeDataComponentRefPropertyType(writer, bean.getSource());
        writer.writeEndElement();
        writer.writeStartElement(NS_URI, "destination");
        this.writeDataComponentRefPropertyType(writer, bean.getDestination());
        writer.writeEndElement();
    }

    public void readDescribedObjectTypeAttributes(Map<String, String> attrMap, DescribedObject bean) throws XMLStreamException {
        this.ns2Bindings.readAbstractFeatureTypeAttributes(attrMap, (AbstractFeature)bean);
        String val = attrMap.get("lang");
        if (val != null) {
            bean.setLang(val);
        }
    }

    public void readDescribedObjectTypeElements(XMLStreamReader reader, DescribedObject bean) throws XMLStreamException {
        boolean found;
        this.ns2Bindings.readAbstractFeatureTypeElements(reader, (AbstractFeature)bean);
        do {
            Object extension;
            if (!(found = this.checkElementName(reader, "extension"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1 && (extension = this.readExtension(reader)) != null) {
                bean.addExtension(extension);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "keywords"))) continue;
            OgcPropertyImpl keywordsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)keywordsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                keywordsProp.setValue((Object)this.readKeywordList(reader));
                reader.nextTag();
            }
            bean.getKeywordsList().add((OgcProperty)keywordsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "identification"))) continue;
            OgcPropertyImpl identificationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)identificationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                identificationProp.setValue((Object)this.readIdentifierList(reader));
                reader.nextTag();
            }
            bean.getIdentificationList().add((OgcProperty)identificationProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "classification"))) continue;
            OgcPropertyImpl classificationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)classificationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                classificationProp.setValue((Object)this.readClassifierList(reader));
                reader.nextTag();
            }
            bean.getClassificationList().add((OgcProperty)classificationProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "validTime"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                TimePeriod validTime;
                String localName = reader.getName().getLocalPart();
                if (localName.equals("TimePeriod")) {
                    validTime = this.ns2Bindings.readTimePeriod(reader);
                    bean.addValidTimeAsTimePeriod(validTime);
                } else if (localName.equals("TimeInstant")) {
                    validTime = this.ns2Bindings.readTimeInstant(reader);
                    bean.addValidTimeAsTimeInstant((TimeInstant)validTime);
                } else {
                    throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
                }
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
        do {
            Object sec;
            if (!(found = this.checkElementName(reader, "securityConstraints"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1 && (sec = this.readSecurityConstraints(reader)) != null) {
                bean.addSecurityConstraints(sec);
            }
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "legalConstraints"))) continue;
            OgcPropertyImpl legalConstraintsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)legalConstraintsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                legalConstraintsProp.setValue((Object)this.ns3Bindings.readMDLegalConstraints(reader));
                reader.nextTag();
            }
            bean.getLegalConstraintsList().add((OgcProperty)legalConstraintsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "characteristics"))) continue;
            OgcPropertyImpl characteristicsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)characteristicsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                characteristicsProp.setValue((Object)this.readCharacteristicList(reader));
                reader.nextTag();
            }
            bean.getCharacteristicsList().add((OgcProperty)characteristicsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "capabilities"))) continue;
            OgcPropertyImpl capabilitiesProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)capabilitiesProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                capabilitiesProp.setValue((Object)this.readCapabilityList(reader));
                reader.nextTag();
            }
            bean.getCapabilitiesList().add((OgcProperty)capabilitiesProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "contacts"))) continue;
            OgcPropertyImpl contactsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)contactsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                contactsProp.setValue((Object)this.readContactList(reader));
                reader.nextTag();
            }
            bean.getContactsList().add((OgcProperty)contactsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "documentation"))) continue;
            OgcPropertyImpl documentationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)documentationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                documentationProp.setValue((Object)this.readDocumentList(reader));
                reader.nextTag();
            }
            bean.getDocumentationList().add((OgcProperty)documentationProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "history"))) continue;
            OgcPropertyImpl historyProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)historyProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                historyProp.setValue((Object)this.readEventList(reader));
                reader.nextTag();
            }
            bean.getHistoryList().add((OgcProperty)historyProp);
            reader.nextTag();
        } while (found);
    }

    public void writeDescribedObjectTypeAttributes(XMLStreamWriter writer, DescribedObject bean) throws XMLStreamException {
        this.ns2Bindings.writeAbstractFeatureTypeAttributes(writer, (AbstractFeature)bean);
        if (bean.isSetLang()) {
            writer.writeAttribute("xml:lang", this.getStringValue(bean.getLang()));
        }
    }

    public void writeDescribedObjectTypeElements(XMLStreamWriter writer, DescribedObject bean) throws XMLStreamException {
        Object item;
        int i;
        this.ns2Bindings.writeAbstractFeatureTypeElements(writer, (AbstractFeature)bean);
        int numItems = bean.getExtensionList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getExtensionList().get(i);
            if (!this.canWriteExtension(item)) continue;
            writer.writeStartElement(NS_URI, "extension");
            this.writeExtension(writer, item);
            writer.writeEndElement();
        }
        numItems = bean.getKeywordsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getKeywordsList().getProperty(i);
            writer.writeStartElement(NS_URI, "keywords");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeKeywordList(writer, (KeywordList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getIdentificationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getIdentificationList().getProperty(i);
            writer.writeStartElement(NS_URI, "identification");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeIdentifierList(writer, (IdentifierList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getClassificationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getClassificationList().getProperty(i);
            writer.writeStartElement(NS_URI, "classification");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeClassifierList(writer, (ClassifierList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getValidTimeList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getValidTimeList().get(i);
            writer.writeStartElement(NS_URI, "validTime");
            if (item instanceof TimePeriod) {
                this.ns2Bindings.writeTimePeriod(writer, (TimePeriod)item);
            } else if (item instanceof TimeInstant) {
                this.ns2Bindings.writeTimeInstant(writer, (TimeInstant)item);
            }
            writer.writeEndElement();
        }
        numItems = bean.getSecurityConstraintsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getSecurityConstraintsList().get(i);
            writer.writeStartElement(NS_URI, "securityConstraints");
            this.writeSecurityConstraints(writer, item);
            writer.writeEndElement();
        }
        numItems = bean.getLegalConstraintsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getLegalConstraintsList().getProperty(i);
            writer.writeStartElement(NS_URI, "legalConstraints");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns3Bindings.writeMDLegalConstraints(writer, (MDLegalConstraints)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getCharacteristicsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getCharacteristicsList().getProperty(i);
            writer.writeStartElement(NS_URI, "characteristics");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeCharacteristicList(writer, (CharacteristicList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getCapabilitiesList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getCapabilitiesList().getProperty(i);
            writer.writeStartElement(NS_URI, "capabilities");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeCapabilityList(writer, (CapabilityList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getContactsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getContactsList().getProperty(i);
            writer.writeStartElement(NS_URI, "contacts");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeContactList(writer, (ContactList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getDocumentationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getDocumentationList().getProperty(i);
            writer.writeStartElement(NS_URI, "documentation");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeDocumentList(writer, (DocumentList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getHistoryList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getHistoryList().getProperty(i);
            writer.writeStartElement(NS_URI, "history");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeEventList(writer, (EventList)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public void readAbstractProcessTypeAttributes(Map<String, String> attrMap, AbstractProcess bean) throws XMLStreamException {
        this.readDescribedObjectTypeAttributes(attrMap, bean);
        String val = attrMap.get("definition");
        if (val != null) {
            bean.setDefinition(val);
        }
    }

    public void readAbstractProcessTypeElements(XMLStreamReader reader, AbstractProcess bean) throws XMLStreamException {
        this.readDescribedObjectTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "typeOf");
        if (found) {
            bean.setTypeOf(this.ns2Bindings.readReferenceType(reader));
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "configuration")) {
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.setConfiguration(this.readAbstractSettings(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "featuresOfInterest")) {
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.setFeaturesOfInterest(this.readFeatureList(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "inputs")) {
            reader.nextTag();
            reader.nextTag();
            if (reader.getEventType() == 1) {
                do {
                    if (!(found = this.checkElementName(reader, "input"))) continue;
                    OgcPropertyImpl inputProp = new OgcPropertyImpl();
                    this.readPropertyAttributes(reader, (OgcProperty)inputProp);
                    reader.nextTag();
                    if (reader.getEventType() == 1) {
                        this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)inputProp);
                        reader.nextTag();
                    } else if (inputProp.hasHref()) {
                        inputProp.setHrefResolver((HrefResolver)new HrefResolverXML((OgcProperty)inputProp){
                            final /* synthetic */ OgcProperty val$inputProp;
                            {
                                this.val$inputProp = ogcProperty;
                            }

                            public void parseContent(XMLStreamReader reader) throws XMLStreamException {
                                XMLStreamBindings.this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)this.val$inputProp);
                            }
                        });
                    }
                    bean.getInputList().add((OgcProperty)inputProp);
                    reader.nextTag();
                } while (found);
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "outputs")) {
            reader.nextTag();
            reader.nextTag();
            if (reader.getEventType() == 1) {
                do {
                    if (!(found = this.checkElementName(reader, "output"))) continue;
                    OgcPropertyImpl outputProp = new OgcPropertyImpl();
                    this.readPropertyAttributes(reader, (OgcProperty)outputProp);
                    reader.nextTag();
                    if (reader.getEventType() == 1) {
                        this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)outputProp);
                        reader.nextTag();
                    } else if (outputProp.hasHref()) {
                        outputProp.setHrefResolver((HrefResolver)new HrefResolverXML((OgcProperty)outputProp){
                            final /* synthetic */ OgcProperty val$outputProp;
                            {
                                this.val$outputProp = ogcProperty;
                            }

                            public void parseContent(XMLStreamReader reader) throws XMLStreamException {
                                XMLStreamBindings.this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)this.val$outputProp);
                            }
                        });
                    }
                    bean.getOutputList().add((OgcProperty)outputProp);
                    reader.nextTag();
                } while (found);
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "parameters")) {
            reader.nextTag();
            reader.nextTag();
            if (reader.getEventType() == 1) {
                do {
                    if (!(found = this.checkElementName(reader, "parameter"))) continue;
                    OgcPropertyImpl parameterProp = new OgcPropertyImpl();
                    this.readPropertyAttributes(reader, (OgcProperty)parameterProp);
                    reader.nextTag();
                    if (reader.getEventType() == 1) {
                        this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)parameterProp);
                        reader.nextTag();
                    } else if (parameterProp.hasHref()) {
                        parameterProp.setHrefResolver((HrefResolver)new HrefResolverXML((OgcProperty)parameterProp){
                            final /* synthetic */ OgcProperty val$parameterProp;
                            {
                                this.val$parameterProp = ogcProperty;
                            }

                            public void parseContent(XMLStreamReader reader) throws XMLStreamException {
                                XMLStreamBindings.this.readIOChoice(reader, (OgcProperty<AbstractSWEIdentifiable>)this.val$parameterProp);
                            }
                        });
                    }
                    bean.getParameterList().add((OgcProperty)parameterProp);
                    reader.nextTag();
                } while (found);
                reader.nextTag();
            }
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "modes"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addModes(this.readAbstractModes(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
    }

    public void writeAbstractProcessTypeAttributes(XMLStreamWriter writer, AbstractProcess bean) throws XMLStreamException {
        this.writeDescribedObjectTypeAttributes(writer, bean);
        if (bean.isSetDefinition()) {
            writer.writeAttribute("definition", this.getStringValue(bean.getDefinition()));
        }
    }

    public void writeAbstractProcessTypeElements(XMLStreamWriter writer, AbstractProcess bean) throws XMLStreamException {
        AbstractModes item;
        int i;
        int numItems;
        this.writeDescribedObjectTypeElements(writer, bean);
        if (bean.isSetTypeOf()) {
            writer.writeStartElement(NS_URI, "typeOf");
            this.ns2Bindings.writeReferenceType(writer, bean.getTypeOf());
            writer.writeEndElement();
        }
        if (bean.isSetConfiguration()) {
            writer.writeStartElement(NS_URI, "configuration");
            this.writeAbstractSettings(writer, bean.getConfiguration());
            writer.writeEndElement();
        }
        if (bean.isSetFeaturesOfInterest()) {
            writer.writeStartElement(NS_URI, "featuresOfInterest");
            this.writeFeatureList(writer, bean.getFeaturesOfInterest());
            writer.writeEndElement();
        }
        if (bean.getNumInputs() > 0) {
            writer.writeStartElement(NS_URI, "inputs");
            writer.writeStartElement(NS_URI, "InputList");
            numItems = bean.getInputList().size();
            for (i = 0; i < numItems; ++i) {
                item = bean.getInputList().getProperty(i);
                writer.writeStartElement(NS_URI, "input");
                this.writePropertyAttributes(writer, (OgcProperty)item);
                if (item.hasValue() && !item.hasHref()) {
                    if (item.getValue() instanceof ObservableProperty) {
                        this.writeObservableProperty(writer, (ObservableProperty)item.getValue());
                    } else if (item.getValue() instanceof DataStream) {
                        this.ns1Bindings.writeDataStream(writer, (DataStream)item.getValue());
                    } else if (item.getValue() instanceof DataInterface) {
                        this.writeDataInterface(writer, (DataInterface)item.getValue());
                    } else if (item.getValue() instanceof DataComponent) {
                        this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), false);
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (bean.getNumOutputs() > 0) {
            writer.writeStartElement(NS_URI, "outputs");
            writer.writeStartElement(NS_URI, "OutputList");
            numItems = bean.getOutputList().size();
            for (i = 0; i < numItems; ++i) {
                item = bean.getOutputList().getProperty(i);
                writer.writeStartElement(NS_URI, "output");
                this.writePropertyAttributes(writer, (OgcProperty)item);
                if (item.hasValue() && !item.hasHref()) {
                    if (item.getValue() instanceof ObservableProperty) {
                        this.writeObservableProperty(writer, (ObservableProperty)item.getValue());
                    } else if (item.getValue() instanceof DataStream) {
                        this.ns1Bindings.writeDataStream(writer, (DataStream)item.getValue());
                    } else if (item.getValue() instanceof DataInterface) {
                        this.writeDataInterface(writer, (DataInterface)item.getValue());
                    } else if (item.getValue() instanceof DataComponent) {
                        this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), false);
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (bean.getNumParameters() > 0) {
            writer.writeStartElement(NS_URI, "parameters");
            writer.writeStartElement(NS_URI, "ParameterList");
            numItems = bean.getParameterList().size();
            for (i = 0; i < numItems; ++i) {
                item = bean.getParameterList().getProperty(i);
                writer.writeStartElement(NS_URI, "parameter");
                this.writePropertyAttributes(writer, (OgcProperty)item);
                if (item.hasValue() && !item.hasHref()) {
                    if (item.getValue() instanceof ObservableProperty) {
                        this.writeObservableProperty(writer, (ObservableProperty)item.getValue());
                    } else if (item.getValue() instanceof DataStream) {
                        this.ns1Bindings.writeDataStream(writer, (DataStream)item.getValue());
                    } else if (item.getValue() instanceof DataInterface) {
                        this.writeDataInterface(writer, (DataInterface)item.getValue());
                    } else if (item.getValue() instanceof DataComponent) {
                        this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), true);
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        numItems = bean.getModesList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getModesList().get(i);
            writer.writeStartElement(NS_URI, "modes");
            this.writeAbstractModes(writer, item);
            writer.writeEndElement();
        }
    }

    public AbstractSettings readAbstractSettingsType(XMLStreamReader reader) throws XMLStreamException {
        AbstractSettings bean = this.factory.newAbstractSettings();
        Map attrMap = this.collectAttributes(reader);
        this.readAbstractSettingsTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readAbstractSettingsTypeElements(reader, bean);
        return bean;
    }

    public void readAbstractSettingsTypeAttributes(Map<String, String> attrMap, AbstractSettings bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWETypeAttributes(attrMap, (AbstractSWE)bean);
    }

    public void readAbstractSettingsTypeElements(XMLStreamReader reader, AbstractSettings bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWETypeElements(reader, (AbstractSWE)bean);
    }

    public void writeAbstractSettingsType(XMLStreamWriter writer, AbstractSettings bean) throws XMLStreamException {
        this.writeAbstractSettingsTypeAttributes(writer, bean);
        this.writeAbstractSettingsTypeElements(writer, bean);
    }

    public void writeAbstractSettingsTypeAttributes(XMLStreamWriter writer, AbstractSettings bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeAttributes(writer, (AbstractSWE)bean);
    }

    public void writeAbstractSettingsTypeElements(XMLStreamWriter writer, AbstractSettings bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeElements(writer, (AbstractSWE)bean);
    }

    public IdentifierList readIdentifierListType(XMLStreamReader reader) throws XMLStreamException {
        IdentifierList bean = this.factory.newIdentifierList();
        Map attrMap = this.collectAttributes(reader);
        this.readIdentifierListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readIdentifierListTypeElements(reader, bean);
        return bean;
    }

    public void readIdentifierListTypeAttributes(Map<String, String> attrMap, IdentifierList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readIdentifierListTypeElements(XMLStreamReader reader, IdentifierList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "identifier"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addIdentifier2(this.readTerm(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
    }

    public void writeIdentifierListType(XMLStreamWriter writer, IdentifierList bean) throws XMLStreamException {
        this.writeIdentifierListTypeAttributes(writer, bean);
        this.writeIdentifierListTypeElements(writer, bean);
    }

    public void writeIdentifierListTypeAttributes(XMLStreamWriter writer, IdentifierList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeIdentifierListTypeElements(XMLStreamWriter writer, IdentifierList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getIdentifier2List().size();
        for (int i = 0; i < numItems; ++i) {
            Term item = bean.getIdentifier2List().get(i);
            writer.writeStartElement(NS_URI, "identifier");
            this.writeTerm(writer, item);
            writer.writeEndElement();
        }
    }

    protected void readIOChoice(XMLStreamReader reader, OgcProperty<AbstractSWEIdentifiable> prop) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("ObservableProperty")) {
            ObservableProperty signal = this.readObservableProperty(reader);
            prop.setValue((Object)signal);
        } else if (localName.equals("DataStream")) {
            DataStream signal = this.ns1Bindings.readDataStream(reader);
            prop.setValue((Object)signal);
        } else if (localName.equals("DataInterface")) {
            DataInterface signal = this.readDataInterface(reader);
            prop.setValue((Object)signal);
        } else {
            DataComponent signal = this.ns1Bindings.readDataComponent(reader);
            prop.setValue((Object)signal);
        }
    }

    public DocumentList readDocumentListType(XMLStreamReader reader) throws XMLStreamException {
        DocumentList bean = this.factory.newDocumentList();
        Map attrMap = this.collectAttributes(reader);
        this.readDocumentListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readDocumentListTypeElements(reader, bean);
        return bean;
    }

    public void readDocumentListTypeAttributes(Map<String, String> attrMap, DocumentList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readDocumentListTypeElements(XMLStreamReader reader, DocumentList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "document"))) continue;
            OgcPropertyImpl documentProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)documentProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                documentProp.setValue((Object)this.ns3Bindings.readCIOnlineResource(reader));
                reader.nextTag();
            }
            bean.getDocumentList().add((OgcProperty)documentProp);
            reader.nextTag();
        } while (found);
    }

    public void writeDocumentListType(XMLStreamWriter writer, DocumentList bean) throws XMLStreamException {
        this.writeDocumentListTypeAttributes(writer, bean);
        this.writeDocumentListTypeElements(writer, bean);
    }

    public void writeDocumentListTypeAttributes(XMLStreamWriter writer, DocumentList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeDocumentListTypeElements(XMLStreamWriter writer, DocumentList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getDocumentList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getDocumentList().getProperty(i);
            writer.writeStartElement(NS_URI, "document");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns3Bindings.writeCIOnlineResource(writer, (CIOnlineResource)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public CharacteristicList readCharacteristicListType(XMLStreamReader reader) throws XMLStreamException {
        CharacteristicList bean = this.factory.newCharacteristicList();
        Map attrMap = this.collectAttributes(reader);
        this.readCharacteristicListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readCharacteristicListTypeElements(reader, bean);
        return bean;
    }

    public void readCharacteristicListTypeAttributes(Map<String, String> attrMap, CharacteristicList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readCharacteristicListTypeElements(XMLStreamReader reader, CharacteristicList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "characteristic"))) continue;
            OgcPropertyImpl characteristicProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)characteristicProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                characteristicProp.setValue((Object)this.ns1Bindings.readDataComponent(reader));
                reader.nextTag();
            }
            bean.getCharacteristicList().add((OgcProperty)characteristicProp);
            reader.nextTag();
        } while (found);
    }

    public void writeCharacteristicListType(XMLStreamWriter writer, CharacteristicList bean) throws XMLStreamException {
        this.writeCharacteristicListTypeAttributes(writer, bean);
        this.writeCharacteristicListTypeElements(writer, bean);
    }

    public void writeCharacteristicListTypeAttributes(XMLStreamWriter writer, CharacteristicList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeCharacteristicListTypeElements(XMLStreamWriter writer, CharacteristicList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getCharacteristicList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getCharacteristicList().getProperty(i);
            writer.writeStartElement(NS_URI, "characteristic");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), true);
            }
            writer.writeEndElement();
        }
    }

    public FeatureList readFeatureListType(XMLStreamReader reader) throws XMLStreamException {
        FeatureList bean = this.factory.newFeatureList();
        Map attrMap = this.collectAttributes(reader);
        this.readFeatureListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readFeatureListTypeElements(reader, bean);
        return bean;
    }

    public void readFeatureListTypeAttributes(Map<String, String> attrMap, FeatureList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readFeatureListTypeElements(XMLStreamReader reader, FeatureList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "feature"))) continue;
            OgcPropertyImpl featureProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)featureProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                featureProp.setValue((Object)this.ns2Bindings.readAbstractFeature(reader));
                reader.nextTag();
            }
            bean.getFeatureList().add((OgcProperty)featureProp);
            reader.nextTag();
        } while (found);
    }

    public void writeFeatureListType(XMLStreamWriter writer, FeatureList bean) throws XMLStreamException {
        this.writeFeatureListTypeAttributes(writer, bean);
        this.writeFeatureListTypeElements(writer, bean);
    }

    public void writeFeatureListTypeAttributes(XMLStreamWriter writer, FeatureList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeFeatureListTypeElements(XMLStreamWriter writer, FeatureList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getFeatureList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getFeatureList().getProperty(i);
            writer.writeStartElement(NS_URI, "feature");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns2Bindings.writeAbstractFeature(writer, (AbstractFeature)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public Event readEventType(XMLStreamReader reader) throws XMLStreamException {
        Event bean = this.factory.newEvent();
        Map attrMap = this.collectAttributes(reader);
        this.readEventTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readEventTypeElements(reader, bean);
        return bean;
    }

    public void readEventTypeAttributes(Map<String, String> attrMap, Event bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
        String val = attrMap.get("definition");
        if (val != null) {
            bean.setDefinition(val);
        }
    }

    public void readEventTypeElements(XMLStreamReader reader, Event bean) throws XMLStreamException {
        boolean found;
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
        do {
            if (!(found = this.checkElementName(reader, "keywords"))) continue;
            OgcPropertyImpl keywordsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)keywordsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                keywordsProp.setValue((Object)this.ns3Bindings.readMDKeywords(reader));
                reader.nextTag();
            }
            bean.getKeywordsList().add((OgcProperty)keywordsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "identification"))) continue;
            OgcPropertyImpl identificationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)identificationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                identificationProp.setValue((Object)this.readIdentifierList(reader));
                reader.nextTag();
            }
            bean.getIdentificationList().add((OgcProperty)identificationProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "classification"))) continue;
            OgcPropertyImpl classificationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)classificationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                classificationProp.setValue((Object)this.readClassifierList(reader));
                reader.nextTag();
            }
            bean.getClassificationList().add((OgcProperty)classificationProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "contacts"))) continue;
            OgcPropertyImpl contactsProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)contactsProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                contactsProp.setValue((Object)this.readContactList(reader));
                reader.nextTag();
            }
            bean.getContactsList().add((OgcProperty)contactsProp);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "documentation"))) continue;
            OgcPropertyImpl documentationProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)documentationProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                documentationProp.setValue((Object)this.readDocumentList(reader));
                reader.nextTag();
            }
            bean.getDocumentationList().add((OgcProperty)documentationProp);
            reader.nextTag();
        } while (found);
        found = this.checkElementName(reader, "time");
        if (found) {
            reader.nextTag();
            if (reader.getEventType() == 1) {
                TimePeriod time;
                String localName = reader.getName().getLocalPart();
                if (localName.equals("TimePeriod")) {
                    time = this.ns2Bindings.readTimePeriod(reader);
                    bean.setTimeAsTimePeriod(time);
                } else if (localName.equals("TimeInstant")) {
                    time = this.ns2Bindings.readTimeInstant(reader);
                    bean.setTimeAsTimeInstant((TimeInstant)time);
                } else {
                    throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
                }
                reader.nextTag();
            }
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "property"))) continue;
            OgcPropertyImpl propertyProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)propertyProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                propertyProp.setValue((Object)this.ns1Bindings.readDataComponent(reader));
                reader.nextTag();
            }
            bean.getPropertyList().add((OgcProperty)propertyProp);
            reader.nextTag();
        } while (found);
        found = this.checkElementName(reader, "configuration");
        if (found) {
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.setConfiguration(this.readAbstractSettings(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writeEventType(XMLStreamWriter writer, Event bean) throws XMLStreamException {
        this.writeEventTypeAttributes(writer, bean);
        this.writeEventTypeElements(writer, bean);
    }

    public void writeEventTypeAttributes(XMLStreamWriter writer, Event bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
        if (bean.isSetDefinition()) {
            writer.writeAttribute("definition", this.getStringValue(bean.getDefinition()));
        }
    }

    public void writeEventTypeElements(XMLStreamWriter writer, Event bean) throws XMLStreamException {
        OgcProperty item;
        int i;
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
        int numItems = bean.getKeywordsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getKeywordsList().getProperty(i);
            writer.writeStartElement(NS_URI, "keywords");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns3Bindings.writeMDKeywords(writer, (MDKeywords)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getIdentificationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getIdentificationList().getProperty(i);
            writer.writeStartElement(NS_URI, "identification");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeIdentifierList(writer, (IdentifierList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getClassificationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getClassificationList().getProperty(i);
            writer.writeStartElement(NS_URI, "classification");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeClassifierList(writer, (ClassifierList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getContactsList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getContactsList().getProperty(i);
            writer.writeStartElement(NS_URI, "contacts");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeContactList(writer, (ContactList)item.getValue());
            }
            writer.writeEndElement();
        }
        numItems = bean.getDocumentationList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getDocumentationList().getProperty(i);
            writer.writeStartElement(NS_URI, "documentation");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeDocumentList(writer, (DocumentList)item.getValue());
            }
            writer.writeEndElement();
        }
        writer.writeStartElement(NS_URI, "time");
        if (bean.getTime() instanceof TimePeriod) {
            this.ns2Bindings.writeTimePeriod(writer, (TimePeriod)bean.getTime());
        } else if (bean.getTime() instanceof TimeInstant) {
            this.ns2Bindings.writeTimeInstant(writer, (TimeInstant)bean.getTime());
        }
        writer.writeEndElement();
        numItems = bean.getPropertyList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getPropertyList().getProperty(i);
            writer.writeStartElement(NS_URI, "property");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), true);
            }
            writer.writeEndElement();
        }
        if (bean.isSetConfiguration()) {
            writer.writeStartElement(NS_URI, "configuration");
            this.writeAbstractSettings(writer, bean.getConfiguration());
            writer.writeEndElement();
        }
    }

    public CapabilityList readCapabilityListType(XMLStreamReader reader) throws XMLStreamException {
        CapabilityList bean = this.factory.newCapabilityList();
        Map attrMap = this.collectAttributes(reader);
        this.readCapabilityListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readCapabilityListTypeElements(reader, bean);
        return bean;
    }

    public void readCapabilityListTypeAttributes(Map<String, String> attrMap, CapabilityList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readCapabilityListTypeElements(XMLStreamReader reader, CapabilityList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "capability"))) continue;
            OgcPropertyImpl capabilityProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)capabilityProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                capabilityProp.setValue((Object)this.ns1Bindings.readDataComponent(reader));
                reader.nextTag();
            }
            bean.getCapabilityList().add((OgcProperty)capabilityProp);
            reader.nextTag();
        } while (found);
    }

    public void writeCapabilityListType(XMLStreamWriter writer, CapabilityList bean) throws XMLStreamException {
        this.writeCapabilityListTypeAttributes(writer, bean);
        this.writeCapabilityListTypeElements(writer, bean);
    }

    public void writeCapabilityListTypeAttributes(XMLStreamWriter writer, CapabilityList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeCapabilityListTypeElements(XMLStreamWriter writer, CapabilityList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getCapabilityList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getCapabilityList().getProperty(i);
            writer.writeStartElement(NS_URI, "capability");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns1Bindings.writeDataComponent(writer, (DataComponent)item.getValue(), true);
            }
            writer.writeEndElement();
        }
    }

    public EventList readEventListType(XMLStreamReader reader) throws XMLStreamException {
        EventList bean = this.factory.newEventList();
        Map attrMap = this.collectAttributes(reader);
        this.readEventListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readEventListTypeElements(reader, bean);
        return bean;
    }

    public void readEventListTypeAttributes(Map<String, String> attrMap, EventList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readEventListTypeElements(XMLStreamReader reader, EventList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "event"))) continue;
            OgcPropertyImpl eventProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)eventProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                eventProp.setValue((Object)this.readEvent(reader));
                reader.nextTag();
            }
            bean.getEventList().add((OgcProperty)eventProp);
            reader.nextTag();
        } while (found);
    }

    public void writeEventListType(XMLStreamWriter writer, EventList bean) throws XMLStreamException {
        this.writeEventListTypeAttributes(writer, bean);
        this.writeEventListTypeElements(writer, bean);
    }

    public void writeEventListTypeAttributes(XMLStreamWriter writer, EventList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeEventListTypeElements(XMLStreamWriter writer, EventList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getEventList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getEventList().getProperty(i);
            writer.writeStartElement(NS_URI, "event");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.writeEvent(writer, (Event)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public AbstractMetadataList readAbstractMetadataListType(XMLStreamReader reader) throws XMLStreamException {
        AbstractMetadataList bean = this.factory.newAbstractMetadataList();
        Map attrMap = this.collectAttributes(reader);
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readAbstractMetadataListTypeElements(reader, bean);
        return bean;
    }

    public void readAbstractMetadataListTypeAttributes(Map<String, String> attrMap, AbstractMetadataList bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
        String val = attrMap.get("definition");
        if (val != null) {
            bean.setDefinition(val);
        }
    }

    public void readAbstractMetadataListTypeElements(XMLStreamReader reader, AbstractMetadataList bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
    }

    public void writeAbstractMetadataListType(XMLStreamWriter writer, AbstractMetadataList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
        this.writeAbstractMetadataListTypeElements(writer, bean);
    }

    public void writeAbstractMetadataListTypeAttributes(XMLStreamWriter writer, AbstractMetadataList bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
        if (bean.isSetDefinition()) {
            writer.writeAttribute("definition", this.getStringValue(bean.getDefinition()));
        }
    }

    public void writeAbstractMetadataListTypeElements(XMLStreamWriter writer, AbstractMetadataList bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
    }

    public ContactList readContactListType(XMLStreamReader reader) throws XMLStreamException {
        ContactList bean = this.factory.newContactList();
        Map attrMap = this.collectAttributes(reader);
        this.readContactListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readContactListTypeElements(reader, bean);
        return bean;
    }

    public void readContactListTypeAttributes(Map<String, String> attrMap, ContactList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readContactListTypeElements(XMLStreamReader reader, ContactList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "contact"))) continue;
            OgcPropertyImpl contactProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)contactProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                contactProp.setValue((Object)this.ns3Bindings.readCIResponsibleParty(reader));
                reader.nextTag();
            }
            bean.getContactList().add((OgcProperty)contactProp);
            reader.nextTag();
        } while (found);
    }

    public void writeContactListType(XMLStreamWriter writer, ContactList bean) throws XMLStreamException {
        this.writeContactListTypeAttributes(writer, bean);
        this.writeContactListTypeElements(writer, bean);
    }

    public void writeContactListTypeAttributes(XMLStreamWriter writer, ContactList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeContactListTypeElements(XMLStreamWriter writer, ContactList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getContactList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getContactList().getProperty(i);
            writer.writeStartElement(NS_URI, "contact");
            this.writePropertyAttributes(writer, item);
            if (item.hasValue() && !item.hasHref()) {
                this.ns3Bindings.writeCIResponsibleParty(writer, (CIResponsibleParty)item.getValue());
            }
            writer.writeEndElement();
        }
    }

    public KeywordList readKeywordListType(XMLStreamReader reader) throws XMLStreamException {
        KeywordList bean = this.factory.newKeywordList();
        Map attrMap = this.collectAttributes(reader);
        this.readKeywordListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readKeywordListTypeElements(reader, bean);
        return bean;
    }

    public void readKeywordListTypeAttributes(Map<String, String> attrMap, KeywordList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readKeywordListTypeElements(XMLStreamReader reader, KeywordList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "codeSpace");
        if (found) {
            Reference ref = this.ns2Bindings.readReferenceType(reader);
            bean.setCodeSpace(ref.getHref());
            reader.nextTag();
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "keyword"))) continue;
            String val = reader.getElementText();
            if (val != null) {
                bean.addKeyword(val);
            }
            reader.nextTag();
        } while (found);
    }

    public void writeKeywordListType(XMLStreamWriter writer, KeywordList bean) throws XMLStreamException {
        this.writeKeywordListTypeAttributes(writer, bean);
        this.writeKeywordListTypeElements(writer, bean);
    }

    public void writeKeywordListTypeAttributes(XMLStreamWriter writer, KeywordList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeKeywordListTypeElements(XMLStreamWriter writer, KeywordList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        if (bean.isSetCodeSpace()) {
            writer.writeStartElement(NS_URI, "codeSpace");
            writer.writeAttribute("http://www.w3.org/1999/xlink", "href", bean.getCodeSpace());
            writer.writeEndElement();
        }
        int numItems = bean.getKeywordList().size();
        for (int i = 0; i < numItems; ++i) {
            String item = bean.getKeywordList().get(i);
            writer.writeStartElement(NS_URI, "keyword");
            writer.writeCharacters(item);
            writer.writeEndElement();
        }
    }

    public Term readTermType(XMLStreamReader reader) throws XMLStreamException {
        Term bean = this.factory.newTerm();
        Map attrMap = this.collectAttributes(reader);
        this.readTermTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readTermTypeElements(reader, bean);
        return bean;
    }

    public void readTermTypeAttributes(Map<String, String> attrMap, Term bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWETypeAttributes(attrMap, (AbstractSWE)bean);
        String val = attrMap.get("definition");
        if (val != null) {
            bean.setDefinition(val);
        }
    }

    public void readTermTypeElements(XMLStreamReader reader, Term bean) throws XMLStreamException {
        String val;
        this.ns1Bindings.readAbstractSWETypeElements(reader, (AbstractSWE)bean);
        boolean found = this.checkElementName(reader, "label");
        if (found) {
            val = reader.getElementText();
            if (val != null) {
                bean.setLabel(val);
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "codeSpace")) {
            Reference ref = this.ns2Bindings.readReferenceType(reader);
            bean.setCodeSpace(ref.getHref());
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "value")) {
            val = reader.getElementText();
            if (val != null) {
                bean.setValue(val);
            }
            reader.nextTag();
        }
    }

    public void writeTermType(XMLStreamWriter writer, Term bean) throws XMLStreamException {
        this.writeTermTypeAttributes(writer, bean);
        this.writeTermTypeElements(writer, bean);
    }

    public void writeTermTypeAttributes(XMLStreamWriter writer, Term bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeAttributes(writer, (AbstractSWE)bean);
        if (bean.isSetDefinition()) {
            writer.writeAttribute("definition", this.getStringValue(bean.getDefinition()));
        }
    }

    public void writeTermTypeElements(XMLStreamWriter writer, Term bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeElements(writer, (AbstractSWE)bean);
        writer.writeStartElement(NS_URI, "label");
        writer.writeCharacters(bean.getLabel());
        writer.writeEndElement();
        if (bean.isSetCodeSpace()) {
            writer.writeStartElement(NS_URI, "codeSpace");
            writer.writeAttribute("http://www.w3.org/1999/xlink", "href", bean.getCodeSpace());
            writer.writeEndElement();
        }
        writer.writeStartElement(NS_URI, "value");
        writer.writeCharacters(bean.getValue());
        writer.writeEndElement();
    }

    public ClassifierList readClassifierListType(XMLStreamReader reader) throws XMLStreamException {
        ClassifierList bean = this.factory.newClassifierList();
        Map attrMap = this.collectAttributes(reader);
        this.readClassifierListTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readClassifierListTypeElements(reader, bean);
        return bean;
    }

    public void readClassifierListTypeAttributes(Map<String, String> attrMap, ClassifierList bean) throws XMLStreamException {
        this.readAbstractMetadataListTypeAttributes(attrMap, bean);
    }

    public void readClassifierListTypeElements(XMLStreamReader reader, ClassifierList bean) throws XMLStreamException {
        boolean found;
        this.readAbstractMetadataListTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "classifier"))) continue;
            reader.nextTag();
            if (reader.getEventType() == 1) {
                bean.addClassifier(this.readTerm(reader));
                reader.nextTag();
            }
            reader.nextTag();
        } while (found);
    }

    public void writeClassifierListType(XMLStreamWriter writer, ClassifierList bean) throws XMLStreamException {
        this.writeClassifierListTypeAttributes(writer, bean);
        this.writeClassifierListTypeElements(writer, bean);
    }

    public void writeClassifierListTypeAttributes(XMLStreamWriter writer, ClassifierList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeAttributes(writer, bean);
    }

    public void writeClassifierListTypeElements(XMLStreamWriter writer, ClassifierList bean) throws XMLStreamException {
        this.writeAbstractMetadataListTypeElements(writer, bean);
        int numItems = bean.getClassifierList().size();
        for (int i = 0; i < numItems; ++i) {
            Term item = bean.getClassifierList().get(i);
            writer.writeStartElement(NS_URI, "classifier");
            this.writeTerm(writer, item);
            writer.writeEndElement();
        }
    }

    public AbstractModes readAbstractModesType(XMLStreamReader reader) throws XMLStreamException {
        AbstractModes bean = this.factory.newAbstractModes();
        Map attrMap = this.collectAttributes(reader);
        this.readAbstractModesTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readAbstractModesTypeElements(reader, bean);
        return bean;
    }

    public void readAbstractModesTypeAttributes(Map<String, String> attrMap, AbstractModes bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWETypeAttributes(attrMap, (AbstractSWE)bean);
    }

    public void readAbstractModesTypeElements(XMLStreamReader reader, AbstractModes bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWETypeElements(reader, (AbstractSWE)bean);
    }

    public void writeAbstractModesType(XMLStreamWriter writer, AbstractModes bean) throws XMLStreamException {
        this.writeAbstractModesTypeAttributes(writer, bean);
        this.writeAbstractModesTypeElements(writer, bean);
    }

    public void writeAbstractModesTypeAttributes(XMLStreamWriter writer, AbstractModes bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeAttributes(writer, (AbstractSWE)bean);
    }

    public void writeAbstractModesTypeElements(XMLStreamWriter writer, AbstractModes bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWETypeElements(writer, (AbstractSWE)bean);
    }

    public DataInterface readDataInterfaceType(XMLStreamReader reader) throws XMLStreamException {
        DataInterface bean = this.factory.newDataInterface();
        Map attrMap = this.collectAttributes(reader);
        this.readDataInterfaceTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readDataInterfaceTypeElements(reader, bean);
        return bean;
    }

    public void readDataInterfaceTypeAttributes(Map<String, String> attrMap, DataInterface bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
    }

    public void readDataInterfaceTypeElements(XMLStreamReader reader, DataInterface bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
        boolean found = this.checkElementName(reader, "data");
        if (found) {
            OgcProperty<DataStream> dataProp = bean.getDataProperty();
            this.readPropertyAttributes(reader, dataProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                dataProp.setValue((Object)this.ns1Bindings.readDataStream(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "interfaceParameters")) {
            OgcProperty<DataRecord> interfaceParametersProp = bean.getInterfaceParametersProperty();
            this.readPropertyAttributes(reader, interfaceParametersProp);
            reader.nextTag();
            if (reader.getEventType() == 1) {
                interfaceParametersProp.setValue((Object)this.ns1Bindings.readDataRecord(reader));
                reader.nextTag();
            }
            reader.nextTag();
        }
    }

    public void writeDataInterfaceType(XMLStreamWriter writer, DataInterface bean) throws XMLStreamException {
        this.writeDataInterfaceTypeAttributes(writer, bean);
        this.writeDataInterfaceTypeElements(writer, bean);
    }

    public void writeDataInterfaceTypeAttributes(XMLStreamWriter writer, DataInterface bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
    }

    public void writeDataInterfaceTypeElements(XMLStreamWriter writer, DataInterface bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
        writer.writeStartElement(NS_URI, "data");
        OgcProperty<DataStream> dataProp = bean.getDataProperty();
        this.writePropertyAttributes(writer, dataProp);
        if (dataProp.hasValue() && !dataProp.hasHref()) {
            this.ns1Bindings.writeDataStream(writer, bean.getData());
        }
        writer.writeEndElement();
        if (bean.isSetInterfaceParameters()) {
            writer.writeStartElement(NS_URI, "interfaceParameters");
            OgcProperty<DataRecord> interfaceParametersProp = bean.getInterfaceParametersProperty();
            this.writePropertyAttributes(writer, interfaceParametersProp);
            if (interfaceParametersProp.hasValue() && !interfaceParametersProp.hasHref()) {
                this.ns1Bindings.writeDataRecord(writer, bean.getInterfaceParameters(), true);
            }
            writer.writeEndElement();
        }
    }

    public ObservableProperty readObservablePropertyType(XMLStreamReader reader) throws XMLStreamException {
        ObservableProperty bean = this.factory.newObservableProperty();
        Map attrMap = this.collectAttributes(reader);
        this.readObservablePropertyTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readObservablePropertyTypeElements(reader, bean);
        return bean;
    }

    public void readObservablePropertyTypeAttributes(Map<String, String> attrMap, ObservableProperty bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeAttributes(attrMap, (AbstractSWEIdentifiable)bean);
        String val = attrMap.get("definition");
        if (val != null) {
            bean.setDefinition(val);
        }
    }

    public void readObservablePropertyTypeElements(XMLStreamReader reader, ObservableProperty bean) throws XMLStreamException {
        this.ns1Bindings.readAbstractSWEIdentifiableTypeElements(reader, (AbstractSWEIdentifiable)bean);
    }

    public void writeObservablePropertyType(XMLStreamWriter writer, ObservableProperty bean) throws XMLStreamException {
        this.writeObservablePropertyTypeAttributes(writer, bean);
        this.writeObservablePropertyTypeElements(writer, bean);
    }

    public void writeObservablePropertyTypeAttributes(XMLStreamWriter writer, ObservableProperty bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeAttributes(writer, (AbstractSWEIdentifiable)bean);
        writer.writeAttribute("definition", this.getStringValue(bean.getDefinition()));
    }

    public void writeObservablePropertyTypeElements(XMLStreamWriter writer, ObservableProperty bean) throws XMLStreamException {
        this.ns1Bindings.writeAbstractSWEIdentifiableTypeElements(writer, (AbstractSWEIdentifiable)bean);
    }

    public SimpleProcess readSimpleProcess(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "SimpleProcess");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readSimpleProcessType(reader);
    }

    public void writeSimpleProcess(XMLStreamWriter writer, SimpleProcess bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "SimpleProcess");
        this.writeNamespaces(writer);
        this.writeSimpleProcessType(writer, bean);
        writer.writeEndElement();
    }

    public ProcessMethod readProcessMethod(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "ProcessMethod");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readProcessMethodType(reader);
    }

    public void writeProcessMethod(XMLStreamWriter writer, ProcessMethod bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "ProcessMethod");
        this.writeNamespaces(writer);
        this.writeProcessMethodType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractAlgorithm readAbstractAlgorithm(XMLStreamReader reader) throws XMLStreamException {
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractAlgorithm(XMLStreamWriter writer, AbstractAlgorithm bean) throws XMLStreamException {
    }

    public Mode readMode(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Mode");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readModeType(reader);
    }

    public void writeMode(XMLStreamWriter writer, Mode bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Mode");
        this.writeNamespaces(writer);
        this.writeModeType(writer, bean);
        writer.writeEndElement();
    }

    public ModeChoice readModeChoice(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "ModeChoice");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readModeChoiceType(reader);
    }

    public void writeModeChoice(XMLStreamWriter writer, ModeChoice bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "ModeChoice");
        this.writeNamespaces(writer);
        this.writeModeChoiceType(writer, bean);
        writer.writeEndElement();
    }

    public Settings readSettings(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Settings");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readSettingsType(reader);
    }

    public void writeSettings(XMLStreamWriter writer, Settings bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Settings");
        this.writeNamespaces(writer);
        this.writeSettingsType(writer, bean);
        writer.writeEndElement();
    }

    public PhysicalSystem readPhysicalSystem(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "PhysicalSystem");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readPhysicalSystemType(reader);
    }

    public void writePhysicalSystem(XMLStreamWriter writer, PhysicalSystem bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "PhysicalSystem");
        this.writeNamespaces(writer);
        this.writePhysicalSystemType(writer, bean);
        writer.writeEndElement();
    }

    public PhysicalComponent readPhysicalComponent(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "PhysicalComponent");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readPhysicalComponentType(reader);
    }

    public void writePhysicalComponent(XMLStreamWriter writer, PhysicalComponent bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "PhysicalComponent");
        this.writeNamespaces(writer);
        this.writePhysicalComponentType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractPhysicalProcess readAbstractPhysicalProcess(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("PhysicalSystem")) {
            return this.readPhysicalSystem(reader);
        }
        if (localName.equals("PhysicalComponent")) {
            return this.readPhysicalComponent(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractPhysicalProcess(XMLStreamWriter writer, AbstractPhysicalProcess bean) throws XMLStreamException {
        if (bean instanceof PhysicalSystem) {
            this.writePhysicalSystem(writer, (PhysicalSystem)bean);
        } else if (bean instanceof PhysicalComponent) {
            this.writePhysicalComponent(writer, (PhysicalComponent)bean);
        }
    }

    public TemporalFrame readTemporalFrame(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "TemporalFrame");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTemporalFrameType(reader);
    }

    public void writeTemporalFrame(XMLStreamWriter writer, TemporalFrame bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "TemporalFrame");
        this.writeNamespaces(writer);
        this.writeTemporalFrameType(writer, bean);
        writer.writeEndElement();
    }

    public SpatialFrame readSpatialFrame(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "SpatialFrame");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readSpatialFrameType(reader);
    }

    public void writeSpatialFrame(XMLStreamWriter writer, SpatialFrame bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "SpatialFrame");
        this.writeNamespaces(writer);
        this.writeSpatialFrameType(writer, bean);
        writer.writeEndElement();
    }

    public AggregateProcess readAggregateProcess(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "AggregateProcess");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readAggregateProcessType(reader);
    }

    public void writeAggregateProcess(XMLStreamWriter writer, AggregateProcess bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "AggregateProcess");
        this.writeNamespaces(writer);
        this.writeAggregateProcessType(writer, bean);
        writer.writeEndElement();
    }

    public Link readLink(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Link");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readLinkType(reader);
    }

    public void writeLink(XMLStreamWriter writer, Link bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Link");
        this.writeNamespaces(writer);
        this.writeLinkType(writer, bean);
        writer.writeEndElement();
    }

    public DescribedObject readDescribedObject(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("SimpleProcess")) {
            return this.readSimpleProcess(reader);
        }
        if (localName.equals("Mode")) {
            return this.readMode(reader);
        }
        if (localName.equals("PhysicalSystem")) {
            return this.readPhysicalSystem(reader);
        }
        if (localName.equals("PhysicalComponent")) {
            return this.readPhysicalComponent(reader);
        }
        if (localName.equals("AggregateProcess")) {
            return this.readAggregateProcess(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeDescribedObject(XMLStreamWriter writer, DescribedObject bean) throws XMLStreamException {
        if (bean instanceof SimpleProcess) {
            this.writeSimpleProcess(writer, (SimpleProcess)bean);
        } else if (bean instanceof Mode) {
            this.writeMode(writer, (Mode)bean);
        } else if (bean instanceof PhysicalSystem) {
            this.writePhysicalSystem(writer, (PhysicalSystem)bean);
        } else if (bean instanceof PhysicalComponent) {
            this.writePhysicalComponent(writer, (PhysicalComponent)bean);
        } else if (bean instanceof AggregateProcess) {
            this.writeAggregateProcess(writer, (AggregateProcess)bean);
        }
    }

    public AbstractProcess readAbstractProcess(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("SimpleProcess")) {
            return this.readSimpleProcess(reader);
        }
        if (localName.equals("PhysicalSystem")) {
            return this.readPhysicalSystem(reader);
        }
        if (localName.equals("PhysicalComponent")) {
            return this.readPhysicalComponent(reader);
        }
        if (localName.equals("AggregateProcess")) {
            return this.readAggregateProcess(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractProcess(XMLStreamWriter writer, AbstractProcess bean) throws XMLStreamException {
        if (bean instanceof PhysicalComponent) {
            this.writePhysicalComponent(writer, (PhysicalComponent)bean);
        } else if (bean instanceof PhysicalSystem) {
            this.writePhysicalSystem(writer, (PhysicalSystem)bean);
        } else if (bean instanceof SimpleProcess) {
            this.writeSimpleProcess(writer, (SimpleProcess)bean);
        } else if (bean instanceof AggregateProcess) {
            this.writeAggregateProcess(writer, (AggregateProcess)bean);
        }
    }

    public AbstractSettings readAbstractSettings(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("Settings")) {
            return this.readSettings(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractSettings(XMLStreamWriter writer, AbstractSettings bean) throws XMLStreamException {
        if (bean instanceof Settings) {
            this.writeSettings(writer, (Settings)bean);
        }
    }

    public IdentifierList readIdentifierList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "IdentifierList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readIdentifierListType(reader);
    }

    public void writeIdentifierList(XMLStreamWriter writer, IdentifierList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "IdentifierList");
        this.writeNamespaces(writer);
        this.writeIdentifierListType(writer, bean);
        writer.writeEndElement();
    }

    public DocumentList readDocumentList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "DocumentList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readDocumentListType(reader);
    }

    public void writeDocumentList(XMLStreamWriter writer, DocumentList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "DocumentList");
        this.writeNamespaces(writer);
        this.writeDocumentListType(writer, bean);
        writer.writeEndElement();
    }

    public CharacteristicList readCharacteristicList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "CharacteristicList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readCharacteristicListType(reader);
    }

    public void writeCharacteristicList(XMLStreamWriter writer, CharacteristicList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "CharacteristicList");
        this.writeNamespaces(writer);
        this.writeCharacteristicListType(writer, bean);
        writer.writeEndElement();
    }

    public FeatureList readFeatureList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "FeatureList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readFeatureListType(reader);
    }

    public void writeFeatureList(XMLStreamWriter writer, FeatureList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "FeatureList");
        this.writeNamespaces(writer);
        this.writeFeatureListType(writer, bean);
        writer.writeEndElement();
    }

    public Event readEvent(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Event");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readEventType(reader);
    }

    public void writeEvent(XMLStreamWriter writer, Event bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Event");
        this.writeNamespaces(writer);
        this.writeEventType(writer, bean);
        writer.writeEndElement();
    }

    public CapabilityList readCapabilityList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "CapabilityList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readCapabilityListType(reader);
    }

    public void writeCapabilityList(XMLStreamWriter writer, CapabilityList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "CapabilityList");
        this.writeNamespaces(writer);
        this.writeCapabilityListType(writer, bean);
        writer.writeEndElement();
    }

    public EventList readEventList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "EventList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readEventListType(reader);
    }

    public void writeEventList(XMLStreamWriter writer, EventList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "EventList");
        this.writeNamespaces(writer);
        this.writeEventListType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractMetadataList readAbstractMetadataList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "AbstractMetadataList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readAbstractMetadataListType(reader);
    }

    public void writeAbstractMetadataList(XMLStreamWriter writer, AbstractMetadataList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "AbstractMetadataList");
        this.writeNamespaces(writer);
        this.writeAbstractMetadataListType(writer, bean);
        writer.writeEndElement();
    }

    public ContactList readContactList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "ContactList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readContactListType(reader);
    }

    public void writeContactList(XMLStreamWriter writer, ContactList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "ContactList");
        this.writeNamespaces(writer);
        this.writeContactListType(writer, bean);
        writer.writeEndElement();
    }

    public KeywordList readKeywordList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "KeywordList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readKeywordListType(reader);
    }

    public void writeKeywordList(XMLStreamWriter writer, KeywordList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "KeywordList");
        this.writeNamespaces(writer);
        this.writeKeywordListType(writer, bean);
        writer.writeEndElement();
    }

    public Term readTerm(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Term");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTermType(reader);
    }

    public void writeTerm(XMLStreamWriter writer, Term bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Term");
        this.writeNamespaces(writer);
        this.writeTermType(writer, bean);
        writer.writeEndElement();
    }

    public ClassifierList readClassifierList(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "ClassifierList");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readClassifierListType(reader);
    }

    public void writeClassifierList(XMLStreamWriter writer, ClassifierList bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "ClassifierList");
        this.writeNamespaces(writer);
        this.writeClassifierListType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractModes readAbstractModes(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("ModeChoice")) {
            return this.readModeChoice(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractModes(XMLStreamWriter writer, AbstractModes bean) throws XMLStreamException {
        if (bean instanceof ModeChoice) {
            this.writeModeChoice(writer, (ModeChoice)bean);
        }
    }

    public DataInterface readDataInterface(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "DataInterface");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readDataInterfaceType(reader);
    }

    public void writeDataInterface(XMLStreamWriter writer, DataInterface bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "DataInterface");
        this.writeNamespaces(writer);
        this.writeDataInterfaceType(writer, bean);
        writer.writeEndElement();
    }

    public ObservableProperty readObservableProperty(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "ObservableProperty");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readObservablePropertyType(reader);
    }

    public void writeObservableProperty(XMLStreamWriter writer, ObservableProperty bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "ObservableProperty");
        this.writeNamespaces(writer);
        this.writeObservablePropertyType(writer, bean);
        writer.writeEndElement();
    }

    public String readAxis(XMLStreamReader reader) throws XMLStreamException {
        return reader.getElementText().trim();
    }

    public void writeAxis(XMLStreamWriter writer, String value) throws XMLStreamException {
        writer.writeCharacters(value);
    }

    public String readDataComponentRefPropertyType(XMLStreamReader reader) throws XMLStreamException {
        return reader.getAttributeValue(null, "ref");
    }

    public void writeDataComponentRefPropertyType(XMLStreamWriter writer, String ref) throws XMLStreamException {
        writer.writeAttribute("ref", ref);
    }

    public StatusSetting readStatusSettingPropertyType(XMLStreamReader reader) throws XMLStreamException {
        StatusSetting bean = this.factory.newStatusSetting();
        Map attrMap = this.collectAttributes(reader);
        String val = (String)attrMap.get("ref");
        if (val != null) {
            bean.setRef(val);
        }
        if ((val = reader.getElementText()) != null) {
            bean.setValue(Status.fromString(val));
        }
        return bean;
    }

    public void writeStatusSettingPropertyType(XMLStreamWriter writer, StatusSetting bean) throws XMLStreamException {
        writer.writeAttribute("ref", this.getStringValue(bean.getRef()));
        writer.writeCharacters(this.getStringValue((Object)bean.getValue()));
    }

    public Object readSecurityConstraints(XMLStreamReader reader) throws XMLStreamException {
        return this.readExtension(reader);
    }

    public void writeSecurityConstraints(XMLStreamWriter writer, Object item) throws XMLStreamException {
        this.writeExtension(writer, item);
    }
}

