/*
 * Decompiled with CFR 0.152.
 */
package org.vast.process;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.HasUom;
import org.vast.data.DataIterator;
import org.vast.data.DataValue;
import org.vast.data.ScalarIterator;
import org.vast.process.IProcessExec;
import org.vast.process.SMLException;
import org.vast.unit.Unit;
import org.vast.unit.UnitConversion;
import org.vast.unit.UnitConverter;

public class DataConnection {
    private static final Logger LOGGER = Logger.getLogger(DataConnection.class.getName());
    protected IProcessExec sourceProcess;
    protected IProcessExec destinationProcess;
    protected DataComponent sourceComponent;
    protected DataComponent destinationComponent;
    protected transient boolean dataAvailable;
    protected transient boolean needsUnitConversion;
    protected transient List<ComponentConverter> componentConverters = new ArrayList<ComponentConverter>();
    protected Hashtable<String, Object> properties = null;

    protected void setupUnitConverters() throws SMLException {
        if (this.sourceComponent == null || this.destinationComponent == null) {
            return;
        }
        this.componentConverters.clear();
        ScalarIterator itSrc = new ScalarIterator(this.sourceComponent);
        ScalarIterator itDest = new ScalarIterator(this.destinationComponent);
        while (itSrc.hasNext()) {
            DataValue dest;
            DataValue src = itSrc.next();
            UnitConverter conv = this.getUnitConverter((DataComponent)src, (DataComponent)(dest = itDest.next()));
            if (conv == null) continue;
            this.componentConverters.add(new ComponentConverter((DataComponent)src, (DataComponent)dest, conv));
            LOGGER.finer("Unit conversion setup from " + src.getName() + " to " + dest.getName());
        }
    }

    protected UnitConverter getUnitConverter(DataComponent src, DataComponent dest) throws SMLException {
        if (src instanceof HasUom && dest instanceof HasUom) {
            Unit srcUom = (Unit)((HasUom)src).getUom().getValue();
            Unit destUom = (Unit)((HasUom)dest).getUom().getValue();
            if (srcUom == null || destUom == null || srcUom.isEquivalent(destUom)) {
                return null;
            }
            return UnitConversion.getConverter((Unit)srcUom, (Unit)destUom);
        }
        return null;
    }

    public void transferDataBlocks() {
        DataBlock srcBlock = this.sourceComponent.getData();
        DataBlock destBlock = this.destinationComponent.getData();
        if (!this.componentConverters.isEmpty()) {
            if (destBlock == null) {
                this.destinationComponent.assignNewDataBlock();
            }
            Iterator<ComponentConverter> it = this.componentConverters.iterator();
            while (it.hasNext()) {
                it.next().convert();
            }
        } else if (destBlock != srcBlock) {
            this.destinationComponent.setData(srcBlock);
        }
    }

    public static String check(DataComponent src, DataComponent dest) throws SMLException {
        if (src == null || dest == null) {
            return null;
        }
        DataIterator it1 = new DataIterator(src);
        DataIterator it2 = new DataIterator(dest);
        StringBuffer msg = new StringBuffer();
        while (it1.hasNext()) {
            if (!it2.hasNext()) {
                throw new SMLException("Structures of source and destination are not compatible");
            }
            DataComponent c1 = it1.next();
            DataComponent c2 = it2.next();
            if (!c1.getClass().isInstance(c2) || c1.getComponentCount() != c2.getComponentCount()) {
                throw new SMLException("Components '" + c1.getName() + "' and '" + c2.getName() + "' are not compatible");
            }
            if (!(c1 instanceof HasUom) || !(c2 instanceof HasUom)) continue;
            Unit uom1 = (Unit)((HasUom)c1).getUom().getValue();
            Unit uom2 = (Unit)((HasUom)c2).getUom().getValue();
            if (uom1 != null && uom2 != null && !uom1.isCompatible(uom2)) {
                throw new SMLException("Unit of component '" + c1.getName() + "' is not compatible with unit of '" + c2.getName() + "'");
            }
            if (((DataValue)c1).getDataType() == ((DataValue)c2).getDataType()) continue;
            msg.append("Data types of source and destination component are different. Conversion may lead to loss of precision");
        }
        if (msg.length() == 0) {
            return null;
        }
        return msg.toString();
    }

    public String check() throws SMLException {
        return DataConnection.check(this.sourceComponent, this.destinationComponent);
    }

    public DataComponent getDestinationComponent() {
        return this.destinationComponent;
    }

    public void setDestinationComponent(DataComponent destinationComponent) throws SMLException {
        this.destinationComponent = destinationComponent;
        this.setupUnitConverters();
    }

    public IProcessExec getDestinationProcess() {
        return this.destinationProcess;
    }

    public void setDestinationProcess(IProcessExec destinationProcess) {
        this.destinationProcess = destinationProcess;
    }

    public DataComponent getSourceComponent() {
        return this.sourceComponent;
    }

    public void setSourceComponent(DataComponent sourceComponent) throws SMLException {
        this.sourceComponent = sourceComponent;
        this.setupUnitConverters();
    }

    public IProcessExec getSourceProcess() {
        return this.sourceProcess;
    }

    public void setSourceProcess(IProcessExec sourceProcess) {
        this.sourceProcess = sourceProcess;
    }

    public boolean isDataAvailable() {
        return this.dataAvailable;
    }

    public void setDataAvailable(boolean dataAvailable) {
        this.dataAvailable = dataAvailable;
    }

    public Object getProperty(String propName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propName);
    }

    public void setProperty(String propName, Object propValue) {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        this.properties.put(propName, propValue);
    }

    protected class ComponentConverter {
        protected DataComponent src;
        protected DataComponent dest;
        protected UnitConverter converter;

        public ComponentConverter(DataComponent src, DataComponent dest, UnitConverter converter) {
            this.src = src;
            this.dest = dest;
            this.converter = converter;
        }

        public void convert() {
            double srcVal = this.src.getData().getDoubleValue();
            double newVal = this.converter.convert(srcVal);
            this.dest.getData().setDoubleValue(newVal);
        }
    }
}

