/*
 * Decompiled with CFR 0.152.
 */
package org.vast.process;

import java.util.LinkedList;
import java.util.ListIterator;
import net.opengis.swe.v20.DataBlock;
import org.vast.process.DataConnection;

public class DataQueue
extends DataConnection {
    public int waitCount = 0;
    public boolean repeat = false;
    protected LinkedList<DataBlock> queue = new LinkedList();
    protected int counter = 0;

    public synchronized void add(DataBlock data) {
        this.queue.addLast(data);
        this.notifyAll();
    }

    public synchronized DataBlock get(long timeout) throws InterruptedException {
        DataBlock dataBlock;
        if (this.counter == 0 && !this.repeat) {
            while (this.queue.size() == 0) {
                this.wait(timeout);
            }
            if (this.queue.size() == 0) {
                return null;
            }
            dataBlock = this.queue.getFirst();
            this.queue.removeFirst();
        } else {
            dataBlock = this.destinationComponent.getData();
        }
        ++this.counter;
        if (this.counter > this.waitCount) {
            this.counter = 0;
        }
        return dataBlock;
    }

    public DataBlock get() throws InterruptedException {
        return this.get(0L);
    }

    @Override
    public boolean isDataAvailable() {
        return !this.queue.isEmpty();
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public String toString() {
        ListIterator it = this.queue.listIterator();
        StringBuffer text = new StringBuffer("Queue size: " + this.queue.size() + "\n");
        while (it.hasNext()) {
            DataBlock block = (DataBlock)it.next();
            text.append("Block: ");
            text.append(block.toString());
            text.append("\n");
        }
        return text.toString();
    }
}

