/*
 * Decompiled with CFR 0.152.
 */
package org.vast.process;

import java.util.List;
import net.opengis.sensorml.v20.IOPropertyList;
import org.vast.process.DataConnection;
import org.vast.process.DataConnectionList;
import org.vast.process.SMLException;

public interface IProcessExec {
    public String getName();

    public void init() throws SMLException;

    public void execute() throws SMLException;

    public void reset() throws SMLException;

    public void dispose();

    public boolean canRun();

    public void createNewOutputBlocks();

    public void createNewInputBlocks();

    public void run();

    public void start() throws SMLException;

    public void stop();

    public IOPropertyList getInputList();

    public IOPropertyList getOutputList();

    public IOPropertyList getParameterList();

    public List<DataConnectionList> getInputConnections();

    public List<DataConnectionList> getParamConnections();

    public List<DataConnectionList> getOutputConnections();

    public void connectInput(String var1, String var2, DataConnection var3) throws SMLException;

    public void connectOutput(String var1, String var2, DataConnection var3) throws SMLException;

    public void connectParameter(String var1, String var2, DataConnection var3) throws SMLException;

    public boolean isInputConnected(String var1);

    public boolean isOutputConnected(String var1);

    public boolean isParamConnected(String var1);

    public boolean isUsingQueueBuffers();

    public void setUsingQueueBuffers(boolean var1);

    public boolean needSync();

    public void setAvailability(List<DataConnectionList> var1, boolean var2);

    public void transferData(List<DataConnectionList> var1);
}

