/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.util.ArrayList;
import java.util.List;
import net.opengis.OgcPropertyList;
import net.opengis.gml.v32.Reference;
import net.opengis.sensorml.v20.AbstractModes;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.AbstractSettings;
import net.opengis.sensorml.v20.DataInterface;
import net.opengis.sensorml.v20.FeatureList;
import net.opengis.sensorml.v20.IOPropertyList;
import net.opengis.sensorml.v20.ObservableProperty;
import net.opengis.sensorml.v20.impl.DescribedObjectImpl;
import net.opengis.sensorml.v20.impl.FeatureListImpl;
import net.opengis.swe.v20.AbstractSWEIdentifiable;
import net.opengis.swe.v20.DataComponent;
import org.vast.data.AbstractDataComponentImpl;
import org.vast.process.DataConnection;
import org.vast.process.DataConnectionList;
import org.vast.process.IProcessExec;
import org.vast.process.SMLException;
import org.vast.sensorML.ExecutableProcessImpl;
import org.vast.sensorML.SMLHelper;

public abstract class AbstractProcessImpl
extends DescribedObjectImpl
implements AbstractProcess,
IProcessExec,
Runnable {
    protected Reference typeOf;
    protected AbstractSettings configuration;
    protected FeatureList featuresOfInterest;
    protected IOPropertyList inputData = new IOPropertyList();
    protected IOPropertyList outputData = new IOPropertyList();
    protected IOPropertyList paramData = new IOPropertyList();
    protected List<AbstractModes> modesList = new ArrayList<AbstractModes>();
    protected String definition;
    protected transient IProcessExec executableProcess;

    public void setExecutableImpl(ExecutableProcessImpl processExec) throws SMLException {
        this.executableProcess = processExec;
        processExec.assignWrapperProcess(this);
    }

    @Override
    public boolean isExecutable() {
        return this.executableProcess != null;
    }

    protected final void checkExecutable() throws SMLException {
        if (this.executableProcess == null) {
            throw new SMLException("This process is not executable");
        }
    }

    @Override
    public void init() throws SMLException {
        this.checkExecutable();
        this.executableProcess.init();
    }

    @Override
    public void reset() throws SMLException {
        this.checkExecutable();
        this.executableProcess.reset();
    }

    @Override
    public void execute() throws SMLException {
        this.checkExecutable();
        this.executableProcess.execute();
    }

    @Override
    public void dispose() {
        if (this.executableProcess != null) {
            this.executableProcess.dispose();
        }
    }

    @Override
    public boolean canRun() {
        if (this.executableProcess != null) {
            return this.executableProcess.canRun();
        }
        return false;
    }

    @Override
    public void createNewOutputBlocks() {
        if (this.executableProcess != null) {
            this.executableProcess.createNewOutputBlocks();
        }
    }

    @Override
    public void createNewInputBlocks() {
        if (this.executableProcess != null) {
            this.executableProcess.createNewInputBlocks();
        }
    }

    @Override
    public void run() {
        if (this.executableProcess != null) {
            this.executableProcess.run();
        }
    }

    @Override
    public synchronized void start() throws SMLException {
        this.checkExecutable();
        this.executableProcess.start();
    }

    @Override
    public synchronized void stop() {
        if (this.executableProcess != null) {
            this.executableProcess.stop();
        }
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        String indent = "    ";
        text.append("Process: ");
        text.append(this.id);
        text.append(" (" + this.getClass().getName() + ")\n");
        text.append("\n  Inputs:\n");
        for (i = 0; i < this.getNumInputs(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.inputData.getComponent(i)).toString(indent));
        }
        text.append("\n  Outputs:\n");
        for (i = 0; i < this.getNumOutputs(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.outputData.getComponent(i)).toString(indent));
        }
        text.append("\n  Parameters:\n");
        for (i = 0; i < this.getNumParameters(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.paramData.getComponent(i)).toString(indent));
        }
        return text.toString();
    }

    @Override
    public void connectInput(String inputName, String dataPath, DataConnection connection) throws SMLException {
        this.checkExecutable();
        this.executableProcess.connectInput(inputName, dataPath, connection);
    }

    @Override
    public void connectOutput(String outputName, String dataPath, DataConnection connection) throws SMLException {
        this.checkExecutable();
        this.executableProcess.connectOutput(outputName, dataPath, connection);
    }

    @Override
    public void connectParameter(String paramName, String dataPath, DataConnection connection) throws SMLException {
        this.checkExecutable();
        this.executableProcess.connectParameter(paramName, dataPath, connection);
    }

    @Override
    public boolean isInputConnected(String inputName) {
        if (this.executableProcess != null) {
            return this.executableProcess.isInputConnected(inputName);
        }
        return false;
    }

    @Override
    public boolean isOutputConnected(String outputName) {
        if (this.executableProcess != null) {
            return this.executableProcess.isOutputConnected(outputName);
        }
        return false;
    }

    @Override
    public boolean isParamConnected(String paramName) {
        if (this.executableProcess != null) {
            return this.executableProcess.isParamConnected(paramName);
        }
        return false;
    }

    @Override
    public List<DataConnectionList> getInputConnections() {
        if (this.executableProcess != null) {
            return this.executableProcess.getInputConnections();
        }
        return null;
    }

    @Override
    public List<DataConnectionList> getParamConnections() {
        if (this.executableProcess != null) {
            return this.executableProcess.getParamConnections();
        }
        return null;
    }

    @Override
    public List<DataConnectionList> getOutputConnections() {
        if (this.executableProcess != null) {
            return this.executableProcess.getOutputConnections();
        }
        return null;
    }

    @Override
    public boolean isUsingQueueBuffers() {
        if (this.executableProcess != null) {
            return this.executableProcess.isUsingQueueBuffers();
        }
        return false;
    }

    @Override
    public void setUsingQueueBuffers(boolean usingQueueBuffers) {
        if (this.executableProcess != null) {
            this.executableProcess.setUsingQueueBuffers(usingQueueBuffers);
        }
    }

    @Override
    public boolean needSync() {
        if (this.executableProcess != null) {
            return this.executableProcess.needSync();
        }
        return false;
    }

    @Override
    public void setAvailability(List<DataConnectionList> allConnections, boolean availability) {
        if (this.executableProcess != null) {
            this.executableProcess.setAvailability(allConnections, availability);
        }
    }

    @Override
    public void transferData(List<DataConnectionList> allConnections) {
        if (this.executableProcess != null) {
            this.executableProcess.transferData(allConnections);
        }
    }

    protected int getSignalIndex(OgcPropertyList<?> ioList, String signalName) {
        for (int i = 0; i < ioList.size(); ++i) {
            if (!signalName.equals(ioList.getProperty(i).getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Reference getTypeOf() {
        return this.typeOf;
    }

    @Override
    public boolean isSetTypeOf() {
        return this.typeOf != null;
    }

    @Override
    public void setTypeOf(Reference typeOf) {
        this.typeOf = typeOf;
    }

    @Override
    public AbstractSettings getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isSetConfiguration() {
        return this.configuration != null;
    }

    @Override
    public void setConfiguration(AbstractSettings configuration) {
        this.configuration = configuration;
    }

    @Override
    public FeatureList getFeaturesOfInterest() {
        if (this.featuresOfInterest == null) {
            this.featuresOfInterest = new FeatureListImpl();
        }
        return this.featuresOfInterest;
    }

    @Override
    public boolean isSetFeaturesOfInterest() {
        return this.featuresOfInterest != null;
    }

    @Override
    public void setFeaturesOfInterest(FeatureList featuresOfInterest) {
        this.featuresOfInterest = featuresOfInterest;
    }

    @Override
    public IOPropertyList getInputList() {
        return this.inputData;
    }

    @Override
    public int getNumInputs() {
        return this.inputData.size();
    }

    @Override
    public AbstractSWEIdentifiable getInput(String name) {
        return (AbstractSWEIdentifiable)this.inputData.get(name);
    }

    @Override
    public DataComponent getInputComponent(String name) {
        return SMLHelper.getIOComponent(this.getInput(name));
    }

    @Override
    public void addInput(String name, DataComponent input) {
        this.inputData.add(name, input);
    }

    @Override
    public void addInput(String name, ObservableProperty input) {
        this.inputData.add(name, input);
    }

    @Override
    public void addInput(String name, DataInterface input) {
        this.inputData.add(name, input);
    }

    @Override
    public IOPropertyList getOutputList() {
        return this.outputData;
    }

    @Override
    public int getNumOutputs() {
        return this.outputData.size();
    }

    @Override
    public AbstractSWEIdentifiable getOutput(String name) {
        return (AbstractSWEIdentifiable)this.outputData.get(name);
    }

    @Override
    public DataComponent getOutputComponent(String name) {
        return SMLHelper.getIOComponent(this.getOutput(name));
    }

    @Override
    public void addOutput(String name, DataComponent output) {
        this.outputData.add(name, output);
    }

    @Override
    public void addOutput(String name, ObservableProperty output) {
        this.outputData.add(name, output);
    }

    @Override
    public void addOutput(String name, DataInterface output) {
        this.outputData.add(name, output);
    }

    @Override
    public int getNumParameters() {
        return this.paramData.size();
    }

    @Override
    public AbstractSWEIdentifiable getParameter(String name) {
        return (AbstractSWEIdentifiable)this.paramData.get(name);
    }

    @Override
    public DataComponent getParameterComponent(String name) {
        return SMLHelper.getIOComponent(this.getParameter(name));
    }

    @Override
    public void addParameter(String name, DataComponent parameter) {
        this.paramData.add(name, parameter);
    }

    @Override
    public void addParameter(String name, ObservableProperty parameter) {
        this.paramData.add(name, parameter);
    }

    @Override
    public void addParameter(String name, DataInterface parameter) {
        this.paramData.add(name, parameter);
    }

    @Override
    public IOPropertyList getParameterList() {
        return this.paramData;
    }

    @Override
    public List<AbstractModes> getModesList() {
        return this.modesList;
    }

    @Override
    public int getNumModes() {
        if (this.modesList == null) {
            return 0;
        }
        return this.modesList.size();
    }

    @Override
    public void addModes(AbstractModes modes) {
        this.modesList.add(modes);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public boolean isSetDefinition() {
        return this.definition != null;
    }

    @Override
    public void setDefinition(String definition) {
        this.definition = definition;
    }
}

