/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opengis.OgcPropertyList;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.AggregateProcess;
import net.opengis.sensorml.v20.Link;
import net.opengis.swe.v20.DataComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.cdm.common.CDMException;
import org.vast.data.DataRecordImpl;
import org.vast.process.DataConnection;
import org.vast.process.DataConnectionList;
import org.vast.process.DataQueue;
import org.vast.process.IProcessChainExec;
import org.vast.process.IProcessExec;
import org.vast.process.SMLException;
import org.vast.sensorML.AbstractProcessImpl;
import org.vast.sensorML.ExecutableProcessImpl;
import org.vast.swe.SWEHelper;

public class ExecutableChainImpl
extends ExecutableProcessImpl
implements IProcessChainExec {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExecutableChainImpl.class.getName());
    protected transient Map<String, IProcessExec> processTable;
    protected transient List<IProcessExec> processExecList;
    protected transient boolean childrenThreadsOn = false;
    protected transient List<DataConnectionList> internalInputConnections = null;
    protected transient List<DataConnectionList> internalOutputConnections = null;
    protected transient List<DataConnectionList> internalParamConnections = null;
    protected transient List<DataConnection> internalConnections = null;

    @Override
    protected void assignWrapperProcess(AbstractProcess wrapperProcess) throws SMLException {
        super.assignWrapperProcess(wrapperProcess);
        OgcPropertyList<AbstractProcess> componentList = ((AggregateProcess)wrapperProcess).getComponentList();
        int numComponents = componentList.size();
        this.processTable = new LinkedHashMap<String, IProcessExec>(numComponents);
        this.processExecList = new ArrayList<IProcessExec>(numComponents);
        for (int i = 0; i < numComponents; ++i) {
            AbstractProcess process = (AbstractProcess)componentList.get(i);
            String processName = componentList.getProperty(i).getName();
            if (!process.isExecutable()) {
                throw new SMLException("Child process " + processName + " is not executable");
            }
            this.processTable.put(processName, ((AbstractProcessImpl)process).executableProcess);
        }
        int numInputs = wrapperProcess.getNumInputs();
        this.internalInputConnections = new ArrayList<DataConnectionList>(numInputs);
        for (int i = 0; i < numInputs; ++i) {
            this.internalInputConnections.add(new DataConnectionList());
        }
        int numOutputs = wrapperProcess.getNumOutputs();
        this.internalOutputConnections = new ArrayList<DataConnectionList>(numOutputs);
        for (int i = 0; i < numOutputs; ++i) {
            this.internalOutputConnections.add(new DataConnectionList());
        }
        int numParams = wrapperProcess.getNumParameters();
        this.internalParamConnections = new ArrayList<DataConnectionList>(numParams);
        for (int i = 0; i < numParams; ++i) {
            this.internalParamConnections.add(new DataConnectionList());
        }
        int numConnections = ((AggregateProcess)wrapperProcess).getNumConnections();
        this.internalConnections = new ArrayList<DataConnection>(numConnections);
        for (Link link : ((AggregateProcess)wrapperProcess).getConnectionList()) {
            DataQueue dataQueue = new DataQueue();
            this.connectSignal(dataQueue, link.getSource());
            this.connectSignal(dataQueue, link.getDestination());
            this.internalConnections.add(dataQueue);
        }
    }

    @Override
    public void init() throws SMLException {
        IProcessExec currentProcess = null;
        try {
            if (!this.childrenThreadsOn) {
                this.processExecList.clear();
                this.addUpstreamProcesses(this, this.internalOutputConnections);
                Iterator<IProcessExec> i$ = this.processExecList.iterator();
                while (i$.hasNext()) {
                    IProcessExec childProcess;
                    currentProcess = childProcess = i$.next();
                    childProcess.init();
                    childProcess.createNewOutputBlocks();
                    if (!childProcess.needSync()) continue;
                    this.needSync = true;
                }
                this.reset();
            } else {
                Iterator<IProcessExec> i$ = this.processTable.values().iterator();
                while (i$.hasNext()) {
                    IProcessExec childProcess;
                    currentProcess = childProcess = i$.next();
                    childProcess.init();
                    childProcess.reset();
                    childProcess.createNewOutputBlocks();
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Error while initializing process " + currentProcess.getName() + " (" + currentProcess.getClass().getCanonicalName() + ")";
            LOG.debug(errMsg, (Throwable)e);
            throw new SMLException(errMsg, e);
        }
    }

    protected void connectSignal(DataQueue dataQueue, String linkString) throws SMLException {
        int sep3;
        boolean internalConnection = false;
        IProcessExec selectedProcess = null;
        String processName = null;
        String portType = null;
        String portName = null;
        String dataPath = "";
        int sep1 = linkString.indexOf("/", 1);
        String part1 = linkString.substring(0, sep1++);
        int sep2 = linkString.indexOf("/", sep1);
        if (sep2 < 0) {
            sep2 = linkString.length();
        }
        String part2 = linkString.substring(sep1, sep2++);
        if (part1.equals("components")) {
            processName = part2;
            selectedProcess = this.processTable.get(processName);
            if (selectedProcess == null) {
                throw new SMLException("Child process " + processName + " does't exist in aggregate process " + this.getName());
            }
            sep3 = linkString.indexOf("/", sep2);
            portType = linkString.substring(sep2, sep3++);
            int sep4 = linkString.indexOf("/", sep3);
            if (sep4 < 0) {
                sep4 = linkString.length();
            }
            portName = linkString.substring(sep3, sep4++);
            if (sep4 < linkString.length()) {
                dataPath = linkString.substring(sep4);
            }
        } else {
            internalConnection = true;
            selectedProcess = this;
            portType = part1;
            portName = part2;
            sep3 = linkString.indexOf("/", sep2);
            if (sep3 > 0) {
                dataPath = linkString.substring(sep3);
            }
        }
        if (portType.equals("inputs")) {
            try {
                if (internalConnection) {
                    this.connectInternalInput(portName, dataPath, dataQueue);
                }
                selectedProcess.connectInput(portName, dataPath, dataQueue);
            }
            catch (SMLException e) {
                throw new SMLException("No input named " + portName + " in process " + processName);
            }
        } else if (portType.equals("outputs")) {
            try {
                if (internalConnection) {
                    this.connectInternalOutput(portName, dataPath, dataQueue);
                }
                selectedProcess.connectOutput(portName, dataPath, dataQueue);
            }
            catch (SMLException e) {
                throw new SMLException("No output named " + portName + " in process " + processName);
            }
        } else if (portType.equals("parameters")) {
            try {
                if (internalConnection) {
                    this.connectInternalParam(portName, dataPath, dataQueue);
                } else {
                    selectedProcess.connectParameter(portName, dataPath, dataQueue);
                }
            }
            catch (SMLException e) {
                throw new SMLException("No parameter named " + portName + " in process " + processName);
            }
        }
        try {
            dataQueue.check();
        }
        catch (SMLException e) {
            String srcName = dataQueue.getSourceProcess().getName();
            String destName = dataQueue.getDestinationProcess().getName();
            throw new SMLException("Connection on " + linkString + " cannot be made between " + srcName + " and " + destName, e);
        }
    }

    @Override
    public void reset() throws SMLException {
        for (IProcessExec childProcess : this.processTable.values()) {
            childProcess.reset();
        }
        for (int i = 0; i < this.internalConnections.size(); ++i) {
            this.internalConnections.get(i).setDataAvailable(false);
        }
    }

    @Override
    public void dispose() {
        if (this.processTable != null) {
            for (IProcessExec childProcess : this.processTable.values()) {
                childProcess.dispose();
            }
        }
    }

    private void addUpstreamProcesses(IProcessExec process, List<DataConnectionList> connectionLists) {
        for (int i = 0; i < connectionLists.size(); ++i) {
            List connectionList = connectionLists.get(i);
            for (int j = 0; j < connectionList.size(); ++j) {
                IProcessExec upStreamProcess = ((DataConnection)connectionList.get(j)).getSourceProcess();
                if (upStreamProcess == this) continue;
                if (!this.processExecList.contains(upStreamProcess)) {
                    this.processExecList.add(upStreamProcess);
                    this.addUpstreamProcesses(upStreamProcess, upStreamProcess.getInputConnections());
                    this.addUpstreamProcesses(upStreamProcess, upStreamProcess.getParamConnections());
                }
                if (process == this) continue;
                this.ensureOrder(upStreamProcess, process);
            }
        }
    }

    private void ensureOrder(IProcessExec processBefore, IProcessExec processAfter) {
        int before = this.processExecList.indexOf(processBefore);
        int after = this.processExecList.indexOf(processAfter);
        if (after < before) {
            this.processExecList.remove(after);
            this.processExecList.add(before, processAfter);
        }
    }

    @Override
    public void execute() throws SMLException {
        IProcessExec currentProcess = null;
        try {
            if (!this.childrenThreadsOn && this.processExecList != null) {
                this.combineInputBlocks();
                if (this.needSync) {
                    int i;
                    boolean moreToRun;
                    int i2;
                    for (i2 = 0; i2 < this.inputConnections.size(); ++i2) {
                        if (!((DataConnectionList)this.inputConnections.get(i2)).isNeeded()) continue;
                        this.setAvailability(this.internalInputConnections.get(i2), true);
                    }
                    for (i2 = 0; i2 < this.paramConnections.size(); ++i2) {
                        if (!((DataConnectionList)this.paramConnections.get(i2)).isNeeded()) continue;
                        this.setAvailability(this.internalParamConnections.get(i2), true);
                    }
                    for (i2 = 0; i2 < this.outputConnections.size(); ++i2) {
                        if (!((DataConnectionList)this.outputConnections.get(i2)).isNeeded()) continue;
                        this.setAvailability(this.internalOutputConnections.get(i2), false);
                    }
                    do {
                        moreToRun = false;
                        Iterator<IProcessExec> i$ = this.processExecList.iterator();
                        while (i$.hasNext()) {
                            IProcessExec childProcess;
                            currentProcess = childProcess = i$.next();
                            if (!childProcess.canRun()) continue;
                            childProcess.transferData(childProcess.getInputConnections());
                            childProcess.transferData(childProcess.getParamConnections());
                            childProcess.execute();
                            childProcess.setAvailability(childProcess.getInputConnections(), false);
                            childProcess.setAvailability(childProcess.getParamConnections(), false);
                            childProcess.setAvailability(childProcess.getOutputConnections(), true);
                            moreToRun = true;
                        }
                    } while (moreToRun && !this.checkAvailability(this.internalOutputConnections, true));
                    this.transferData(this.internalOutputConnections);
                    this.combineOutputBlocks();
                    for (i = 0; i < this.inputConnections.size(); ++i) {
                        ((DataConnectionList)this.inputConnections.get(i)).setNeeded(this.checkAvailability(this.internalInputConnections.get(i), false));
                    }
                    for (i = 0; i < this.paramConnections.size(); ++i) {
                        ((DataConnectionList)this.paramConnections.get(i)).setNeeded(this.checkAvailability(this.internalParamConnections.get(i), false));
                    }
                    for (i = 0; i < this.outputConnections.size(); ++i) {
                        ((DataConnectionList)this.outputConnections.get(i)).setNeeded(this.checkAvailability(this.internalOutputConnections.get(i), true));
                    }
                } else {
                    Iterator<IProcessExec> i$ = this.processExecList.iterator();
                    while (i$.hasNext()) {
                        IProcessExec childProcess;
                        currentProcess = childProcess = i$.next();
                        childProcess.transferData(childProcess.getInputConnections());
                        childProcess.transferData(childProcess.getParamConnections());
                        childProcess.execute();
                    }
                    this.transferData(this.internalOutputConnections);
                }
            }
        }
        catch (SMLException e) {
            String errMsg = "Error while executing process " + currentProcess.getName() + " (" + currentProcess.getClass().getCanonicalName() + ")";
            LOG.debug(errMsg, (Throwable)e);
            throw new SMLException(errMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while executing process " + this.getName(), e);
        }
    }

    @Override
    public void createNewOutputBlocks() {
        for (int i = 0; i < this.internalOutputConnections.size(); ++i) {
            DataConnectionList connectionList = this.internalOutputConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            for (int j = 0; j < connectionList.size(); ++j) {
                DataConnection connection = (DataConnection)connectionList.get(j);
                if (connection.getSourceProcess() == this) continue;
                connection.getSourceProcess().createNewOutputBlocks();
            }
        }
    }

    public void combineInputBlocks() {
        for (int i = 0; i < this.inputData.size(); ++i) {
            DataComponent input = this.inputData.getComponent(i);
            if (!(input instanceof DataRecordImpl)) continue;
            ((DataRecordImpl)input).combineDataBlocks();
        }
    }

    public void combineOutputBlocks() {
        for (int i = 0; i < this.outputData.size(); ++i) {
            DataComponent output = this.outputData.getComponent(i);
            if (!(output instanceof DataRecordImpl)) continue;
            ((DataRecordImpl)output).combineDataBlocks();
        }
    }

    @Override
    public void connectInternalInput(String inputName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int inputIndex = this.getSignalIndex(this.inputData, inputName);
            DataComponent input = this.inputData.getComponent(inputIndex);
            DataComponent src = SWEHelper.findComponentByPath((DataComponent)input, (String)dataPath);
            connection.setSourceComponent(src);
            connection.setSourceProcess(this);
            this.internalInputConnections.get(inputIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect internal signal to input '" + inputName + "'", e);
        }
    }

    @Override
    public void connectInternalOutput(String outputName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int outputIndex = this.getSignalIndex(this.outputData, outputName);
            DataComponent output = this.outputData.getComponent(outputIndex);
            DataComponent dest = SWEHelper.findComponentByPath((DataComponent)output, (String)dataPath);
            connection.setDestinationComponent(dest);
            connection.setDestinationProcess(this);
            this.internalOutputConnections.get(outputIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect internal signal to output '" + outputName + "'", e);
        }
    }

    @Override
    public void connectInternalParam(String paramName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int paramIndex = this.getSignalIndex(this.paramData, paramName);
            DataComponent param = this.paramData.getComponent(paramIndex);
            DataComponent src = SWEHelper.findComponentByPath((DataComponent)param, (String)dataPath);
            connection.setSourceComponent(src);
            connection.setSourceProcess(this);
            this.internalParamConnections.get(paramIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect internal signal to parameter '" + paramName + "'", e);
        }
    }

    @Override
    public synchronized void start() throws SMLException {
        super.start();
        if (this.childrenThreadsOn) {
            for (IProcessExec childProcess : this.processTable.values()) {
                childProcess.start();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.childrenThreadsOn) {
            for (IProcessExec childProcess : this.processTable.values()) {
                childProcess.stop();
            }
        }
        super.stop();
    }

    @Override
    public boolean isChildrenThreadsOn() {
        return this.childrenThreadsOn;
    }

    @Override
    public void setChildrenThreadsOn(boolean childrenThreadsOn) {
        this.childrenThreadsOn = childrenThreadsOn;
    }

    @Override
    public List<DataConnection> getInternalConnections() {
        return this.internalConnections;
    }

    @Override
    public void setOutputNeeded(int outputIndex, boolean needed) {
        this.internalOutputConnections.get(outputIndex).setNeeded(needed);
    }
}

