/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.opengis.OgcPropertyList;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.IOPropertyList;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.cdm.common.CDMException;
import org.vast.data.AbstractDataComponentImpl;
import org.vast.process.DataConnection;
import org.vast.process.DataConnectionList;
import org.vast.process.DataQueue;
import org.vast.process.IProcessExec;
import org.vast.process.SMLException;
import org.vast.swe.SWEHelper;
import org.vast.util.ExceptionSystem;

public abstract class ExecutableProcessImpl
implements IProcessExec,
Runnable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExecutableProcessImpl.class.getName());
    protected static final String ioError = "Invalid I/O Structure";
    protected static final String initError = "Error while initializing process ";
    protected static final String execError = "Error while executing process ";
    protected AbstractProcess wrapperProcess;
    protected IOPropertyList inputData = new IOPropertyList();
    protected IOPropertyList outputData = new IOPropertyList();
    protected IOPropertyList paramData = new IOPropertyList();
    protected transient List<DataConnectionList> inputConnections = null;
    protected transient List<DataConnectionList> outputConnections = null;
    protected transient List<DataConnectionList> paramConnections = null;
    protected transient Thread processThread = null;
    protected transient boolean started = false;
    protected transient boolean usingQueueBuffers = false;
    protected transient boolean needSync = false;

    protected void assignWrapperProcess(AbstractProcess wrapperProcess) throws SMLException {
        this.wrapperProcess = wrapperProcess;
        IOPropertyList wrapperInputs = wrapperProcess.getInputList();
        if (this.inputData.size() != 0) {
            wrapperInputs.clear();
            wrapperInputs.addAll((Collection)((Object)this.inputData));
        }
        this.inputData = wrapperProcess.getInputList();
        int numInputs = wrapperProcess.getNumInputs();
        this.inputConnections = new ArrayList<DataConnectionList>(numInputs);
        for (int i = 0; i < numInputs; ++i) {
            this.inputConnections.add(new DataConnectionList());
        }
        IOPropertyList wrapperOutputs = wrapperProcess.getOutputList();
        if (this.outputData.size() != 0) {
            wrapperOutputs.clear();
            wrapperOutputs.addAll((Collection)((Object)this.outputData));
        }
        this.outputData = wrapperProcess.getOutputList();
        int numOutputs = wrapperProcess.getNumOutputs();
        this.outputConnections = new ArrayList<DataConnectionList>(numOutputs);
        for (int i = 0; i < numOutputs; ++i) {
            this.outputConnections.add(new DataConnectionList());
        }
        IOPropertyList wrapperParams = wrapperProcess.getParameterList();
        if (this.paramData.size() != 0) {
            wrapperParams.clear();
            wrapperParams.addAll((Collection)((Object)this.paramData));
        }
        this.paramData = wrapperProcess.getParameterList();
        int numParams = wrapperProcess.getNumParameters();
        this.paramConnections = new ArrayList<DataConnectionList>(numParams);
        for (int i = 0; i < numParams; ++i) {
            this.paramConnections.add(new DataConnectionList());
        }
    }

    @Override
    public abstract void init() throws SMLException;

    @Override
    public abstract void execute() throws SMLException;

    @Override
    public void dispose() {
    }

    @Override
    public void reset() throws SMLException {
    }

    @Override
    public String getName() {
        return this.wrapperProcess.getId();
    }

    @Override
    public boolean canRun() {
        if (!this.checkAvailability(this.inputConnections, true)) {
            return false;
        }
        if (!this.checkAvailability(this.paramConnections, true)) {
            return false;
        }
        return this.checkAvailability(this.outputConnections, false);
    }

    protected boolean checkAvailability(List<DataConnectionList> allConnections, boolean availability) {
        for (int i = 0; i < allConnections.size(); ++i) {
            DataConnectionList connectionList = allConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            for (int j = 0; j < connectionList.size(); ++j) {
                DataConnection connection = (DataConnection)connectionList.get(j);
                if (connection.isDataAvailable() == availability) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkAvailability(DataConnectionList connectionList, boolean availability) {
        for (int j = 0; j < connectionList.size(); ++j) {
            DataConnection connection = (DataConnection)connectionList.get(j);
            if (connection.isDataAvailable() == availability) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setAvailability(List<DataConnectionList> allConnections, boolean availability) {
        for (int i = 0; i < allConnections.size(); ++i) {
            DataConnectionList connectionList = allConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            this.setAvailability(connectionList, availability);
        }
    }

    protected void setAvailability(DataConnectionList connectionList, boolean availability) {
        for (int j = 0; j < connectionList.size(); ++j) {
            DataConnection connection = (DataConnection)connectionList.get(j);
            connection.setDataAvailable(availability);
        }
    }

    protected void fetchData(List<DataConnectionList> allConnections) throws InterruptedException {
        for (int i = 0; i < allConnections.size(); ++i) {
            DataConnectionList connectionList = allConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            for (int j = 0; j < connectionList.size(); ++j) {
                DataQueue dataQueue = (DataQueue)connectionList.get(j);
                DataComponent dataComponent = dataQueue.getDestinationComponent();
                DataBlock block = dataQueue.get();
                dataComponent.setData(block);
            }
        }
    }

    protected void writeData(List<DataConnectionList> allConnections) throws InterruptedException {
        for (int i = 0; i < allConnections.size(); ++i) {
            DataConnectionList connectionList = allConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            for (int j = 0; j < connectionList.size(); ++j) {
                DataQueue dataQueue = (DataQueue)connectionList.get(j);
                DataComponent dataComponent = dataQueue.getSourceComponent();
                DataBlock block = dataComponent.getData();
                dataQueue.add(block);
            }
            DataComponent comp = this.inputData.getComponent(i);
            comp.renewDataBlock();
        }
    }

    @Override
    public void transferData(List<DataConnectionList> allConnections) {
        for (int i = 0; i < allConnections.size(); ++i) {
            DataConnectionList connectionList = allConnections.get(i);
            if (!connectionList.isNeeded()) continue;
            for (int j = 0; j < connectionList.size(); ++j) {
                DataConnection connection = (DataConnection)connectionList.get(j);
                connection.transferDataBlocks();
            }
        }
    }

    @Override
    public void createNewOutputBlocks() {
        for (int i = 0; i < this.outputData.size(); ++i) {
            DataComponent comp = this.outputData.getComponent(i);
            comp.renewDataBlock();
        }
    }

    @Override
    public void createNewInputBlocks() {
        for (int i = 0; i < this.inputData.size(); ++i) {
            DataComponent comp = this.inputData.getComponent(i);
            comp.renewDataBlock();
        }
    }

    @Override
    public void run() {
        do {
            try {
                this.fetchData(this.inputConnections);
                this.fetchData(this.paramConnections);
                this.execute();
                this.writeData(this.outputConnections);
            }
            catch (SMLException e) {
                ExceptionSystem.display((Throwable)e);
            }
            catch (InterruptedException e) {
                this.started = false;
            }
        } while (this.started);
    }

    @Override
    public synchronized void start() throws SMLException {
        if (!this.started) {
            if (LOGGER.isDebugEnabled()) {
                String processClass = this.getClass().getName();
                processClass = processClass.substring(processClass.lastIndexOf(46) + 1);
                LOGGER.debug("Process " + this.getName() + " (" + processClass + ") Thread started");
            }
            this.init();
            this.started = true;
            this.usingQueueBuffers = true;
            this.processThread = new Thread(this);
            this.processThread.setName(this.getName());
            this.processThread.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            if (LOGGER.isDebugEnabled()) {
                String processClass = this.getClass().getName();
                processClass = processClass.substring(processClass.lastIndexOf(46) + 1);
                LOGGER.debug("Process " + this.getName() + " (" + processClass + ") Thread stopped");
            }
            this.started = false;
            if (this.processThread != null) {
                this.processThread.interrupt();
            }
            this.processThread = null;
        }
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        String indent = "    ";
        text.append("Process: ");
        text.append(this.getName());
        text.append(" (" + this.getClass().getName() + ")\n");
        text.append("\n  Inputs:\n");
        for (i = 0; i < this.inputData.size(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.inputData.getComponent(i)).toString(indent));
        }
        text.append("\n  Outputs:\n");
        for (i = 0; i < this.outputData.size(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.outputData.getComponent(i)).toString(indent));
        }
        text.append("\n  Parameters:\n");
        for (i = 0; i < this.paramData.size(); ++i) {
            text.append(indent);
            text.append(((AbstractDataComponentImpl)this.paramData.getComponent(i)).toString(indent));
        }
        return text.toString();
    }

    @Override
    public void connectInput(String inputName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int inputIndex = this.getSignalIndex(this.inputData, inputName);
            DataComponent input = this.inputData.getComponent(inputIndex);
            DataComponent dest = SWEHelper.findComponentByPath((DataComponent)input, (String)dataPath);
            connection.setDestinationComponent(dest);
            connection.setDestinationProcess(this);
            this.inputConnections.get(inputIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect signal to input '" + inputName + "'", e);
        }
    }

    @Override
    public void connectOutput(String outputName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int outputIndex = this.getSignalIndex(this.outputData, outputName);
            DataComponent output = this.outputData.getComponent(outputIndex);
            DataComponent src = SWEHelper.findComponentByPath((DataComponent)output, (String)dataPath);
            connection.setSourceComponent(src);
            connection.setSourceProcess(this);
            this.outputConnections.get(outputIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect signal to output '" + outputName + "'", e);
        }
    }

    @Override
    public void connectParameter(String paramName, String dataPath, DataConnection connection) throws SMLException {
        try {
            int paramIndex = this.getSignalIndex(this.paramData, paramName);
            DataComponent param = this.paramData.getComponent(paramIndex);
            DataComponent dest = SWEHelper.findComponentByPath((DataComponent)param, (String)dataPath);
            connection.setDestinationComponent(dest);
            connection.setDestinationProcess(this);
            this.paramConnections.get(paramIndex).add(connection);
        }
        catch (CDMException e) {
            throw new SMLException("Unable to connect signal to parameter '" + paramName + "'", e);
        }
    }

    @Override
    public boolean isInputConnected(String inputName) {
        int inputIndex = this.getSignalIndex(this.inputData, inputName);
        if (inputIndex < 0) {
            return false;
        }
        return !this.inputConnections.get(inputIndex).isEmpty();
    }

    @Override
    public boolean isOutputConnected(String outputName) {
        int outputIndex = this.getSignalIndex(this.outputData, outputName);
        if (outputIndex < 0) {
            return false;
        }
        return !this.outputConnections.get(outputIndex).isEmpty();
    }

    @Override
    public boolean isParamConnected(String paramName) {
        int paramIndex = this.getSignalIndex(this.paramData, paramName);
        if (paramIndex < 0) {
            return false;
        }
        return !this.paramConnections.get(paramIndex).isEmpty();
    }

    @Override
    public IOPropertyList getInputList() {
        return this.inputData;
    }

    @Override
    public IOPropertyList getOutputList() {
        return this.outputData;
    }

    @Override
    public IOPropertyList getParameterList() {
        return this.paramData;
    }

    @Override
    public List<DataConnectionList> getInputConnections() {
        return this.inputConnections;
    }

    @Override
    public List<DataConnectionList> getParamConnections() {
        return this.outputConnections;
    }

    @Override
    public List<DataConnectionList> getOutputConnections() {
        return this.paramConnections;
    }

    protected int getSignalIndex(OgcPropertyList<?> ioList, String signalName) {
        for (int i = 0; i < ioList.size(); ++i) {
            if (!signalName.equals(ioList.getProperty(i).getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isUsingQueueBuffers() {
        return this.usingQueueBuffers;
    }

    @Override
    public void setUsingQueueBuffers(boolean usingQueueBuffers) {
        this.usingQueueBuffers = usingQueueBuffers;
    }

    @Override
    public boolean needSync() {
        return this.needSync;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

