/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.vast.process.IProcessExec;
import org.vast.process.SMLException;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessLoader {
    public static Hashtable<String, String> processMap = null;

    public synchronized IProcessExec loadProcess(String uri) throws SMLException {
        if (processMap == null) {
            throw new SMLException("No process map file loaded");
        }
        String className = processMap.get(uri);
        if (className == null) {
            throw new SMLException("No executable process implementation found for URI " + uri);
        }
        IProcessExec newProcess = null;
        try {
            Class<?> readerClass = Class.forName(className);
            Class[] constArgTypes = new Class[]{};
            Constructor<?> constMethod = readerClass.getConstructor(constArgTypes);
            Object[] constArgValues = new Object[]{};
            newProcess = (IProcessExec)constMethod.newInstance(constArgValues);
        }
        catch (ClassNotFoundException e) {
            throw new SMLException("Class '" + className + "' implementing process '" + uri + "' was not found");
        }
        catch (NoSuchMethodException e) {
            throw new SMLException("Invalid DataProcess", e);
        }
        catch (IllegalAccessException e) {
            throw new SMLException("Invalid DataProcess", e);
        }
        catch (InstantiationException e) {
            throw new SMLException("Invalid DataProcess", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            e.getTargetException().printStackTrace();
            return null;
        }
        return newProcess;
    }

    public static synchronized void reloadMaps(String libFileUrl) throws SMLException {
        if (processMap != null) {
            processMap.clear();
        }
        ProcessLoader.loadMaps(libFileUrl, true);
    }

    public static synchronized void loadMaps(String libFileUrl, boolean replace) throws SMLException {
        try {
            DOMHelper dom = new DOMHelper(libFileUrl, false);
            NodeList processElts = dom.getElements("Process");
            if (processMap == null) {
                processMap = new Hashtable(processElts.getLength());
            }
            for (int i = 0; i < processElts.getLength(); ++i) {
                Element processElt = (Element)processElts.item(i);
                String className = dom.getElementValue(processElt, "class");
                NodeList uriElts = dom.getElements(processElt, "uri");
                for (int j = 0; j < uriElts.getLength(); ++j) {
                    Element uriElt = (Element)uriElts.item(j);
                    String uri = dom.getElementValue(uriElt, "");
                    if (!replace && processMap.get(uri) != null) continue;
                    processMap.put(uri, className);
                }
            }
        }
        catch (DOMHelperException e) {
            throw new SMLException("Error while reading Process Map File", e);
        }
    }
}

