/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.util.Arrays;
import net.opengis.sensorml.v20.AbstractProcess;
import net.opengis.sensorml.v20.AggregateProcess;
import net.opengis.sensorml.v20.ConstraintSetting;
import net.opengis.sensorml.v20.DataInterface;
import net.opengis.sensorml.v20.Settings;
import net.opengis.sensorml.v20.SimpleProcess;
import net.opengis.sensorml.v20.ValueSetting;
import net.opengis.swe.v20.AbstractSWEIdentifiable;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.DataStream;
import net.opengis.swe.v20.HasConstraints;
import net.opengis.swe.v20.RangeComponent;
import net.opengis.swe.v20.ScalarComponent;
import org.isotc211.v2005.gmd.CIResponsibleParty;
import org.isotc211.v2005.gmd.impl.CIResponsiblePartyImpl;
import org.vast.cdm.common.CDMException;
import org.vast.process.SMLException;
import org.vast.sensorML.AbstractProcessImpl;
import org.vast.sensorML.ExecutableChainImpl;
import org.vast.sensorML.ExecutableProcessImpl;
import org.vast.sensorML.ProcessLoader;
import org.vast.sensorML.SMLFactory;
import org.vast.swe.SWEHelper;

public class SMLHelper
extends SMLFactory {
    public CIResponsibleParty newResponsibleParty() {
        return new CIResponsiblePartyImpl();
    }

    public static DataComponent getIOComponent(AbstractSWEIdentifiable ioDef) {
        if (ioDef instanceof DataInterface) {
            return ((DataInterface)ioDef).getData().getElementType();
        }
        if (ioDef instanceof DataStream) {
            return ((DataStream)ioDef).getElementType();
        }
        return (DataComponent)ioDef;
    }

    public static DataEncoding getIOEncoding(AbstractSWEIdentifiable ioDef) {
        if (ioDef instanceof DataInterface) {
            return ((DataInterface)ioDef).getData().getEncoding();
        }
        if (ioDef instanceof DataStream) {
            return ((DataStream)ioDef).getEncoding();
        }
        return null;
    }

    public static DataComponent findComponentByPath(AbstractProcess parent, String path) throws SMLException {
        return SMLHelper.findComponentByPath(parent, path.split("/"));
    }

    public static DataComponent findComponentByPath(AbstractProcess parent, String[] path) throws SMLException {
        int index = 0;
        String nextPart = path[index];
        while (nextPart.equals("components")) {
            if (!(parent instanceof AggregateProcess)) {
                throw new SMLException("Path " + Arrays.toString(path) + " references a sub-process from a non-aggregate process");
            }
            String processName = path[++index];
            parent = ((AggregateProcess)parent).getComponent(processName);
            nextPart = path[++index];
        }
        try {
            String name;
            if (nextPart.equals("inputs")) {
                name = path[++index];
                path = Arrays.copyOfRange(path, ++index, path.length);
                DataComponent input = parent.getInputComponent(name);
                return SWEHelper.findComponentByPath((DataComponent)input, (String[])path);
            }
            if (nextPart.equals("outputs")) {
                name = path[++index];
                path = Arrays.copyOfRange(path, ++index, path.length);
                DataComponent output = parent.getOutputComponent(name);
                return SWEHelper.findComponentByPath((DataComponent)output, (String[])path);
            }
            if (nextPart.equals("parameters")) {
                name = path[++index];
                path = Arrays.copyOfRange(path, ++index, path.length);
                DataComponent param = parent.getParameterComponent(name);
                return SWEHelper.findComponentByPath((DataComponent)param, (String[])path);
            }
            throw new SMLException("Invalid path " + Arrays.toString(path));
        }
        catch (CDMException e) {
            throw new SMLException("Invalid path " + Arrays.toString(path), e);
        }
    }

    public static void makeProcessExecutable(AbstractProcessImpl process) throws SMLException {
        ProcessLoader processLoader = new ProcessLoader();
        SMLHelper.makeProcessExecutable(process, processLoader);
    }

    public static void makeProcessExecutable(AbstractProcessImpl process, ProcessLoader processLoader) throws SMLException {
        if (process instanceof AggregateProcess) {
            for (AbstractProcess childProcess : ((AggregateProcess)((Object)process)).getComponentList()) {
                SMLHelper.makeProcessExecutable((AbstractProcessImpl)childProcess, processLoader);
            }
            process.setExecutableImpl(new ExecutableChainImpl());
        } else if (process instanceof SimpleProcess) {
            String processUID = ((SimpleProcess)((Object)process)).getMethodProperty().getHref();
            if (processUID == null) {
                processUID = ((SimpleProcess)((Object)process)).getTypeOf().getHref();
            }
            if (processUID == null) {
                throw new SMLException("No executable method specified for process " + process.getId());
            }
            ExecutableProcessImpl processExec = (ExecutableProcessImpl)processLoader.loadProcess(processUID);
            process.setExecutableImpl(processExec);
        }
    }

    public static AbstractProcess getConfiguredInstance(AbstractProcess process, boolean mergeMetadata) throws SMLException {
        AbstractProcess baseProcess = null;
        String typeOfUrl = process.getTypeOf().getHref();
        if (typeOfUrl != null) {
            Settings settings = (Settings)process.getConfiguration();
            SMLHelper.applyConfig(baseProcess, settings);
        }
        return baseProcess;
    }

    public static void applyConfig(AbstractProcess process, Settings settings) throws SMLException {
        DataComponent comp;
        String refPath;
        for (ValueSetting valueSetting : settings.getSetValueList()) {
            refPath = valueSetting.getRef();
            comp = SMLHelper.findComponentByPath(process, refPath);
            if (comp instanceof ScalarComponent) {
                comp.getData().setStringValue(valueSetting.getValue());
                continue;
            }
            if (comp instanceof RangeComponent) {
                String[] minMax = valueSetting.getValue().split(" ");
                comp.getData().setStringValue(0, minMax[0]);
                comp.getData().setStringValue(1, minMax[1]);
                continue;
            }
            throw new SMLException("A value setting can only target a scalar or range component");
        }
        for (ConstraintSetting constraintSetting : settings.getSetConstraintList()) {
            refPath = constraintSetting.getRef();
            comp = SMLHelper.findComponentByPath(process, refPath);
            if (comp instanceof HasConstraints) {
                try {
                    ((HasConstraints)comp).setConstraint(constraintSetting.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new SMLException("Invalid constraint for component " + refPath);
                }
            }
            throw new SMLException("A constraint setting can only target a simple component with constraint");
        }
    }
}

