/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.Factory;
import net.opengis.gml.v32.impl.GMLFactory;
import net.opengis.sensorml.v20.AggregateProcess;
import net.opengis.sensorml.v20.PhysicalComponent;
import net.opengis.sensorml.v20.PhysicalSystem;
import net.opengis.sensorml.v20.SimpleProcess;
import net.opengis.sensorml.v20.bind.XMLStreamBindings;
import org.isotc211.v2005.gco.impl.GCOFactory;
import org.isotc211.v2005.gmd.impl.GMDFactory;
import org.vast.data.SWEFactory;
import org.vast.ogc.gml.IFeatureStaxBindings;
import org.vast.sensorML.SMLFactory;

public class SMLStaxBindings
extends XMLStreamBindings
implements IFeatureStaxBindings {
    public SMLStaxBindings() {
        super(new SMLFactory(), (net.opengis.swe.v20.Factory)new SWEFactory(), (Factory)new GMLFactory(), new GMDFactory(), new GCOFactory());
        this.nsContext.registerNamespace("xlink", "http://www.w3.org/1999/xlink");
        this.nsContext.registerNamespace("sml", "http://www.opengis.net/sensorml/2.0");
        this.nsContext.registerNamespace("swe", "http://www.opengis.net/swe/2.0");
        this.nsContext.registerNamespace("gml", "http://www.opengis.net/gml/3.2");
        this.nsContext.registerNamespace("gco", "http://www.isotc211.org/2005/gco");
        this.nsContext.registerNamespace("gmd", "http://www.isotc211.org/2005/gmd");
    }

    public Collection<QName> getSupportedFeatureTypes() {
        return Arrays.asList(SimpleProcess.DEFAULT_QNAME, AggregateProcess.DEFAULT_QNAME, PhysicalComponent.DEFAULT_QNAME, PhysicalSystem.DEFAULT_QNAME);
    }

    public AbstractFeature readFeature(XMLStreamReader reader, QName qName) throws XMLStreamException {
        String eltName = qName.getLocalPart();
        if (eltName.equals(SimpleProcess.DEFAULT_QNAME.getLocalPart())) {
            return this.readSimpleProcess(reader);
        }
        if (eltName.equals(AggregateProcess.DEFAULT_QNAME.getLocalPart())) {
            return this.readAggregateProcess(reader);
        }
        if (eltName.equals(PhysicalComponent.DEFAULT_QNAME.getLocalPart())) {
            return this.readPhysicalComponent(reader);
        }
        if (eltName.equals(PhysicalSystem.DEFAULT_QNAME.getLocalPart())) {
            return this.readPhysicalSystem(reader);
        }
        throw new IllegalStateException("Unsupported feature type: " + qName);
    }

    public void writeFeature(XMLStreamWriter writer, AbstractFeature bean) throws XMLStreamException {
        String eltName = bean.getQName().getLocalPart();
        this.ensurePrefix(writer, bean.getQName());
        if (eltName.equals(SimpleProcess.DEFAULT_QNAME.getLocalPart())) {
            this.writeSimpleProcess(writer, (SimpleProcess)bean);
        } else if (eltName.equals(AggregateProcess.DEFAULT_QNAME.getLocalPart())) {
            this.writeAggregateProcess(writer, (AggregateProcess)bean);
        } else if (eltName.equals(PhysicalComponent.DEFAULT_QNAME.getLocalPart())) {
            this.writePhysicalComponent(writer, (PhysicalComponent)bean);
        } else if (eltName.equals(PhysicalSystem.DEFAULT_QNAME.getLocalPart())) {
            this.writePhysicalSystem(writer, (PhysicalSystem)bean);
        } else {
            throw new IllegalStateException("Unsupported feature type: " + bean.getQName());
        }
    }
}

