/*
 * Decompiled with CFR 0.152.
 */
package org.vast.sensorML;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.sensorml.v20.AbstractProcess;
import org.vast.ogc.OGCRegistry;
import org.vast.sensorML.SMLStaxBindings;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLBindingsUtils;
import org.vast.xml.XMLReaderException;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;

public class SMLUtils
extends XMLBindingsUtils {
    public static final String IC = "IC";
    public static final String SENSORML = "SensorML";
    public static final String V2_0 = "2.0";

    public static void loadRegistry() {
        String mapFileUrl = SMLUtils.class.getResource("SMLRegistry.xml").toString();
        OGCRegistry.loadMaps((String)mapFileUrl, (boolean)false);
    }

    public SMLUtils(String version) {
        this.staxBindings = new SMLStaxBindings();
    }

    public AbstractProcess readProcess(DOMHelper dom, Element processElt) throws XMLReaderException {
        return (AbstractProcess)this.readFromDom(dom, processElt, ObjectType.Process);
    }

    public AbstractProcess readProcess(InputStream is) throws XMLReaderException {
        return (AbstractProcess)this.readFromStream(is, ObjectType.Process);
    }

    public Element writeProcess(DOMHelper dom, AbstractProcess process) throws XMLWriterException {
        return this.writeToDom(dom, process, ObjectType.Process);
    }

    public void writeProcess(OutputStream os, AbstractProcess process, boolean indent) throws XMLWriterException, IOException {
        this.writeToStream(os, process, ObjectType.Process, indent);
    }

    public String getVersion(DOMHelper dom, Element smlElt) {
        String smlUri = smlElt.getNamespaceURI();
        String version = smlUri.substring(smlUri.lastIndexOf(47) + 1);
        if (!version.matches("^\\d+(\\.\\d+)?(\\.\\d+)?$")) {
            version = "0.0";
        }
        return version;
    }

    protected Object readFromXmlStream(XMLStreamReader reader, Enum<?> eltType) throws XMLStreamException {
        reader.nextTag();
        SMLStaxBindings smlBindings = (SMLStaxBindings)this.staxBindings;
        switch ((ObjectType)eltType) {
            case Process: {
                return smlBindings.readAbstractProcess(reader);
            }
        }
        return null;
    }

    protected void writeToXmlStream(XMLStreamWriter writer, Object sweObj, Enum<?> eltType) throws XMLStreamException {
        SMLStaxBindings smlBindings = (SMLStaxBindings)this.staxBindings;
        switch ((ObjectType)eltType) {
            case Process: {
                smlBindings.writeAbstractProcess(writer, (AbstractProcess)sweObj);
                return;
            }
        }
    }

    static {
        SMLUtils.loadRegistry();
    }

    static enum ObjectType {
        Process{

            public String toString() {
                return "SML Process";
            }
        };

    }
}

