/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.bind;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.AbstractXMLStreamBindings;
import net.opengis.OgcProperty;
import net.opengis.OgcPropertyImpl;
import net.opengis.gml.v32.AbstractCurve;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.AbstractGML;
import net.opengis.gml.v32.AbstractGeometry;
import net.opengis.gml.v32.AbstractSurface;
import net.opengis.gml.v32.AbstractTimeGeometricPrimitive;
import net.opengis.gml.v32.AbstractTimePrimitive;
import net.opengis.gml.v32.Code;
import net.opengis.gml.v32.CodeList;
import net.opengis.gml.v32.CodeOrNilReasonList;
import net.opengis.gml.v32.CodeWithAuthority;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.Factory;
import net.opengis.gml.v32.FeatureCollection;
import net.opengis.gml.v32.LineString;
import net.opengis.gml.v32.LinearRing;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Polygon;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.TimeIndeterminateValue;
import net.opengis.gml.v32.TimeInstant;
import net.opengis.gml.v32.TimeIntervalLength;
import net.opengis.gml.v32.TimePeriod;
import net.opengis.gml.v32.TimePosition;
import net.opengis.gml.v32.TimeUnit;

public class XMLStreamBindings
extends AbstractXMLStreamBindings {
    public static final String NS_URI = "http://www.opengis.net/gml/3.2";
    protected Factory factory;

    public XMLStreamBindings(Factory factory) {
        this.factory = factory;
    }

    public AbstractFeature readAbstractFeatureType(XMLStreamReader reader, AbstractFeature bean) throws XMLStreamException {
        Map attrMap = this.collectAttributes(reader);
        this.readAbstractFeatureTypeAttributes(attrMap, bean);
        this.readAbstractFeatureTypeElements(reader, bean);
        return bean;
    }

    public void readAbstractFeatureTypeAttributes(Map<String, String> attrMap, AbstractFeature bean) throws XMLStreamException {
        this.readAbstractGMLTypeAttributes(attrMap, bean);
    }

    public void readAbstractFeatureTypeElements(XMLStreamReader reader, AbstractFeature bean) throws XMLStreamException {
        this.readAbstractGMLTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "boundedBy");
        if (found) {
            reader.nextTag();
            String localName = reader.getName().getLocalPart();
            if (!localName.equals("Envelope")) {
                throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
            }
            Envelope boundedBy = this.readEnvelope(reader);
            bean.setBoundedByAsEnvelope(boundedBy);
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "location")) {
            reader.nextTag();
            AbstractGeometry location = this.readAbstractGeometry(reader);
            bean.setLocation(location);
            reader.nextTag();
            reader.nextTag();
        }
    }

    public void writeAbstractFeatureTypeAttributes(XMLStreamWriter writer, AbstractFeature bean) throws XMLStreamException {
        this.writeAbstractGMLTypeAttributes(writer, bean);
    }

    public void writeAbstractFeatureTypeElements(XMLStreamWriter writer, AbstractFeature bean) throws XMLStreamException {
        this.writeAbstractGMLTypeElements(writer, bean);
        if (bean.isSetBoundedBy()) {
            writer.writeStartElement(NS_URI, "boundedBy");
            this.writeEnvelope(writer, bean.getBoundedBy());
            writer.writeEndElement();
        }
        if (bean.isSetLocation()) {
            writer.writeStartElement(NS_URI, "location");
            this.writePropertyAttributes(writer, bean.getLocationProperty());
            if (bean.getLocationProperty().hasValue()) {
                this.writeAbstractGeometry(writer, bean.getLocation());
            }
            writer.writeEndElement();
        }
    }

    public void readFeatureCollectionTypeAttributes(Map<String, String> attrMap, FeatureCollection bean) throws XMLStreamException {
        this.readAbstractFeatureTypeAttributes(attrMap, bean);
    }

    public void readFeatureCollectionTypeElements(XMLStreamReader reader, FeatureCollection bean) throws XMLStreamException {
        boolean found;
        this.readAbstractFeatureTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "featureMember"))) continue;
            OgcPropertyImpl featureMemberProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)featureMemberProp);
            if (featureMemberProp.getHref() == null) {
                reader.nextTag();
                featureMemberProp.setValue((Object)this.readAbstractFeature(reader));
            }
            bean.getFeatureMemberList().add((OgcProperty)featureMemberProp);
            reader.nextTag();
            reader.nextTag();
        } while (found);
        found = this.checkElementName(reader, "featureMembers");
        if (found) {
            reader.nextTag();
            AbstractFeature featureMembers = this.readAbstractFeature(reader);
            if (featureMembers != null) {
                bean.setFeatureMembers(featureMembers);
            }
            reader.nextTag();
            reader.nextTag();
        }
    }

    public void writeFeatureCollectionTypeAttributes(XMLStreamWriter writer, FeatureCollection bean) throws XMLStreamException {
        this.writeAbstractFeatureTypeAttributes(writer, bean);
    }

    public void writeFeatureCollectionTypeElements(XMLStreamWriter writer, FeatureCollection bean) throws XMLStreamException {
        this.writeAbstractFeatureTypeElements(writer, bean);
        int numItems = bean.getFeatureMemberList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getFeatureMemberList().getProperty(i);
            writer.writeStartElement(NS_URI, "featureMember");
            this.writePropertyAttributes(writer, item);
            this.writeAbstractFeature(writer, (AbstractFeature)item.getValue());
            writer.writeEndElement();
        }
        if (bean.isSetFeatureMembers()) {
            writer.writeStartElement(NS_URI, "featureMembers");
            this.writeAbstractFeature(writer, bean.getFeatureMembers());
            writer.writeEndElement();
        }
    }

    public FeatureCollection readFeatureCollectionType(XMLStreamReader reader) throws XMLStreamException {
        FeatureCollection bean = this.factory.newFeatureCollection();
        Map attrMap = this.collectAttributes(reader);
        this.readFeatureCollectionTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readFeatureCollectionTypeElements(reader, bean);
        return bean;
    }

    public void writeFeatureCollectionType(XMLStreamWriter writer, FeatureCollection bean) throws XMLStreamException {
        this.writeFeatureCollectionTypeAttributes(writer, bean);
        this.writeFeatureCollectionTypeElements(writer, bean);
    }

    public void readAbstractTimePrimitiveTypeAttributes(Map<String, String> attrMap, AbstractTimePrimitive bean) throws XMLStreamException {
        this.readAbstractGMLTypeAttributes(attrMap, bean);
    }

    public void readAbstractTimePrimitiveTypeElements(XMLStreamReader reader, AbstractTimePrimitive bean) throws XMLStreamException {
        boolean found;
        this.readAbstractGMLTypeElements(reader, bean);
        do {
            if (!(found = this.checkElementName(reader, "relatedTime"))) continue;
            OgcPropertyImpl relatedTimeProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)relatedTimeProp);
            if (relatedTimeProp.getHref() == null) {
                reader.nextTag();
                relatedTimeProp.setValue((Object)this.readAbstractTimeGeometricPrimitive(reader));
            }
            bean.getRelatedTimeList().add((OgcProperty)relatedTimeProp);
            reader.nextTag();
            reader.nextTag();
        } while (found);
    }

    public void writeAbstractTimePrimitiveTypeAttributes(XMLStreamWriter writer, AbstractTimePrimitive bean) throws XMLStreamException {
        this.writeAbstractGMLTypeAttributes(writer, bean);
    }

    public void writeAbstractTimePrimitiveTypeElements(XMLStreamWriter writer, AbstractTimePrimitive bean) throws XMLStreamException {
        this.writeAbstractGMLTypeElements(writer, bean);
        int numItems = bean.getRelatedTimeList().size();
        for (int i = 0; i < numItems; ++i) {
            OgcProperty item = bean.getRelatedTimeList().getProperty(i);
            writer.writeStartElement(NS_URI, "relatedTime");
            this.writePropertyAttributes(writer, item);
            this.writeAbstractTimeGeometricPrimitive(writer, (AbstractTimeGeometricPrimitive)item.getValue());
            writer.writeEndElement();
        }
    }

    public void readAbstractTimeGeometricPrimitiveTypeAttributes(Map<String, String> attrMap, AbstractTimeGeometricPrimitive bean) throws XMLStreamException {
        this.readAbstractTimePrimitiveTypeAttributes(attrMap, bean);
        String val = attrMap.get("frame");
        if (val != null) {
            bean.setFrame(val);
        }
    }

    public void readAbstractTimeGeometricPrimitiveTypeElements(XMLStreamReader reader, AbstractTimeGeometricPrimitive bean) throws XMLStreamException {
        this.readAbstractTimePrimitiveTypeElements(reader, bean);
    }

    public void writeAbstractTimeGeometricPrimitiveTypeAttributes(XMLStreamWriter writer, AbstractTimeGeometricPrimitive bean) throws XMLStreamException {
        this.writeAbstractTimePrimitiveTypeAttributes(writer, bean);
        if (bean.isSetFrame()) {
            writer.writeAttribute("frame", this.getStringValue(bean.getFrame()));
        }
    }

    public void writeAbstractTimeGeometricPrimitiveTypeElements(XMLStreamWriter writer, AbstractTimeGeometricPrimitive bean) throws XMLStreamException {
        this.writeAbstractTimePrimitiveTypeElements(writer, bean);
    }

    public TimeInstant readTimeInstantType(XMLStreamReader reader) throws XMLStreamException {
        TimeInstant bean = this.factory.newTimeInstant();
        Map attrMap = this.collectAttributes(reader);
        this.readTimeInstantTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readTimeInstantTypeElements(reader, bean);
        return bean;
    }

    public void readTimeInstantTypeAttributes(Map<String, String> attrMap, TimeInstant bean) throws XMLStreamException {
        this.readAbstractTimeGeometricPrimitiveTypeAttributes(attrMap, bean);
    }

    public void readTimeInstantTypeElements(XMLStreamReader reader, TimeInstant bean) throws XMLStreamException {
        this.readAbstractTimeGeometricPrimitiveTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "timePosition");
        if (found) {
            TimePosition timePosition = this.readTimePositionType(reader);
            if (timePosition != null) {
                bean.setTimePosition(timePosition);
            }
            reader.nextTag();
        }
    }

    public void writeTimeInstantType(XMLStreamWriter writer, TimeInstant bean) throws XMLStreamException {
        this.writeTimeInstantTypeAttributes(writer, bean);
        this.writeTimeInstantTypeElements(writer, bean);
    }

    public void writeTimeInstantTypeAttributes(XMLStreamWriter writer, TimeInstant bean) throws XMLStreamException {
        this.writeAbstractTimeGeometricPrimitiveTypeAttributes(writer, bean);
    }

    public void writeTimeInstantTypeElements(XMLStreamWriter writer, TimeInstant bean) throws XMLStreamException {
        this.writeAbstractTimeGeometricPrimitiveTypeElements(writer, bean);
        writer.writeStartElement(NS_URI, "timePosition");
        this.writeTimePositionType(writer, bean.getTimePosition());
        writer.writeEndElement();
    }

    public TimePeriod readTimePeriodType(XMLStreamReader reader) throws XMLStreamException {
        TimePeriod bean = this.factory.newTimePeriod();
        Map attrMap = this.collectAttributes(reader);
        this.readTimePeriodTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readTimePeriodTypeElements(reader, bean);
        return bean;
    }

    public void readTimePeriodTypeAttributes(Map<String, String> attrMap, TimePeriod bean) throws XMLStreamException {
        this.readAbstractTimeGeometricPrimitiveTypeAttributes(attrMap, bean);
    }

    public void readTimePeriodTypeElements(XMLStreamReader reader, TimePeriod bean) throws XMLStreamException {
        this.readAbstractTimeGeometricPrimitiveTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "beginPosition");
        if (found) {
            TimePosition beginPosition = this.readTimePositionType(reader);
            if (beginPosition != null) {
                bean.setBeginPosition(beginPosition);
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "begin")) {
            OgcProperty<TimeInstant> beginProp = bean.getBeginProperty();
            this.readPropertyAttributes(reader, beginProp);
            if (beginProp.getHref() == null) {
                reader.nextTag();
                beginProp.setValue((Object)this.readTimeInstant(reader));
            }
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "endPosition")) {
            TimePosition endPosition = this.readTimePositionType(reader);
            if (endPosition != null) {
                bean.setEndPosition(endPosition);
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "end")) {
            OgcProperty<TimeInstant> endProp = bean.getEndProperty();
            this.readPropertyAttributes(reader, endProp);
            if (endProp.getHref() == null) {
                reader.nextTag();
                endProp.setValue((Object)this.readTimeInstant(reader));
            }
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "duration")) {
            String val = reader.getElementText();
            if (val != null) {
                bean.setDuration(this.getDurationFromString(val));
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "timeInterval")) {
            TimeIntervalLength timeInterval = this.readTimeIntervalLengthType(reader);
            if (timeInterval != null) {
                bean.setTimeInterval(timeInterval);
            }
            reader.nextTag();
        }
    }

    public void writeTimePeriodType(XMLStreamWriter writer, TimePeriod bean) throws XMLStreamException {
        this.writeTimePeriodTypeAttributes(writer, bean);
        this.writeTimePeriodTypeElements(writer, bean);
    }

    public void writeTimePeriodTypeAttributes(XMLStreamWriter writer, TimePeriod bean) throws XMLStreamException {
        this.writeAbstractTimeGeometricPrimitiveTypeAttributes(writer, bean);
    }

    public void writeTimePeriodTypeElements(XMLStreamWriter writer, TimePeriod bean) throws XMLStreamException {
        this.writeAbstractTimeGeometricPrimitiveTypeElements(writer, bean);
        if (bean.isSetBeginPosition()) {
            writer.writeStartElement(NS_URI, "beginPosition");
            this.writeTimePositionType(writer, bean.getBeginPosition());
            writer.writeEndElement();
        }
        if (bean.isSetBegin()) {
            writer.writeStartElement(NS_URI, "begin");
            this.writePropertyAttributes(writer, bean.getBeginProperty());
            this.writeTimeInstant(writer, bean.getBegin());
            writer.writeEndElement();
        }
        if (bean.isSetEndPosition()) {
            writer.writeStartElement(NS_URI, "endPosition");
            this.writeTimePositionType(writer, bean.getEndPosition());
            writer.writeEndElement();
        }
        if (bean.isSetEnd()) {
            writer.writeStartElement(NS_URI, "end");
            this.writePropertyAttributes(writer, bean.getEndProperty());
            this.writeTimeInstant(writer, bean.getEnd());
            writer.writeEndElement();
        }
        if (bean.isSetDuration()) {
            writer.writeStartElement(NS_URI, "duration");
            writer.writeCharacters(this.getIsoDurationString(bean.getDuration()));
            writer.writeEndElement();
        }
        if (bean.isSetTimeInterval()) {
            writer.writeStartElement(NS_URI, "timeInterval");
            this.writeTimeIntervalLengthType(writer, bean.getTimeInterval());
            writer.writeEndElement();
        }
    }

    public TimePosition readTimePositionType(XMLStreamReader reader) throws XMLStreamException {
        TimePosition bean = this.factory.newTimePosition();
        Map attrMap = this.collectAttributes(reader);
        this.readTimePositionTypeAttributes(attrMap, bean);
        String val = reader.getElementText();
        if (val != null && val.trim().length() > 0) {
            bean.setDateTimeValue(this.getDateTimeFromString(val));
        }
        return bean;
    }

    public void readTimePositionTypeAttributes(Map<String, String> attrMap, TimePosition bean) throws XMLStreamException {
        String val = attrMap.get("frame");
        if (val != null) {
            bean.setFrame(val);
        }
        if ((val = attrMap.get("calendarEraName")) != null) {
            bean.setCalendarEraName(val);
        }
        if ((val = attrMap.get("indeterminatePosition")) != null) {
            bean.setIndeterminatePosition(TimeIndeterminateValue.fromString(val));
        }
    }

    public void writeTimePositionType(XMLStreamWriter writer, TimePosition bean) throws XMLStreamException {
        this.writeTimePositionTypeAttributes(writer, bean);
        if (bean.getDateTimeValue() != null) {
            writer.writeCharacters(this.getStringValue(bean.getDateTimeValue()));
        }
    }

    public void writeTimePositionTypeAttributes(XMLStreamWriter writer, TimePosition bean) throws XMLStreamException {
        if (bean.isSetFrame()) {
            writer.writeAttribute("frame", this.getStringValue(bean.getFrame()));
        }
        if (bean.isSetCalendarEraName()) {
            writer.writeAttribute("calendarEraName", this.getStringValue(bean.getCalendarEraName()));
        }
        if (bean.isSetIndeterminatePosition()) {
            writer.writeAttribute("indeterminatePosition", this.getStringValue((Object)bean.getIndeterminatePosition()));
        }
    }

    public TimeIntervalLength readTimeIntervalLengthType(XMLStreamReader reader) throws XMLStreamException {
        TimeIntervalLength bean = this.factory.newTimeIntervalLength();
        Map attrMap = this.collectAttributes(reader);
        this.readTimeIntervalLengthTypeAttributes(attrMap, bean);
        String val = reader.getElementText();
        if (val != null) {
            bean.setValue(this.getDoubleFromString(val));
        }
        return bean;
    }

    public void readTimeIntervalLengthTypeAttributes(Map<String, String> attrMap, TimeIntervalLength bean) throws XMLStreamException {
        String val = attrMap.get("unit");
        if (val != null) {
            bean.setUnit(TimeUnit.fromString(val));
        }
        if ((val = attrMap.get("radix")) != null) {
            bean.setRadix(this.getIntFromString(val));
        }
        if ((val = attrMap.get("factor")) != null) {
            bean.setFactor(this.getIntFromString(val));
        }
    }

    public void writeTimeIntervalLengthType(XMLStreamWriter writer, TimeIntervalLength bean) throws XMLStreamException {
        this.writeTimeIntervalLengthTypeAttributes(writer, bean);
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public void writeTimeIntervalLengthTypeAttributes(XMLStreamWriter writer, TimeIntervalLength bean) throws XMLStreamException {
        writer.writeAttribute("unit", this.getStringValue((Object)bean.getUnit()));
        if (bean.isSetRadix()) {
            writer.writeAttribute("radix", this.getStringValue(bean.getRadix()));
        }
        if (bean.isSetFactor()) {
            writer.writeAttribute("factor", this.getStringValue(bean.getFactor()));
        }
    }

    public void readAbstractGeometryTypeAttributes(Map<String, String> attrMap, AbstractGeometry bean) throws XMLStreamException {
        this.readAbstractGMLTypeAttributes(attrMap, bean);
        String val = attrMap.get("srsName");
        if (val != null) {
            bean.setSrsName(val);
        }
        if ((val = attrMap.get("srsDimension")) != null) {
            bean.setSrsDimension(this.getIntFromString(val));
        }
        if ((val = attrMap.get("axisLabels")) != null) {
            bean.setAxisLabels(this.getStringArrayFromString(val));
        }
        if ((val = attrMap.get("uomLabels")) != null) {
            bean.setUomLabels(this.getStringArrayFromString(val));
        }
    }

    public void readAbstractGeometryTypeElements(XMLStreamReader reader, AbstractGeometry bean) throws XMLStreamException {
        this.readAbstractGMLTypeElements(reader, bean);
    }

    public void writeAbstractGeometryTypeAttributes(XMLStreamWriter writer, AbstractGeometry bean) throws XMLStreamException {
        this.writeAbstractGMLTypeAttributes(writer, bean);
        if (bean.isSetSrsName()) {
            writer.writeAttribute("srsName", this.getStringValue(bean.getSrsName()));
        }
        if (bean.isSetSrsDimension()) {
            writer.writeAttribute("srsDimension", this.getStringValue(bean.getSrsDimension()));
        }
        if (bean.isSetAxisLabels()) {
            writer.writeAttribute("axisLabels", this.getStringValue(bean.getAxisLabels()));
        }
        if (bean.isSetUomLabels()) {
            writer.writeAttribute("uomLabels", this.getStringValue(bean.getUomLabels()));
        }
    }

    public void writeAbstractGeometryTypeElements(XMLStreamWriter writer, AbstractGeometry bean) throws XMLStreamException {
        this.writeAbstractGMLTypeElements(writer, bean);
    }

    public Envelope readEnvelopeType(XMLStreamReader reader) throws XMLStreamException {
        Envelope bean = this.factory.newEnvelope();
        Map attrMap = this.collectAttributes(reader);
        this.readEnvelopeTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readEnvelopeTypeElements(reader, bean);
        return bean;
    }

    public void readEnvelopeTypeAttributes(Map<String, String> attrMap, Envelope bean) throws XMLStreamException {
        String val = attrMap.get("srsName");
        if (val != null) {
            bean.setSrsName(val);
        }
        if ((val = attrMap.get("srsDimension")) != null) {
            bean.setSrsDimension(this.getIntFromString(val));
        }
        if ((val = attrMap.get("axisLabels")) != null) {
            bean.setAxisLabels(this.getStringArrayFromString(val));
        }
        if ((val = attrMap.get("uomLabels")) != null) {
            bean.setUomLabels(this.getStringArrayFromString(val));
        }
    }

    public void readEnvelopeTypeElements(XMLStreamReader reader, Envelope bean) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "lowerCorner");
        if (found) {
            String lowerCorner = reader.getElementText();
            if (lowerCorner != null) {
                bean.setLowerCorner(this.getDoubleArrayFromString(lowerCorner));
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "upperCorner")) {
            String upperCorner = reader.getElementText();
            if (upperCorner != null) {
                bean.setUpperCorner(this.getDoubleArrayFromString(upperCorner));
            }
            reader.nextTag();
        }
    }

    public void writeEnvelopeType(XMLStreamWriter writer, Envelope bean) throws XMLStreamException {
        this.writeEnvelopeTypeAttributes(writer, bean);
        this.writeEnvelopeTypeElements(writer, bean);
    }

    public void writeEnvelopeTypeAttributes(XMLStreamWriter writer, Envelope bean) throws XMLStreamException {
        if (bean.isSetSrsName()) {
            writer.writeAttribute("srsName", this.getStringValue(bean.getSrsName()));
        }
        if (bean.isSetSrsDimension()) {
            writer.writeAttribute("srsDimension", this.getStringValue(bean.getSrsDimension()));
        }
        if (bean.isSetAxisLabels()) {
            writer.writeAttribute("axisLabels", this.getStringValue(bean.getAxisLabels()));
        }
        if (bean.isSetUomLabels()) {
            writer.writeAttribute("uomLabels", this.getStringValue(bean.getUomLabels()));
        }
    }

    public void writeEnvelopeTypeElements(XMLStreamWriter writer, Envelope bean) throws XMLStreamException {
        if (bean.isSetLowerCorner()) {
            writer.writeStartElement(NS_URI, "lowerCorner");
            writer.writeCharacters(this.getStringValue(bean.getLowerCorner()));
            writer.writeEndElement();
        }
        if (bean.isSetUpperCorner()) {
            writer.writeStartElement(NS_URI, "upperCorner");
            writer.writeCharacters(this.getStringValue(bean.getUpperCorner()));
            writer.writeEndElement();
        }
    }

    public Point readPointType(XMLStreamReader reader) throws XMLStreamException {
        Point bean = this.factory.newPoint();
        Map attrMap = this.collectAttributes(reader);
        this.readPointTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readPointTypeElements(reader, bean);
        return bean;
    }

    public void readPointTypeAttributes(Map<String, String> attrMap, Point bean) throws XMLStreamException {
        this.readAbstractGeometryTypeAttributes(attrMap, bean);
    }

    public void readPointTypeElements(XMLStreamReader reader, Point bean) throws XMLStreamException {
        String pos;
        this.readAbstractGeometryTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "pos");
        if (found) {
            pos = reader.getElementText();
            if (pos != null) {
                bean.setPos(this.getDoubleArrayFromString(pos));
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "coordinates")) {
            pos = reader.getElementText();
            if (pos != null) {
                bean.setPos(this.getDoubleArrayFromString(pos));
            }
            reader.nextTag();
        }
    }

    public void writePointType(XMLStreamWriter writer, Point bean) throws XMLStreamException {
        this.writePointTypeAttributes(writer, bean);
        this.writePointTypeElements(writer, bean);
    }

    public void writePointTypeAttributes(XMLStreamWriter writer, Point bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeAttributes(writer, bean);
    }

    public void writePointTypeElements(XMLStreamWriter writer, Point bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeElements(writer, bean);
        if (bean.isSetPos()) {
            writer.writeStartElement(NS_URI, "pos");
            writer.writeCharacters(this.getStringValue(bean.getPos()));
            writer.writeEndElement();
        }
    }

    public LineString readLineStringType(XMLStreamReader reader) throws XMLStreamException {
        LineString bean = this.factory.newLineString();
        Map attrMap = this.collectAttributes(reader);
        this.readLineStringTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readLineStringTypeElements(reader, bean);
        return bean;
    }

    public void readLineStringTypeAttributes(Map<String, String> attrMap, LineString bean) throws XMLStreamException {
        this.readAbstractGeometryTypeAttributes(attrMap, bean);
    }

    public void readLineStringTypeElements(XMLStreamReader reader, LineString bean) throws XMLStreamException {
        this.readAbstractGeometryTypeElements(reader, bean);
        bean.setPosList(this.readPositionElements(reader));
    }

    public double[] readPositionElements(XMLStreamReader reader) throws XMLStreamException {
        String posString;
        double[] posList = null;
        boolean found = this.checkElementName(reader, "pos");
        if (found) {
            ArrayList<double[]> tmpList = new ArrayList<double[]>();
            int arraySize = 0;
            do {
                if (!(found = this.checkElementName(reader, "pos"))) continue;
                String pos = reader.getElementText();
                if (pos != null) {
                    double[] values = this.getDoubleArrayFromString(pos);
                    arraySize += values.length;
                    tmpList.add(values);
                }
                reader.nextTag();
            } while (found);
            posList = new double[arraySize];
            int i = 0;
            for (double[] pos : tmpList) {
                System.arraycopy(pos, 0, posList, i, pos.length);
                i += pos.length;
            }
        }
        do {
            if (!(found = this.checkElementName(reader, "pointProperty"))) continue;
            this.skipElementAndAllChildren(reader);
            reader.nextTag();
        } while (found);
        do {
            if (!(found = this.checkElementName(reader, "pointRep"))) continue;
            this.skipElementAndAllChildren(reader);
            reader.nextTag();
        } while (found);
        found = this.checkElementName(reader, "posList");
        if (found) {
            posString = reader.getElementText();
            if (posString != null) {
                posList = this.getDoubleArrayFromString(posString);
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "coordinates")) {
            posString = reader.getElementText();
            if (posString != null) {
                posList = this.getDoubleArrayFromString(posString);
            }
            reader.nextTag();
        }
        return posList;
    }

    public void writeLineStringType(XMLStreamWriter writer, LineString bean) throws XMLStreamException {
        this.writeLineStringTypeAttributes(writer, bean);
        this.writeLineStringTypeElements(writer, bean);
    }

    public void writeLineStringTypeAttributes(XMLStreamWriter writer, LineString bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeAttributes(writer, bean);
    }

    public void writeLineStringTypeElements(XMLStreamWriter writer, LineString bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeElements(writer, bean);
        if (bean.isSetPosList()) {
            writer.writeStartElement(NS_URI, "posList");
            writer.writeCharacters(this.getStringValue(bean.getPosList()));
            writer.writeEndElement();
        }
    }

    public Polygon readPolygonType(XMLStreamReader reader) throws XMLStreamException {
        Polygon bean = this.factory.newPolygon();
        Map attrMap = this.collectAttributes(reader);
        this.readPolygonTypeAttributes(attrMap, bean);
        reader.nextTag();
        this.readPolygonTypeElements(reader, bean);
        return bean;
    }

    public void readPolygonTypeAttributes(Map<String, String> attrMap, Polygon bean) throws XMLStreamException {
        this.readAbstractGeometryTypeAttributes(attrMap, bean);
    }

    public void readPolygonTypeElements(XMLStreamReader reader, Polygon bean) throws XMLStreamException {
        this.readAbstractGeometryTypeElements(reader, bean);
        boolean found = this.checkElementName(reader, "exterior");
        if (found) {
            reader.nextTag();
            LinearRing exterior = this.readLinearRing(reader);
            if (exterior != null) {
                bean.setExterior(exterior);
            }
            reader.nextTag();
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "interior"))) continue;
            reader.nextTag();
            LinearRing interior = this.readLinearRing(reader);
            if (interior != null) {
                bean.addInterior(interior);
            }
            reader.nextTag();
            reader.nextTag();
        } while (found);
    }

    public void writePolygonType(XMLStreamWriter writer, Polygon bean) throws XMLStreamException {
        this.writePolygonTypeAttributes(writer, bean);
        this.writePolygonTypeElements(writer, bean);
    }

    public void writePolygonTypeAttributes(XMLStreamWriter writer, Polygon bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeAttributes(writer, bean);
    }

    public void writePolygonTypeElements(XMLStreamWriter writer, Polygon bean) throws XMLStreamException {
        this.writeAbstractGeometryTypeElements(writer, bean);
        if (bean.isSetExterior()) {
            writer.writeStartElement(NS_URI, "exterior");
            this.writeLinearRing(writer, bean.getExterior());
            writer.writeEndElement();
        }
        int numItems = bean.getInteriorList().size();
        for (int i = 0; i < numItems; ++i) {
            LinearRing item = bean.getInteriorList().get(i);
            writer.writeStartElement(NS_URI, "interior");
            this.writeLinearRing(writer, item);
            writer.writeEndElement();
        }
    }

    public LinearRing readLinearRingType(XMLStreamReader reader) throws XMLStreamException {
        LinearRing bean = this.factory.newLinearRing();
        reader.nextTag();
        this.readLinearRingTypeElements(reader, bean);
        return bean;
    }

    public void readLinearRingTypeElements(XMLStreamReader reader, LinearRing bean) throws XMLStreamException {
        bean.setPosList(this.readPositionElements(reader));
    }

    public void writeLinearRingType(XMLStreamWriter writer, LinearRing bean) throws XMLStreamException {
        this.writeLinearRingTypeElements(writer, bean);
    }

    public void writeLinearRingTypeElements(XMLStreamWriter writer, LinearRing bean) throws XMLStreamException {
        if (bean.isSetPosList()) {
            writer.writeStartElement(NS_URI, "posList");
            writer.writeCharacters(this.getStringValue(bean.getPosList()));
            writer.writeEndElement();
        }
    }

    public void readAbstractGMLTypeAttributes(Map<String, String> attrMap, AbstractGML bean) throws XMLStreamException {
        String val = attrMap.get("id");
        if (val != null) {
            bean.setId(val);
        }
    }

    public void readAbstractGMLTypeElements(XMLStreamReader reader, AbstractGML bean) throws XMLStreamException {
        boolean found;
        do {
            if (!(found = this.checkElementName(reader, "metaDataProperty"))) continue;
            OgcPropertyImpl metaDataPropertyProp = new OgcPropertyImpl();
            this.readPropertyAttributes(reader, (OgcProperty)metaDataPropertyProp);
            if (metaDataPropertyProp.getHref() == null) {
                reader.nextTag();
                metaDataPropertyProp.setValue(this.readExtension(reader));
            }
            if (metaDataPropertyProp.hasValue() || metaDataPropertyProp.hasHref()) {
                bean.getMetaDataPropertyList().add((OgcProperty)metaDataPropertyProp);
            }
            reader.nextTag();
            reader.nextTag();
        } while (found);
        found = this.checkElementName(reader, "description");
        if (found) {
            String val = reader.getElementText();
            if (val != null) {
                bean.setDescription(val.trim());
            }
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "descriptionReference")) {
            Reference descriptionReference = this.readReferenceType(reader);
            if (descriptionReference != null) {
                bean.setDescriptionReference(descriptionReference);
            }
            reader.nextTag();
            reader.nextTag();
        }
        if (found = this.checkElementName(reader, "identifier")) {
            CodeWithAuthority identifier = this.readCodeWithAuthorityType(reader);
            if (identifier != null) {
                bean.setIdentifier(identifier);
            }
            reader.nextTag();
        }
        do {
            if (!(found = this.checkElementName(reader, "name"))) continue;
            Code name = this.readCodeType(reader);
            if (name != null) {
                bean.addName(name);
            }
            reader.nextTag();
        } while (found);
    }

    public void writeAbstractGMLTypeAttributes(XMLStreamWriter writer, AbstractGML bean) throws XMLStreamException {
        writer.writeAttribute(NS_URI, "id", this.getStringValue(bean.getId()));
    }

    public void writeAbstractGMLTypeElements(XMLStreamWriter writer, AbstractGML bean) throws XMLStreamException {
        Object item;
        int i;
        int numItems = bean.getMetaDataPropertyList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getMetaDataPropertyList().getProperty(i);
            if (item.hasValue() && !this.canWriteExtension(item.getValue())) continue;
            writer.writeStartElement(NS_URI, "metaDataProperty");
            this.writePropertyAttributes(writer, (OgcProperty)item);
            if (item.hasValue()) {
                this.writeExtension(writer, item.getValue());
            }
            writer.writeEndElement();
        }
        if (bean.isSetDescription()) {
            writer.writeStartElement(NS_URI, "description");
            writer.writeCharacters(bean.getDescription());
            writer.writeEndElement();
        }
        if (bean.isSetDescriptionReference()) {
            writer.writeStartElement(NS_URI, "descriptionReference");
            this.writeReferenceType(writer, bean.getDescriptionReference());
            writer.writeEndElement();
        }
        if (bean.isSetIdentifier()) {
            writer.writeStartElement(NS_URI, "identifier");
            this.writeCodeWithAuthorityType(writer, bean.getIdentifier());
            writer.writeEndElement();
        }
        numItems = bean.getNameList().size();
        for (i = 0; i < numItems; ++i) {
            item = bean.getNameList().get(i);
            writer.writeStartElement(NS_URI, "name");
            this.writeCodeType(writer, (Code)item);
            writer.writeEndElement();
        }
    }

    public Reference readReferenceType(XMLStreamReader reader) throws XMLStreamException {
        Reference bean = this.factory.newReference();
        Map attrMap = this.collectAttributes(reader);
        this.readReferenceTypeAttributes(attrMap, bean);
        return bean;
    }

    public void readReferenceTypeAttributes(Map<String, String> attrMap, Reference bean) throws XMLStreamException {
        this.readPropertyAttributes(attrMap, bean);
        String val = attrMap.get("owns");
        if (val != null) {
            bean.setOwns(this.getBooleanFromString(val));
        }
        if ((val = attrMap.get("remoteSchema")) != null) {
            bean.setRemoteSchema(val);
        }
    }

    public void writeReferenceType(XMLStreamWriter writer, Reference bean) throws XMLStreamException {
        this.writeReferenceTypeAttributes(writer, bean);
    }

    public void writeReferenceTypeAttributes(XMLStreamWriter writer, Reference bean) throws XMLStreamException {
        this.writePropertyAttributes(writer, bean);
        if (bean.isSetOwns()) {
            writer.writeAttribute("owns", this.getStringValue(bean.getOwns()));
        }
        if (bean.isSetRemoteSchema()) {
            writer.writeAttribute("remoteSchema", this.getStringValue(bean.getRemoteSchema()));
        }
    }

    public Code readCodeType(XMLStreamReader reader) throws XMLStreamException {
        Code bean = this.factory.newCode();
        Map attrMap = this.collectAttributes(reader);
        this.readCodeTypeAttributes(attrMap, bean);
        String val = reader.getElementText();
        if (val != null) {
            bean.setValue(val);
        }
        return bean;
    }

    public void readCodeTypeAttributes(Map<String, String> attrMap, Code bean) throws XMLStreamException {
        String val = attrMap.get("codeSpace");
        if (val != null) {
            bean.setCodeSpace(val);
        }
    }

    public void writeCodeType(XMLStreamWriter writer, Code bean) throws XMLStreamException {
        this.writeCodeTypeAttributes(writer, bean);
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public void writeCodeTypeAttributes(XMLStreamWriter writer, Code bean) throws XMLStreamException {
        if (bean.isSetCodeSpace()) {
            writer.writeAttribute("codeSpace", this.getStringValue(bean.getCodeSpace()));
        }
    }

    public CodeWithAuthority readCodeWithAuthorityType(XMLStreamReader reader) throws XMLStreamException {
        CodeWithAuthority bean = this.factory.newCodeWithAuthority();
        Map attrMap = this.collectAttributes(reader);
        this.readCodeWithAuthorityTypeAttributes(attrMap, bean);
        String val = reader.getElementText();
        if (val != null) {
            bean.setValue(val);
        }
        return bean;
    }

    public void readCodeWithAuthorityTypeAttributes(Map<String, String> attrMap, CodeWithAuthority bean) throws XMLStreamException {
        this.readCodeTypeAttributes(attrMap, bean);
    }

    public void writeCodeWithAuthorityType(XMLStreamWriter writer, CodeWithAuthority bean) throws XMLStreamException {
        this.writeCodeWithAuthorityTypeAttributes(writer, bean);
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public void writeCodeWithAuthorityTypeAttributes(XMLStreamWriter writer, CodeWithAuthority bean) throws XMLStreamException {
        this.writeCodeTypeAttributes(writer, bean);
    }

    public CodeList readCodeListType(XMLStreamReader reader) throws XMLStreamException {
        CodeList bean = this.factory.newCodeList();
        Map attrMap = this.collectAttributes(reader);
        this.readCodeListTypeAttributes(attrMap, bean);
        String val = reader.getElementText();
        if (val != null) {
            bean.setValue(this.getStringArrayFromString(val));
        }
        return bean;
    }

    public void readCodeListTypeAttributes(Map<String, String> attrMap, CodeList bean) throws XMLStreamException {
        String val = attrMap.get("codeSpace");
        if (val != null) {
            bean.setCodeSpace(val);
        }
    }

    public void writeCodeListType(XMLStreamWriter writer, CodeList bean) throws XMLStreamException {
        this.writeCodeListTypeAttributes(writer, bean);
        writer.writeCharacters(this.getStringValue(bean.getValue()));
    }

    public void writeCodeListTypeAttributes(XMLStreamWriter writer, CodeList bean) throws XMLStreamException {
        if (bean.isSetCodeSpace()) {
            writer.writeAttribute("codeSpace", this.getStringValue(bean.getCodeSpace()));
        }
    }

    public CodeOrNilReasonList readCodeOrNilReasonListType(XMLStreamReader reader) throws XMLStreamException {
        return null;
    }

    public void readCodeOrNilReasonListTypeAttributes(Map<String, String> attrMap, CodeOrNilReasonList bean) throws XMLStreamException {
        String val = attrMap.get("codeSpace");
        if (val != null) {
            bean.setCodeSpace(val);
        }
    }

    public void writeCodeOrNilReasonListType(XMLStreamWriter writer, CodeOrNilReasonList bean) throws XMLStreamException {
    }

    public void writeCodeOrNilReasonListTypeAttributes(XMLStreamWriter writer, CodeOrNilReasonList bean) throws XMLStreamException {
        if (bean.isSetCodeSpace()) {
            writer.writeAttribute("codeSpace", this.getStringValue(bean.getCodeSpace()));
        }
    }

    public AbstractTimeGeometricPrimitive readAbstractTimeGeometricPrimitive(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("TimeInstant")) {
            return this.readTimeInstant(reader);
        }
        if (localName.equals("TimePeriod")) {
            return this.readTimePeriod(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractTimeGeometricPrimitive(XMLStreamWriter writer, AbstractTimeGeometricPrimitive bean) throws XMLStreamException {
        if (bean instanceof TimeInstant) {
            this.writeTimeInstant(writer, (TimeInstant)bean);
        } else if (bean instanceof TimePeriod) {
            this.writeTimePeriod(writer, (TimePeriod)bean);
        }
    }

    public TimeInstant readTimeInstant(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "TimeInstant");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTimeInstantType(reader);
    }

    public void writeTimeInstant(XMLStreamWriter writer, TimeInstant bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "TimeInstant");
        this.writeNamespaces(writer);
        this.writeTimeInstantType(writer, bean);
        writer.writeEndElement();
    }

    public TimePeriod readTimePeriod(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "TimePeriod");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTimePeriodType(reader);
    }

    public void writeTimePeriod(XMLStreamWriter writer, TimePeriod bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "TimePeriod");
        this.writeNamespaces(writer);
        this.writeTimePeriodType(writer, bean);
        writer.writeEndElement();
    }

    public TimePosition readTimePosition(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "TimePosition");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTimePositionType(reader);
    }

    public void writeTimePosition(XMLStreamWriter writer, TimePosition bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "TimePosition");
        this.writeNamespaces(writer);
        this.writeTimePositionType(writer, bean);
        writer.writeEndElement();
    }

    public TimeIntervalLength readTimeInterval(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "TimeInterval");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readTimeIntervalLengthType(reader);
    }

    public void writeTimeInterval(XMLStreamWriter writer, TimeIntervalLength bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "TimeInterval");
        this.writeNamespaces(writer);
        this.writeTimeIntervalLengthType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractFeature readAbstractFeature(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("FeatureCollection")) {
            return this.readFeatureCollection(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractFeature(XMLStreamWriter writer, AbstractFeature bean) throws XMLStreamException {
        if (bean instanceof FeatureCollection) {
            this.writeFeatureCollection(writer, (FeatureCollection)bean);
        } else {
            QName qName = bean.getQName();
            writer.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
            this.writeNamespaces(writer);
            this.writeAbstractFeatureTypeAttributes(writer, bean);
            this.writeAbstractFeatureTypeElements(writer, bean);
            writer.writeEndElement();
        }
    }

    public FeatureCollection readFeatureCollection(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "FeatureCollection");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readFeatureCollectionType(reader);
    }

    public void writeFeatureCollection(XMLStreamWriter writer, FeatureCollection bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "FeatureCollection");
        this.writeNamespaces(writer);
        this.writeFeatureCollectionType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractGeometry readAbstractGeometry(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("Point")) {
            return this.readPoint(reader);
        }
        if (localName.equals("LineString")) {
            return this.readLineString(reader);
        }
        if (localName.equals("Polygon")) {
            return this.readPolygon(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractGeometry(XMLStreamWriter writer, AbstractGeometry bean) throws XMLStreamException {
        if (bean instanceof Point) {
            this.writePoint(writer, (Point)bean);
        } else if (bean instanceof LineString) {
            this.writeLineString(writer, (LineString)bean);
        } else if (bean instanceof Polygon) {
            this.writePolygon(writer, (Polygon)bean);
        } else {
            throw new XMLStreamException("Unsupported Type: " + bean.getClass().getCanonicalName());
        }
    }

    public Envelope readEnvelope(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Envelope");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readEnvelopeType(reader);
    }

    public void writeEnvelope(XMLStreamWriter writer, Envelope bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Envelope");
        this.writeNamespaces(writer);
        this.writeEnvelopeType(writer, bean);
        writer.writeEndElement();
    }

    public Point readPoint(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Point");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readPointType(reader);
    }

    public void writePoint(XMLStreamWriter writer, Point bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Point");
        this.writeNamespaces(writer);
        this.writePointType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractCurve readAbstractCurve(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("LineString")) {
            return this.readLineString(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractCurve(XMLStreamWriter writer, AbstractCurve bean) throws XMLStreamException {
        if (!(bean instanceof LineString)) {
            throw new XMLStreamException("Unsupported Type: " + bean.getClass().getCanonicalName());
        }
        this.writeLineString(writer, (LineString)bean);
    }

    public LineString readLineString(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "LineString");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readLineStringType(reader);
    }

    public void writeLineString(XMLStreamWriter writer, LineString bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "LineString");
        this.writeNamespaces(writer);
        this.writeLineStringType(writer, bean);
        writer.writeEndElement();
    }

    public AbstractSurface readAbstractSurface(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getName().getLocalPart();
        if (localName.equals("Polygon")) {
            return this.readPolygon(reader);
        }
        throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
    }

    public void writeAbstractSurface(XMLStreamWriter writer, AbstractSurface bean) throws XMLStreamException {
        if (!(bean instanceof Polygon)) {
            throw new XMLStreamException("Unsupported Type: " + bean.getClass().getCanonicalName());
        }
        this.writePolygon(writer, (Polygon)bean);
    }

    public Polygon readPolygon(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "Polygon");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readPolygonType(reader);
    }

    public void writePolygon(XMLStreamWriter writer, Polygon bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "Polygon");
        this.writeNamespaces(writer);
        this.writePolygonType(writer, bean);
        writer.writeEndElement();
    }

    public LinearRing readLinearRing(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "LinearRing");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readLinearRingType(reader);
    }

    public void writeLinearRing(XMLStreamWriter writer, LinearRing bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "LinearRing");
        this.writeNamespaces(writer);
        this.writeLinearRingType(writer, bean);
        writer.writeEndElement();
    }

    public String readLocationString(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "LocationString");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return reader.getElementText();
    }

    public void writeLocationString(XMLStreamWriter writer, String bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "LocationString");
        this.writeNamespaces(writer);
        writer.writeCharacters(bean);
        writer.writeEndElement();
    }

    public Code readLocationKeyWord(XMLStreamReader reader) throws XMLStreamException {
        boolean found = this.checkElementName(reader, "LocationKeyWord");
        if (!found) {
            throw new XMLStreamException("Invalid Element: " + reader.getName() + this.errorLocationString(reader));
        }
        return this.readCodeType(reader);
    }

    public void writeLocationKeyWord(XMLStreamWriter writer, Code bean) throws XMLStreamException {
        writer.writeStartElement(NS_URI, "LocationKeyWord");
        this.writeNamespaces(writer);
        this.writeCodeType(writer, bean);
        writer.writeEndElement();
    }
}

