/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import java.util.Arrays;
import net.opengis.gml.v32.Envelope;

public class EnvelopeImpl
implements Envelope {
    static final long serialVersionUID = 1L;
    protected double[] lowerCorner;
    protected double[] upperCorner;
    protected String srsName;
    protected Integer srsDimension;
    protected String[] axisLabels;
    protected String[] uomLabels;

    public EnvelopeImpl() {
    }

    public EnvelopeImpl(int numDims) {
        this.lowerCorner = new double[numDims];
        this.upperCorner = new double[numDims];
        this.srsDimension = numDims;
    }

    public EnvelopeImpl(String crs, double minX, double maxX, double minY, double maxY) {
        this.lowerCorner = new double[]{minX, minY};
        this.upperCorner = new double[]{maxX, maxY};
        this.srsDimension = 2;
        this.srsName = crs;
    }

    public EnvelopeImpl(String crs, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.lowerCorner = new double[]{minX, minY, minZ};
        this.upperCorner = new double[]{maxX, maxY, maxZ};
        this.srsDimension = 3;
        this.srsName = crs;
    }

    public EnvelopeImpl(String crs, double[] lowerCorner, double[] upperCorner) {
        this.lowerCorner = lowerCorner;
        this.upperCorner = upperCorner;
        this.srsDimension = lowerCorner.length;
        this.srsName = crs;
    }

    @Override
    public double[] getLowerCorner() {
        return this.lowerCorner;
    }

    @Override
    public boolean isSetLowerCorner() {
        return this.lowerCorner != null;
    }

    @Override
    public void setLowerCorner(double[] lowerCorner) {
        this.lowerCorner = lowerCorner;
    }

    @Override
    public double[] getUpperCorner() {
        return this.upperCorner;
    }

    @Override
    public boolean isSetUpperCorner() {
        return this.upperCorner != null;
    }

    @Override
    public void setUpperCorner(double[] upperCorner) {
        this.upperCorner = upperCorner;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public boolean isSetSrsName() {
        return this.srsName != null;
    }

    @Override
    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    @Override
    public int getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public boolean isSetSrsDimension() {
        return this.srsDimension != null;
    }

    @Override
    public void setSrsDimension(int srsDimension) {
        this.srsDimension = srsDimension;
    }

    @Override
    public void unSetSrsDimension() {
        this.srsDimension = null;
    }

    @Override
    public String[] getAxisLabels() {
        return this.axisLabels;
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.axisLabels != null;
    }

    @Override
    public void setAxisLabels(String[] axisLabels) {
        this.axisLabels = axisLabels;
    }

    @Override
    public String[] getUomLabels() {
        return this.uomLabels;
    }

    @Override
    public boolean isSetUomLabels() {
        return this.uomLabels != null;
    }

    @Override
    public void setUomLabels(String[] uomLabels) {
        this.uomLabels = uomLabels;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Envelope)) {
            return false;
        }
        Envelope env = (Envelope)other;
        if (!Arrays.equals(env.getLowerCorner(), this.getLowerCorner())) {
            return false;
        }
        if (!Arrays.equals(env.getUpperCorner(), this.getUpperCorner())) {
            return false;
        }
        if (env.getSrsName() != null && !env.getSrsName().equals(this.getSrsName())) {
            return false;
        }
        return this.getSrsName() == null || this.getSrsName().equals(env.getSrsName());
    }
}

