/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import com.vividsolutions.jts.geom.GeometryFactory;
import net.opengis.IDateTime;
import net.opengis.gml.v32.Code;
import net.opengis.gml.v32.CodeList;
import net.opengis.gml.v32.CodeOrNilReasonList;
import net.opengis.gml.v32.CodeWithAuthority;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.Factory;
import net.opengis.gml.v32.FeatureCollection;
import net.opengis.gml.v32.LineString;
import net.opengis.gml.v32.LinearRing;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Polygon;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.TimeInstant;
import net.opengis.gml.v32.TimeIntervalLength;
import net.opengis.gml.v32.TimePeriod;
import net.opengis.gml.v32.TimePosition;
import net.opengis.gml.v32.impl.CodeImpl;
import net.opengis.gml.v32.impl.CodeListImpl;
import net.opengis.gml.v32.impl.CodeOrNilReasonListImpl;
import net.opengis.gml.v32.impl.CodeWithAuthorityImpl;
import net.opengis.gml.v32.impl.EnvelopeImpl;
import net.opengis.gml.v32.impl.FeatureCollectionImpl;
import net.opengis.gml.v32.impl.LineStringImpl;
import net.opengis.gml.v32.impl.LineStringJTS;
import net.opengis.gml.v32.impl.LinearRingImpl;
import net.opengis.gml.v32.impl.LinearRingJTS;
import net.opengis.gml.v32.impl.PointImpl;
import net.opengis.gml.v32.impl.PointJTS;
import net.opengis.gml.v32.impl.PolygonImpl;
import net.opengis.gml.v32.impl.PolygonJTS;
import net.opengis.gml.v32.impl.ReferenceImpl;
import net.opengis.gml.v32.impl.TimeInstantImpl;
import net.opengis.gml.v32.impl.TimeIntervalLengthImpl;
import net.opengis.gml.v32.impl.TimePeriodImpl;
import net.opengis.gml.v32.impl.TimePositionImpl;

public class GMLFactory
implements Factory {
    boolean useJTS;
    GeometryFactory jtsFactory;

    public GMLFactory() {
        this(false);
    }

    public GMLFactory(boolean useJTS) {
        this.useJTS = useJTS;
        if (useJTS) {
            this.jtsFactory = new GeometryFactory();
        }
    }

    @Override
    public final FeatureCollection newFeatureCollection() {
        return new FeatureCollectionImpl();
    }

    @Override
    public final TimeInstant newTimeInstant() {
        return new TimeInstantImpl();
    }

    public final TimeInstant newTimeInstant(TimePosition timePosition) {
        TimeInstant instant = this.newTimeInstant();
        instant.setTimePosition(timePosition);
        return instant;
    }

    @Override
    public final TimePeriod newTimePeriod() {
        return new TimePeriodImpl();
    }

    public final TimePeriod newTimePeriod(TimePosition beginPosition, TimePosition endPosition) {
        TimePeriod period = this.newTimePeriod();
        period.setBeginPosition(beginPosition);
        period.setEndPosition(endPosition);
        return period;
    }

    @Override
    public final TimePosition newTimePosition() {
        return new TimePositionImpl();
    }

    public final TimePosition newTimePosition(double julianTime) {
        TimePosition timePos = this.newTimePosition();
        timePos.setDecimalValue(julianTime);
        return timePos;
    }

    public final TimePosition newTimePosition(IDateTime dateTime) {
        TimePosition timePos = this.newTimePosition();
        timePos.setDateTimeValue(dateTime);
        return timePos;
    }

    @Override
    public final TimeIntervalLength newTimeIntervalLength() {
        return new TimeIntervalLengthImpl();
    }

    @Override
    public final Envelope newEnvelope() {
        return new EnvelopeImpl(2);
    }

    @Override
    public final Reference newReference() {
        return new ReferenceImpl();
    }

    @Override
    public final Code newCode() {
        return new CodeImpl();
    }

    @Override
    public final CodeWithAuthority newCodeWithAuthority() {
        return new CodeWithAuthorityImpl();
    }

    @Override
    public final CodeList newCodeList() {
        return new CodeListImpl();
    }

    @Override
    public final CodeOrNilReasonList newCodeOrNilReasonList() {
        return new CodeOrNilReasonListImpl();
    }

    @Override
    public final Point newPoint() {
        Point point = this.useJTS ? new PointJTS(this.jtsFactory, 3) : new PointImpl(3);
        return point;
    }

    @Override
    public final LinearRing newLinearRing() {
        if (this.useJTS) {
            return new LinearRingJTS(this.jtsFactory, 2);
        }
        return new LinearRingImpl();
    }

    @Override
    public final Polygon newPolygon() {
        Polygon poly = this.useJTS ? new PolygonJTS(this.jtsFactory, 2) : new PolygonImpl(2);
        return poly;
    }

    @Override
    public final LineString newLineString() {
        LineString line = this.useJTS ? new LineStringJTS(this.jtsFactory, 3) : new LineStringImpl(3);
        return line;
    }

    public Envelope newEnvelope(String crs, double minX, double minY, double maxX, double maxY) {
        Envelope env = this.newEnvelope();
        env.setSrsName(crs);
        env.setLowerCorner(new double[]{minX, minY});
        env.setUpperCorner(new double[]{maxX, maxY});
        return env;
    }

    public Envelope newEnvelope(String crs, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Envelope env = this.newEnvelope();
        env.setSrsName(crs);
        env.setLowerCorner(new double[]{minX, minY, minZ});
        env.setUpperCorner(new double[]{maxX, maxY, maxZ});
        return env;
    }
}

