/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

public class JTSCoordinatesDoubleArray
implements CoordinateSequence {
    double[] posList;
    int numDims = 2;

    private JTSCoordinatesDoubleArray() {
    }

    public JTSCoordinatesDoubleArray(int numDims) {
        this.numDims = numDims;
    }

    public void setNumDimensions(int numDims) {
        this.numDims = numDims;
    }

    public void setPosList(double[] posList) {
        this.posList = posList;
    }

    public int getDimension() {
        return this.numDims;
    }

    public final Coordinate getCoordinate(int i) {
        Coordinate coord = new Coordinate();
        this.getCoordinate(i, coord);
        return coord;
    }

    public final Coordinate getCoordinateCopy(int i) {
        return this.getCoordinate(i);
    }

    public final void getCoordinate(int i, Coordinate coord) {
        int index = i * this.numDims;
        coord.x = this.posList[index++];
        coord.y = this.posList[index++];
        coord.z = this.numDims > 2 ? this.posList[index++] : Double.NaN;
    }

    public final double getX(int i) {
        int index = i * this.numDims;
        return this.posList[index];
    }

    public final double getY(int i) {
        int index = i * this.numDims + 1;
        return this.posList[index];
    }

    public final double getOrdinate(int i, int ordinateIndex) {
        int index = i * this.numDims + ordinateIndex;
        return this.posList[index];
    }

    public final int size() {
        if (this.posList == null) {
            return 0;
        }
        return this.posList.length / this.numDims;
    }

    public final void setOrdinate(int i, int ordinateIndex, double value) {
        int index = i * this.numDims + ordinateIndex;
        this.posList[index] = value;
    }

    public final Coordinate[] toCoordinateArray() {
        int numCoords = this.size();
        Coordinate[] coordArray = new Coordinate[numCoords];
        for (int i = 0; i < numCoords; ++i) {
            coordArray[i] = this.getCoordinate(i);
        }
        return coordArray;
    }

    public final Envelope expandEnvelope(Envelope env) {
        int index = 0;
        for (int i = 0; i < this.size(); ++i) {
            env.expandToInclude(this.posList[index], this.posList[index + 1]);
            index += this.numDims;
        }
        return env;
    }

    public final JTSCoordinatesDoubleArray clone() {
        JTSCoordinatesDoubleArray newSeq = new JTSCoordinatesDoubleArray();
        newSeq.numDims = this.numDims;
        newSeq.posList = (double[])this.posList.clone();
        return newSeq;
    }
}

