/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import net.opengis.OgcPropertyList;
import net.opengis.gml.v32.Code;
import net.opengis.gml.v32.CodeWithAuthority;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.LineString;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.impl.AbstractGeometryImpl;
import net.opengis.gml.v32.impl.JTSCoordinatesDoubleArray;
import org.vast.ogc.gml.JTSUtils;

public class LineStringJTS
extends com.vividsolutions.jts.geom.LineString
implements LineString {
    static final long serialVersionUID = 1L;
    AbstractGeometryImpl geom = new AbstractGeometryImpl(){};
    protected double[] posList;

    public LineStringJTS(GeometryFactory jtsFactory, int numDims) {
        super((CoordinateSequence)new JTSCoordinatesDoubleArray(numDims), jtsFactory);
        this.geom.srsDimension = numDims;
    }

    @Override
    public final double[] getPosList() {
        return this.posList;
    }

    @Override
    public final void setPosList(double[] posList) {
        this.posList = posList;
        ((JTSCoordinatesDoubleArray)this.getCoordinateSequence()).setPosList(posList);
        this.geometryChanged();
        this.geom.envelope = null;
    }

    @Override
    public final boolean isSetPosList() {
        return this.posList != null;
    }

    @Override
    public final String getSrsName() {
        return this.geom.getSrsName();
    }

    @Override
    public final OgcPropertyList<Object> getMetaDataPropertyList() {
        return this.geom.getMetaDataPropertyList();
    }

    @Override
    public final boolean isSetSrsName() {
        return this.geom.isSetSrsName();
    }

    @Override
    public final void setSrsName(String srsName) {
        this.geom.setSrsName(srsName);
        super.setSRID(JTSUtils.getSRIDFromSrsName(srsName));
    }

    public void setSRID(int srid) {
        super.setSRID(srid);
        this.geom.setSrsName(JTSUtils.getSrsNameFromSRID(srid));
    }

    @Override
    public final int getSrsDimension() {
        return this.geom.getSrsDimension();
    }

    @Override
    public final boolean isSetSrsDimension() {
        return this.geom.isSetSrsDimension();
    }

    @Override
    public final String getDescription() {
        return this.geom.getDescription();
    }

    @Override
    public final void setSrsDimension(int srsDimension) {
        this.geom.setSrsDimension(srsDimension);
        ((JTSCoordinatesDoubleArray)this.getCoordinateSequence()).setNumDimensions(srsDimension);
    }

    @Override
    public final void unSetSrsDimension() {
        this.geom.unSetSrsDimension();
    }

    @Override
    public final String[] getAxisLabels() {
        return this.geom.getAxisLabels();
    }

    @Override
    public final boolean isSetDescription() {
        return this.geom.isSetDescription();
    }

    @Override
    public final boolean isSetAxisLabels() {
        return this.geom.isSetAxisLabels();
    }

    @Override
    public final void setAxisLabels(String[] axisLabels) {
        this.geom.setAxisLabels(axisLabels);
    }

    @Override
    public final void setDescription(String description) {
        this.geom.setDescription(description);
    }

    @Override
    public final String[] getUomLabels() {
        return this.geom.getUomLabels();
    }

    @Override
    public final Reference getDescriptionReference() {
        return this.geom.getDescriptionReference();
    }

    @Override
    public final boolean isSetUomLabels() {
        return this.geom.isSetUomLabels();
    }

    @Override
    public final boolean isSetDescriptionReference() {
        return this.geom.isSetDescriptionReference();
    }

    @Override
    public final void setUomLabels(String[] uomLabels) {
        this.geom.setUomLabels(uomLabels);
    }

    @Override
    public final void setDescriptionReference(Reference descriptionReference) {
        this.geom.setDescriptionReference(descriptionReference);
    }

    @Override
    public final CodeWithAuthority getIdentifier() {
        return this.geom.getIdentifier();
    }

    @Override
    public final String getUniqueIdentifier() {
        return this.geom.getUniqueIdentifier();
    }

    @Override
    public final boolean isSetIdentifier() {
        return this.geom.isSetIdentifier();
    }

    @Override
    public final void setIdentifier(CodeWithAuthority identifier) {
        this.geom.setIdentifier(identifier);
    }

    @Override
    public final void setUniqueIdentifier(String identifier) {
        this.geom.setUniqueIdentifier(identifier);
    }

    @Override
    public final List<Code> getNameList() {
        return this.geom.getNameList();
    }

    @Override
    public final int getNumNames() {
        return this.geom.getNumNames();
    }

    @Override
    public final void addName(Code name) {
        this.geom.addName(name);
    }

    @Override
    public final void setName(String name) {
        this.geom.setName(name);
    }

    @Override
    public final String getName() {
        return this.geom.getName();
    }

    @Override
    public final String getId() {
        return this.geom.getId();
    }

    @Override
    public final void setId(String id) {
        this.geom.setId(id);
    }

    @Override
    public Envelope getGeomEnvelope() {
        if (this.geom.envelope == null) {
            this.geom.envelope = AbstractGeometryImpl.addCoordinatesToEnvelope(this.geom.envelope, this.posList, this.geom.srsDimension);
        }
        return this.geom.envelope;
    }
}

