/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import net.opengis.OgcPropertyList;
import net.opengis.gml.v32.Code;
import net.opengis.gml.v32.CodeWithAuthority;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.impl.AbstractGeometryImpl;
import net.opengis.gml.v32.impl.JTSCoordinatesDoubleArray;
import org.vast.ogc.gml.JTSUtils;

public class PointJTS
extends com.vividsolutions.jts.geom.Point
implements Point {
    static final long serialVersionUID = 1L;
    AbstractGeometryImpl geom = new AbstractGeometryImpl(){};
    protected double[] pos;

    public PointJTS(GeometryFactory jtsFactory, int numDims) {
        super((CoordinateSequence)new JTSCoordinatesDoubleArray(numDims), jtsFactory);
        this.geom.srsDimension = numDims;
    }

    @Override
    public double[] getPos() {
        return this.pos;
    }

    @Override
    public boolean isSetPos() {
        return this.pos != null;
    }

    @Override
    public void setPos(double[] pos) {
        this.pos = pos;
        ((JTSCoordinatesDoubleArray)this.getCoordinateSequence()).numDims = pos.length;
        ((JTSCoordinatesDoubleArray)this.getCoordinateSequence()).setPosList(pos);
        this.geometryChanged();
        this.geom.envelope = null;
    }

    @Override
    public String getSrsName() {
        return this.geom.getSrsName();
    }

    @Override
    public OgcPropertyList<Object> getMetaDataPropertyList() {
        return this.geom.getMetaDataPropertyList();
    }

    @Override
    public boolean isSetSrsName() {
        return this.geom.isSetSrsName();
    }

    @Override
    public final void setSrsName(String srsName) {
        this.geom.setSrsName(srsName);
        super.setSRID(JTSUtils.getSRIDFromSrsName(srsName));
    }

    public void setSRID(int srid) {
        super.setSRID(srid);
        this.geom.setSrsName(JTSUtils.getSrsNameFromSRID(srid));
    }

    @Override
    public int getSrsDimension() {
        return this.geom.getSrsDimension();
    }

    @Override
    public boolean isSetSrsDimension() {
        return this.geom.isSetSrsDimension();
    }

    @Override
    public String getDescription() {
        return this.geom.getDescription();
    }

    @Override
    public void setSrsDimension(int srsDimension) {
        this.geom.setSrsDimension(srsDimension);
        ((JTSCoordinatesDoubleArray)this.getCoordinateSequence()).setNumDimensions(srsDimension);
    }

    @Override
    public void unSetSrsDimension() {
        this.geom.unSetSrsDimension();
    }

    @Override
    public String[] getAxisLabels() {
        return this.geom.getAxisLabels();
    }

    @Override
    public boolean isSetDescription() {
        return this.geom.isSetDescription();
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.geom.isSetAxisLabels();
    }

    @Override
    public void setAxisLabels(String[] axisLabels) {
        this.geom.setAxisLabels(axisLabels);
    }

    @Override
    public void setDescription(String description) {
        this.geom.setDescription(description);
    }

    @Override
    public String[] getUomLabels() {
        return this.geom.getUomLabels();
    }

    @Override
    public Reference getDescriptionReference() {
        return this.geom.getDescriptionReference();
    }

    @Override
    public boolean isSetUomLabels() {
        return this.geom.isSetUomLabels();
    }

    @Override
    public boolean isSetDescriptionReference() {
        return this.geom.isSetDescriptionReference();
    }

    @Override
    public void setUomLabels(String[] uomLabels) {
        this.geom.setUomLabels(uomLabels);
    }

    @Override
    public void setDescriptionReference(Reference descriptionReference) {
        this.geom.setDescriptionReference(descriptionReference);
    }

    @Override
    public CodeWithAuthority getIdentifier() {
        return this.geom.getIdentifier();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.geom.getUniqueIdentifier();
    }

    @Override
    public boolean isSetIdentifier() {
        return this.geom.isSetIdentifier();
    }

    @Override
    public void setIdentifier(CodeWithAuthority identifier) {
        this.geom.setIdentifier(identifier);
    }

    @Override
    public void setUniqueIdentifier(String identifier) {
        this.geom.setUniqueIdentifier(identifier);
    }

    @Override
    public List<Code> getNameList() {
        return this.geom.getNameList();
    }

    @Override
    public int getNumNames() {
        return this.geom.getNumNames();
    }

    @Override
    public void addName(Code name) {
        this.geom.addName(name);
    }

    @Override
    public void setName(String name) {
        this.geom.setName(name);
    }

    @Override
    public String getName() {
        return this.geom.getName();
    }

    @Override
    public String getId() {
        return this.geom.getId();
    }

    @Override
    public void setId(String id) {
        this.geom.setId(id);
    }

    @Override
    public Envelope getGeomEnvelope() {
        if (this.geom.envelope == null) {
            this.geom.envelope = AbstractGeometryImpl.addCoordinatesToEnvelope(this.geom.envelope, this.pos, this.geom.srsDimension);
        }
        return this.geom.envelope;
    }
}

