/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import java.util.ArrayList;
import java.util.List;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.LinearRing;
import net.opengis.gml.v32.Polygon;
import net.opengis.gml.v32.impl.AbstractGeometryImpl;

public class PolygonImpl
extends AbstractGeometryImpl
implements Polygon {
    static final long serialVersionUID = 1L;
    protected LinearRing exterior;
    protected List<LinearRing> interiorList = new ArrayList<LinearRing>();

    private PolygonImpl() {
    }

    public PolygonImpl(int numDims) {
        this.srsDimension = numDims;
    }

    @Override
    public LinearRing getExterior() {
        return this.exterior;
    }

    @Override
    public boolean isSetExterior() {
        return this.exterior != null;
    }

    @Override
    public void setExterior(LinearRing exterior) {
        this.exterior = exterior;
        this.envelope = null;
    }

    @Override
    public List<LinearRing> getInteriorList() {
        return this.interiorList;
    }

    @Override
    public int getNumInteriors() {
        if (this.interiorList == null) {
            return 0;
        }
        return this.interiorList.size();
    }

    @Override
    public void addInterior(LinearRing interior) {
        this.interiorList.add(interior);
        this.envelope = null;
    }

    @Override
    public Envelope getGeomEnvelope() {
        if (this.envelope == null) {
            this.envelope = PolygonImpl.addCoordinatesToEnvelope(this.envelope, this.exterior.getPosList(), this.srsDimension);
            for (LinearRing interior : this.interiorList) {
                PolygonImpl.addCoordinatesToEnvelope(this.envelope, interior.getPosList(), this.srsDimension);
            }
        }
        return this.envelope;
    }
}

