/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.v32.impl;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.List;
import net.opengis.OgcPropertyList;
import net.opengis.gml.v32.Code;
import net.opengis.gml.v32.CodeWithAuthority;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.LinearRing;
import net.opengis.gml.v32.Polygon;
import net.opengis.gml.v32.Reference;
import net.opengis.gml.v32.impl.AbstractGeometryImpl;
import net.opengis.gml.v32.impl.JTSCoordinatesDoubleArray;
import net.opengis.gml.v32.impl.LinearRingJTS;
import org.vast.ogc.gml.JTSUtils;

public class PolygonJTS
extends com.vividsolutions.jts.geom.Polygon
implements Polygon {
    static final long serialVersionUID = 1L;
    AbstractGeometryImpl geom = new AbstractGeometryImpl(){};
    protected LinearRing exterior;
    protected List<LinearRing> interiorList = new ArrayList<LinearRing>(){

        @Override
        public boolean add(LinearRing interior) {
            LinearRingJTS interiorJTS = (LinearRingJTS)interior;
            ((JTSCoordinatesDoubleArray)interiorJTS.getCoordinateSequence()).setNumDimensions(PolygonJTS.this.geom.srsDimension);
            return super.add(interior);
        }
    };

    public PolygonJTS(GeometryFactory jtsFactory, int numDims) {
        super(null, null, jtsFactory);
        this.geom.srsDimension = numDims;
    }

    @Override
    public final LinearRing getExterior() {
        return this.exterior;
    }

    @Override
    public final boolean isSetExterior() {
        return this.exterior != null;
    }

    @Override
    public final void setExterior(LinearRing exterior) {
        this.exterior = exterior;
        this.shell = (LinearRingJTS)exterior;
        this.geometryChanged();
        this.geom.envelope = null;
        LinearRingJTS exteriorJTS = (LinearRingJTS)exterior;
        ((JTSCoordinatesDoubleArray)exteriorJTS.getCoordinateSequence()).setNumDimensions(this.geom.srsDimension);
    }

    @Override
    public final List<LinearRing> getInteriorList() {
        return this.interiorList;
    }

    @Override
    public final int getNumInteriors() {
        if (this.interiorList == null) {
            return 0;
        }
        return this.interiorList.size();
    }

    @Override
    public final void addInterior(LinearRing interior) {
        this.interiorList.add(interior);
        this.holes = this.interiorList.toArray(this.holes);
        this.geometryChanged();
    }

    @Override
    public final String getSrsName() {
        return this.geom.getSrsName();
    }

    @Override
    public final OgcPropertyList<Object> getMetaDataPropertyList() {
        return this.geom.getMetaDataPropertyList();
    }

    @Override
    public final boolean isSetSrsName() {
        return this.geom.isSetSrsName();
    }

    @Override
    public final void setSrsName(String srsName) {
        this.geom.setSrsName(srsName);
        super.setSRID(JTSUtils.getSRIDFromSrsName(srsName));
    }

    public void setSRID(int srid) {
        super.setSRID(srid);
        this.geom.setSrsName(JTSUtils.getSrsNameFromSRID(srid));
    }

    @Override
    public final int getSrsDimension() {
        return this.geom.getSrsDimension();
    }

    @Override
    public final boolean isSetSrsDimension() {
        return this.geom.isSetSrsDimension();
    }

    @Override
    public final String getDescription() {
        return this.geom.getDescription();
    }

    @Override
    public final void setSrsDimension(int srsDimension) {
        this.geom.setSrsDimension(srsDimension);
        if (this.exterior != null) {
            LinearRingJTS exteriorJTS = (LinearRingJTS)this.exterior;
            ((JTSCoordinatesDoubleArray)exteriorJTS.getCoordinateSequence()).setNumDimensions(srsDimension);
        }
        for (LinearRing interior : this.interiorList) {
            LinearRingJTS interiorJTS = (LinearRingJTS)interior;
            ((JTSCoordinatesDoubleArray)interiorJTS.getCoordinateSequence()).setNumDimensions(srsDimension);
        }
    }

    @Override
    public final void unSetSrsDimension() {
        this.geom.unSetSrsDimension();
    }

    @Override
    public final String[] getAxisLabels() {
        return this.geom.getAxisLabels();
    }

    @Override
    public final boolean isSetDescription() {
        return this.geom.isSetDescription();
    }

    @Override
    public final boolean isSetAxisLabels() {
        return this.geom.isSetAxisLabels();
    }

    @Override
    public final void setAxisLabels(String[] axisLabels) {
        this.geom.setAxisLabels(axisLabels);
    }

    @Override
    public final void setDescription(String description) {
        this.geom.setDescription(description);
    }

    @Override
    public final String[] getUomLabels() {
        return this.geom.getUomLabels();
    }

    @Override
    public final Reference getDescriptionReference() {
        return this.geom.getDescriptionReference();
    }

    @Override
    public final boolean isSetUomLabels() {
        return this.geom.isSetUomLabels();
    }

    @Override
    public final boolean isSetDescriptionReference() {
        return this.geom.isSetDescriptionReference();
    }

    @Override
    public final void setUomLabels(String[] uomLabels) {
        this.geom.setUomLabels(uomLabels);
    }

    @Override
    public final void setDescriptionReference(Reference descriptionReference) {
        this.geom.setDescriptionReference(descriptionReference);
    }

    @Override
    public final CodeWithAuthority getIdentifier() {
        return this.geom.getIdentifier();
    }

    @Override
    public final String getUniqueIdentifier() {
        return this.geom.getUniqueIdentifier();
    }

    @Override
    public final boolean isSetIdentifier() {
        return this.geom.isSetIdentifier();
    }

    @Override
    public final void setIdentifier(CodeWithAuthority identifier) {
        this.geom.setIdentifier(identifier);
    }

    @Override
    public final void setUniqueIdentifier(String identifier) {
        this.geom.setUniqueIdentifier(identifier);
    }

    @Override
    public final List<Code> getNameList() {
        return this.geom.getNameList();
    }

    @Override
    public final int getNumNames() {
        return this.geom.getNumNames();
    }

    @Override
    public final void addName(Code name) {
        this.geom.addName(name);
    }

    @Override
    public final void setName(String name) {
        this.geom.setName(name);
    }

    @Override
    public final String getName() {
        return this.geom.getName();
    }

    @Override
    public final String getId() {
        return this.geom.getId();
    }

    @Override
    public final void setId(String id) {
        this.geom.setId(id);
    }

    @Override
    public Envelope getGeomEnvelope() {
        if (this.geom.envelope == null) {
            int nDims = this.geom.srsDimension;
            this.geom.envelope = AbstractGeometryImpl.addCoordinatesToEnvelope(this.geom.envelope, this.exterior.getPosList(), nDims);
            for (LinearRing interior : this.interiorList) {
                AbstractGeometryImpl.addCoordinatesToEnvelope(this.geom.envelope, interior.getPosList(), nDims);
            }
        }
        return this.geom.envelope;
    }
}

