/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.gml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.AbstractGML;
import net.opengis.gml.v32.AbstractGeometry;
import net.opengis.gml.v32.AbstractTimePrimitive;
import net.opengis.gml.v32.Factory;
import net.opengis.gml.v32.bind.XMLStreamBindings;
import net.opengis.gml.v32.impl.GMLFactory;
import org.vast.ogc.gml.GenericFeature;
import org.vast.ogc.gml.GenericFeatureImpl;
import org.vast.ogc.gml.IFeatureStaxBindings;
import org.vast.ogc.xlink.IXlinkReference;

public class GMLStaxBindings
extends XMLStreamBindings {
    public static final String NS_PREFIX_GML = "gml";
    public static final String NS_PREFIX_XLINK = "xlink";
    protected int geomIdCounter = 1;
    protected int timeIdCounter = 1;
    protected int featureIdCounter = 1;
    protected StringBuilder sb = new StringBuilder();
    protected Map<QName, IFeatureStaxBindings> featureTypesBindings = new HashMap<QName, IFeatureStaxBindings>();

    public GMLStaxBindings() {
        this(false);
    }

    public GMLStaxBindings(boolean useJTS) {
        this(new GMLFactory(useJTS));
    }

    public GMLStaxBindings(Factory fac) {
        super(fac);
        this.nsContext.registerNamespace(NS_PREFIX_GML, "http://www.opengis.net/gml/3.2");
        this.nsContext.registerNamespace(NS_PREFIX_XLINK, "http://www.w3.org/1999/xlink");
    }

    public GMLFactory getFactory() {
        return (GMLFactory)this.factory;
    }

    public void registerFeatureBindings(IFeatureStaxBindings featureBindings) {
        for (QName fType : featureBindings.getSupportedFeatureTypes()) {
            this.featureTypesBindings.put(fType, featureBindings);
        }
    }

    public GenericFeature readGenericFeature(XMLStreamReader reader) throws XMLStreamException {
        QName featureType = reader.getName();
        GenericFeatureImpl newFeature = new GenericFeatureImpl(featureType);
        Map attrMap = this.collectAttributes(reader);
        this.readAbstractFeatureTypeAttributes(attrMap, newFeature);
        reader.nextTag();
        this.readAbstractFeatureTypeElements(reader, newFeature);
        while (reader.getEventType() != 2) {
            reader.nextTag();
            QName propName = reader.getName();
            if (reader.hasText()) {
                String text = reader.getElementText();
                Object value = null;
                if (text != null) {
                    try {
                        value = Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        try {
                            value = Double.parseDouble(text);
                        }
                        catch (NumberFormatException e1) {
                            try {
                                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false")) {
                                    value = Boolean.parseBoolean(text);
                                } else {
                                    this.getDateTimeFromString(text);
                                }
                            }
                            catch (Exception e2) {
                                value = text;
                            }
                        }
                    }
                    newFeature.setProperty(propName, value);
                }
            } else {
                this.skipElementAndAllChildren(reader);
            }
            reader.nextTag();
        }
        return newFeature;
    }

    public void writeGenericFeature(XMLStreamWriter writer, GenericFeature bean) throws XMLStreamException {
        QName featureType = bean.getQName();
        String newPrefix = this.ensurePrefix(writer, featureType);
        writer.writeStartElement(featureType.getNamespaceURI(), featureType.getLocalPart());
        if (newPrefix != null) {
            writer.writeNamespace(newPrefix, featureType.getNamespaceURI());
        }
        for (Map.Entry<QName, Object> prop : bean.getProperties().entrySet()) {
            this.ensureNamespaceDecl(writer, prop.getKey());
        }
        this.writeAbstractFeatureTypeAttributes(writer, bean);
        this.writeAbstractFeatureTypeElements(writer, bean);
        for (Map.Entry<QName, Object> prop : bean.getProperties().entrySet()) {
            QName propName = prop.getKey();
            writer.writeStartElement(propName.getNamespaceURI(), propName.getLocalPart());
            Object val = prop.getValue();
            if (val instanceof IXlinkReference) {
                String href = ((IXlinkReference)val).getHref();
                writer.writeAttribute("http://www.w3.org/1999/xlink", "href", href);
            } else if (val instanceof AbstractGeometry) {
                this.writeAbstractGeometry(writer, (AbstractGeometry)val);
            } else {
                writer.writeCharacters(val.toString());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public AbstractFeature readAbstractFeature(XMLStreamReader reader) throws XMLStreamException {
        QName featureType = reader.getName();
        IFeatureStaxBindings customBindings = this.featureTypesBindings.get(featureType);
        if (customBindings != null) {
            return customBindings.readFeature(reader, featureType);
        }
        if (featureType.getNamespaceURI().equals("http://www.opengis.net/gml/3.2")) {
            return super.readAbstractFeature(reader);
        }
        return this.readGenericFeature(reader);
    }

    @Override
    public void writeAbstractFeature(XMLStreamWriter writer, AbstractFeature bean) throws XMLStreamException {
        QName featureType = bean.getQName();
        IFeatureStaxBindings customBindings = this.featureTypesBindings.get(featureType);
        if (customBindings != null) {
            customBindings.writeFeature(writer, bean);
        } else if (bean instanceof GenericFeature) {
            this.writeGenericFeature(writer, (GenericFeature)bean);
        } else {
            super.writeAbstractFeature(writer, bean);
        }
    }

    @Override
    public void writeAbstractGMLTypeAttributes(XMLStreamWriter writer, AbstractGML bean) throws XMLStreamException {
        String gmlID = bean.getId();
        if (gmlID == null || gmlID.length() == 0) {
            this.sb.setLength(0);
            if (bean instanceof AbstractGeometry) {
                this.sb.append('G');
                this.sb.append(this.geomIdCounter++);
            } else if (bean instanceof AbstractTimePrimitive) {
                this.sb.append('T');
                this.sb.append(this.timeIdCounter++);
            } else if (bean instanceof AbstractFeature) {
                this.sb.append('F');
                this.sb.append(this.featureIdCounter++);
            }
            gmlID = this.sb.toString();
        }
        writer.writeAttribute("http://www.opengis.net/gml/3.2", "id", gmlID);
    }

    public final void resetGeomIdCounter(int geomIdCounter) {
        this.geomIdCounter = geomIdCounter;
    }

    public final void resetTimeIdCounter(int timeIdCounter) {
        this.timeIdCounter = timeIdCounter;
    }
}

