/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.gml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.AbstractGeometry;
import net.opengis.gml.v32.AbstractTimeGeometricPrimitive;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.TimeIndeterminateValue;
import net.opengis.gml.v32.TimeInstant;
import net.opengis.gml.v32.TimeIntervalLength;
import net.opengis.gml.v32.TimePeriod;
import net.opengis.gml.v32.TimePosition;
import net.opengis.gml.v32.impl.GMLFactory;
import org.vast.ogc.gml.GMLStaxBindings;
import org.vast.ogc.gml.GenericFeature;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.IndentingXMLStreamWriter;
import org.vast.xml.XMLBindingsUtils;
import org.vast.xml.XMLImplFinder;
import org.vast.xml.XMLReaderException;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;

public class GMLUtils
extends XMLBindingsUtils {
    public static final String GML = "GML";
    public static final String V3_2 = "3.2";
    GMLFactory gmlFactory;

    public GMLUtils(String version) {
        this.staxBindings = new GMLStaxBindings(true);
        this.gmlFactory = ((GMLStaxBindings)this.staxBindings).getFactory();
    }

    public GenericFeature readFeature(InputStream inputStream) throws XMLReaderException {
        return (GenericFeature)this.readFromStream(inputStream, ObjectType.Feature);
    }

    public GenericFeature readFeature(DOMHelper dom, Element featureElt) throws XMLReaderException {
        return (GenericFeature)this.readFromDom(dom, featureElt, ObjectType.Feature);
    }

    public AbstractGeometry readGeometry(DOMHelper dom, Element geomElt) throws XMLReaderException {
        return (AbstractGeometry)this.readFromDom(dom, geomElt, ObjectType.Geometry);
    }

    public AbstractTimeGeometricPrimitive readTimePrimitive(DOMHelper dom, Element timeElt) throws XMLReaderException {
        return (AbstractTimeGeometricPrimitive)this.readFromDom(dom, timeElt, ObjectType.TimePrimitive);
    }

    public TimeExtent readTimePrimitiveAsTimeExtent(DOMHelper dom, Element timeElt) throws XMLReaderException {
        AbstractTimeGeometricPrimitive timePrimitive = this.readTimePrimitive(dom, timeElt);
        return this.timePrimitiveToTimeExtent(timePrimitive);
    }

    public Envelope readEnvelope(DOMHelper dom, Element envElt) throws XMLReaderException {
        return (Envelope)this.readFromDom(dom, envElt, ObjectType.Envelope);
    }

    public Bbox readEnvelopeAsBbox(DOMHelper dom, Element envElt) throws XMLReaderException {
        Envelope env = this.readEnvelope(dom, envElt);
        return GMLUtils.envelopeToBbox(env);
    }

    public Element writeFeature(DOMHelper dom, AbstractFeature feature) throws XMLWriterException {
        dom.addNSDeclaration("gml", "http://www.opengis.net/gml/3.2");
        return this.writeToDom(dom, feature, ObjectType.Feature);
    }

    public void writeFeature(OutputStream os, AbstractFeature feature, boolean indent) throws XMLWriterException, IOException {
        try {
            XMLOutputFactory factory = XMLImplFinder.getStaxOutputFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(os, this.encoding);
            if (indent) {
                writer = new IndentingXMLStreamWriter(writer);
            }
            this.staxBindings.setNamespacePrefixes(writer);
            this.staxBindings.declareNamespacesOnRootElement();
            this.writeToXmlStream(writer, feature, ObjectType.Feature);
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new XMLWriterException("Error while writing " + (Object)((Object)ObjectType.Feature) + " to output stream", (Exception)e);
        }
    }

    public Element writeGeometry(DOMHelper dom, AbstractGeometry geom) throws XMLWriterException {
        dom.addNSDeclaration("gml", "http://www.opengis.net/gml/3.2");
        return this.writeToDom(dom, geom, ObjectType.Geometry);
    }

    public Element writeTimePrimitive(DOMHelper dom, AbstractTimeGeometricPrimitive timePrimitive) throws XMLWriterException {
        dom.addNSDeclaration("gml", "http://www.opengis.net/gml/3.2");
        return this.writeToDom(dom, timePrimitive, ObjectType.TimePrimitive);
    }

    public Element writeTimeExtentAsTimePeriod(DOMHelper dom, TimeExtent timeExtent) throws XMLWriterException {
        AbstractTimeGeometricPrimitive timePrimitive = this.timeExtentToTimePrimitive(timeExtent, true);
        return this.writeTimePrimitive(dom, timePrimitive);
    }

    public Element writeTimeExtentAsTimePrimitive(DOMHelper dom, TimeExtent timeExtent) throws XMLWriterException {
        AbstractTimeGeometricPrimitive timePrimitive = this.timeExtentToTimePrimitive(timeExtent, false);
        return this.writeTimePrimitive(dom, timePrimitive);
    }

    public Element writeEnvelope(DOMHelper dom, Envelope env) throws XMLWriterException {
        dom.addNSDeclaration("gml", "http://www.opengis.net/gml/3.2");
        return this.writeToDom(dom, env, ObjectType.Envelope);
    }

    public Element writeBboxAsEnvelope(DOMHelper dom, Bbox bbox) throws XMLWriterException {
        Envelope env = GMLUtils.bboxToEnvelope(bbox, this.gmlFactory);
        return this.writeEnvelope(dom, env);
    }

    protected Object readFromXmlStream(XMLStreamReader reader, Enum<?> eltType) throws XMLStreamException {
        reader.nextTag();
        GMLStaxBindings gmlBindings = (GMLStaxBindings)this.staxBindings;
        switch ((ObjectType)eltType) {
            case Envelope: {
                return gmlBindings.readEnvelope(reader);
            }
            case Geometry: {
                return gmlBindings.readAbstractGeometry(reader);
            }
            case TimePrimitive: {
                return gmlBindings.readAbstractTimeGeometricPrimitive(reader);
            }
            case Feature: {
                return gmlBindings.readGenericFeature(reader);
            }
        }
        return null;
    }

    protected void writeToXmlStream(XMLStreamWriter writer, Object gmlObj, Enum<?> eltType) throws XMLStreamException {
        GMLStaxBindings gmlBindings = (GMLStaxBindings)this.staxBindings;
        switch ((ObjectType)eltType) {
            case Envelope: {
                gmlBindings.writeEnvelope(writer, (Envelope)gmlObj);
                return;
            }
            case Geometry: {
                gmlBindings.writeAbstractGeometry(writer, (AbstractGeometry)gmlObj);
                return;
            }
            case TimePrimitive: {
                gmlBindings.writeAbstractTimeGeometricPrimitive(writer, (AbstractTimeGeometricPrimitive)gmlObj);
                return;
            }
            case Feature: {
                gmlBindings.writeAbstractFeature(writer, (AbstractFeature)gmlObj);
                return;
            }
        }
    }

    public TimeExtent timePrimitiveToTimeExtent(AbstractTimeGeometricPrimitive timePrimitive) {
        TimeExtent timeExtent = new TimeExtent();
        boolean beginUnknown = false;
        boolean endUnknown = false;
        if (timePrimitive instanceof TimeInstant) {
            TimePosition timePos = ((TimeInstant)timePrimitive).getTimePosition();
            if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.NOW) {
                timeExtent.setBaseAtNow(true);
            } else if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.UNKNOWN) {
                timeExtent.nullify();
            } else {
                timeExtent.setBaseTime(timePos.getDecimalValue());
            }
        } else if (timePrimitive instanceof TimePeriod) {
            TimePeriod timePeriod = (TimePeriod)timePrimitive;
            TimePosition timePos = timePeriod.getBeginPosition();
            if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.NOW) {
                timeExtent.setBeginNow(true);
            } else if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.UNKNOWN) {
                beginUnknown = true;
            } else {
                timeExtent.setStartTime(timePos.getDecimalValue());
            }
            timePos = timePeriod.getEndPosition();
            if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.NOW) {
                timeExtent.setEndNow(true);
            } else if (timePos.getIndeterminatePosition() == TimeIndeterminateValue.UNKNOWN) {
                endUnknown = true;
            } else {
                timeExtent.setStopTime(timePos.getDecimalValue());
            }
            if (timePeriod.isSetDuration()) {
                double duration = timePeriod.getDuration();
                if (beginUnknown) {
                    timeExtent.setLagTimeDelta(duration);
                }
                if (endUnknown) {
                    timeExtent.setLeadTimeDelta(duration);
                }
            } else if (beginUnknown && endUnknown) {
                timeExtent.nullify();
            }
            if (timePeriod.isSetTimeInterval()) {
                TimeIntervalLength interval = timePeriod.getTimeInterval();
                timeExtent.setTimeStep(interval.getValue());
            }
        }
        return timeExtent;
    }

    public AbstractTimeGeometricPrimitive timeExtentToTimePrimitive(TimeExtent timeExtent, boolean forcePeriod) {
        double begin = timeExtent.getStartTime();
        double end = timeExtent.getStopTime();
        if (timeExtent.isTimeInstant() && !forcePeriod) {
            TimePosition timePosition = this.gmlFactory.newTimePosition();
            if (timeExtent.isNull()) {
                timePosition.setIndeterminatePosition(TimeIndeterminateValue.UNKNOWN);
            } else if (timeExtent.isBeginNow() || timeExtent.isEndNow() || timeExtent.isBaseAtNow()) {
                timePosition.setIndeterminatePosition(TimeIndeterminateValue.NOW);
            } else {
                timePosition.setDecimalValue(begin);
            }
            return this.gmlFactory.newTimeInstant(timePosition);
        }
        TimePosition beginPosition = this.gmlFactory.newTimePosition();
        TimePosition endPosition = this.gmlFactory.newTimePosition();
        TimePeriod timePeriod = this.gmlFactory.newTimePeriod(beginPosition, endPosition);
        if (timeExtent.isNull()) {
            beginPosition.setIndeterminatePosition(TimeIndeterminateValue.UNKNOWN);
            endPosition.setIndeterminatePosition(TimeIndeterminateValue.UNKNOWN);
        } else if (timeExtent.isBaseAtNow()) {
            if (timeExtent.getLeadTimeDelta() > 0.0 && timeExtent.getLagTimeDelta() > 0.0) {
                double now = System.currentTimeMillis() / 1000L;
                beginPosition.setDecimalValue(now - timeExtent.getLagTimeDelta());
                endPosition.setDecimalValue(now + timeExtent.getLeadTimeDelta());
            } else if (timeExtent.getLagTimeDelta() == 0.0) {
                beginPosition.setIndeterminatePosition(TimeIndeterminateValue.NOW);
                endPosition.setIndeterminatePosition(TimeIndeterminateValue.AFTER);
                timePeriod.setDuration(timeExtent.getLeadTimeDelta());
            } else if (timeExtent.getLeadTimeDelta() == 0.0) {
                beginPosition.setIndeterminatePosition(TimeIndeterminateValue.BEFORE);
                endPosition.setIndeterminatePosition(TimeIndeterminateValue.NOW);
                timePeriod.setDuration(timeExtent.getLagTimeDelta());
            }
        } else {
            if (timeExtent.isBeginNow()) {
                beginPosition.setIndeterminatePosition(TimeIndeterminateValue.NOW);
            } else {
                beginPosition.setDecimalValue(begin);
            }
            if (timeExtent.isEndNow()) {
                endPosition.setIndeterminatePosition(TimeIndeterminateValue.NOW);
            } else {
                endPosition.setDecimalValue(end);
            }
        }
        if (timeExtent.getTimeStep() != 0.0) {
            timePeriod.setTimeInterval(timeExtent.getTimeStep());
        }
        return timePeriod;
    }

    public Envelope bboxToEnvelope(Bbox bbox) {
        return this.gmlFactory.newEnvelope(bbox.getCrs(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
    }

    public static Envelope bboxToEnvelope(Bbox bbox, GMLFactory gmlFac) {
        return gmlFac.newEnvelope(bbox.getCrs(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
    }

    public static Bbox envelopeToBbox(Envelope env) {
        Bbox bbox = new Bbox();
        bbox.setCrs(env.getSrsName());
        double[] lowerCorner = env.getLowerCorner();
        bbox.setMinX(lowerCorner[0]);
        bbox.setMinY(lowerCorner[1]);
        if (lowerCorner.length > 2) {
            bbox.setMinZ(lowerCorner[2]);
        }
        double[] upperCorner = env.getUpperCorner();
        bbox.setMaxX(upperCorner[0]);
        bbox.setMaxY(upperCorner[1]);
        if (upperCorner.length > 2) {
            bbox.setMaxZ(upperCorner[2]);
        }
        return bbox;
    }

    public GMLFactory getGmlFactory() {
        return this.gmlFactory;
    }

    static enum ObjectType {
        Envelope{

            public String toString() {
                return "GML Envelope";
            }
        }
        ,
        Geometry{

            public String toString() {
                return "GML Geometry";
            }
        }
        ,
        TimePrimitive{

            public String toString() {
                return "GML Time Primitive";
            }
        }
        ,
        Feature{

            public String toString() {
                return "GML Feature";
            }
        };

    }
}

