/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.om;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.vast.ogc.OGCException;
import org.vast.ogc.OGCExceptionReader;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.om.IObservation;
import org.vast.swe.SWEFilter;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.vast.xml.IXMLReaderDOM;
import org.vast.xml.IXMLWriterDOM;
import org.vast.xml.XMLReaderException;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OMUtils {
    public static final String OM;
    public static final String V2_0 = "2.0";
    public static final String OBSERVATION = "Observation";
    protected static final Pattern versionRegex;
    protected static final String defaultVersion = "1.0";

    public static void loadRegistry() {
        String mapFileUrl = OMUtils.class.getResource("OMRegistry.xml").toString();
        OGCRegistry.loadMaps((String)mapFileUrl, (boolean)false);
    }

    public OMUtils(String version) {
    }

    public IObservation readObservation(DOMHelper dom, Element obsElt) throws XMLReaderException {
        String version = this.getVersion(dom, obsElt);
        IXMLReaderDOM reader = (IXMLReaderDOM)OGCRegistry.createReader((String)OM, (String)OBSERVATION, (String)version);
        return (IObservation)reader.read(dom, obsElt);
    }

    public IObservation readObservation(InputStream inputStream) throws XMLReaderException {
        try {
            DOMHelper dom = new DOMHelper(inputStream, false);
            return this.readObservation(dom, dom.getBaseElement());
        }
        catch (XMLReaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLReaderException("Error while reading inputstream", e);
        }
    }

    public IObservation readObservationSeries(InputStream inputStream) throws XMLReaderException {
        try {
            SWEFilter streamFilter = new SWEFilter(inputStream);
            streamFilter.setDataElementName("values");
            DOMHelper dom = new DOMHelper((InputStream)streamFilter, false);
            OGCExceptionReader.checkException((DOMHelper)dom);
            return null;
        }
        catch (DOMHelperException e) {
            throw new XMLReaderException("Error while parsing XML document", (Exception)((Object)e));
        }
        catch (OGCException e) {
            throw new XMLReaderException(e.getMessage());
        }
    }

    public Element writeObservation(DOMHelper dom, IObservation obs, String version) throws XMLWriterException {
        IXMLWriterDOM writer = (IXMLWriterDOM)OGCRegistry.createWriter((String)OM, (String)OBSERVATION, (String)version);
        return writer.write(dom, (Object)obs);
    }

    public void writeObservation(OutputStream outputStream, IObservation obs, String version) throws XMLWriterException, IOException {
        DOMHelper dom = new DOMHelper("obs");
        Element obsElt = this.writeObservation(dom, obs, version);
        dom.serialize((Node)obsElt, outputStream, true);
    }

    public String getVersion(DOMHelper dom, Element omElt) {
        String omUri = omElt.getNamespaceURI();
        String version = omUri.substring(omUri.lastIndexOf(47) + 1);
        if (!versionRegex.matcher(version).matches()) {
            version = defaultVersion;
        }
        return version;
    }

    static {
        versionRegex = Pattern.compile("^\\d+(\\.\\d+)?(\\.\\d+)?$");
        OM = "OM";
        OMUtils.loadRegistry();
    }
}

