/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.om;

import net.opengis.gml.v32.impl.CodeImpl;
import net.opengis.swe.v20.DataComponent;
import org.vast.ogc.def.DefinitionRef;
import org.vast.ogc.def.IDefinition;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ogc.gml.GenericFeature;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.ObservationImpl;
import org.vast.ogc.om.ProcedureRef;
import org.vast.ogc.om.ProcedureXML;
import org.vast.ogc.xlink.CachedReference;
import org.vast.ogc.xlink.IXlinkReference;
import org.vast.ogc.xlink.XlinkUtils;
import org.vast.swe.SWEFilter;
import org.vast.swe.SWEUtils;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.IXMLReaderDOM;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObservationReaderV20
implements IXMLReaderDOM<IObservation> {
    protected SWEFilter streamFilter;
    protected GMLUtils gmlUtils = new GMLUtils("3.2");
    protected SWEUtils sweUtils = new SWEUtils("2.0");

    public IObservation read(DOMHelper dom, Element obsElt) throws XMLReaderException {
        Element foiPropElt;
        Element procPropElt;
        ObservationImpl obs = new ObservationImpl();
        String id = dom.getAttributeValue(obsElt, "id");
        obs.setId(id);
        obs.setDescription(dom.getElementValue(obsElt, "description"));
        String uid = dom.getElementValue(obsElt, "identifier");
        if (uid != null) {
            obs.setUniqueIdentifier(uid);
        }
        NodeList nameElts = dom.getElements("name");
        for (int i = 0; i < nameElts.getLength(); ++i) {
            Element nameElt = (Element)nameElts.item(i);
            String name = dom.getElementValue(nameElt);
            String codeSpace = dom.getAttributeValue(nameElt, "@codeSpace");
            obs.getNameList().add(new CodeImpl(codeSpace, name));
        }
        obs.setType(dom.getAttributeValue(obsElt, "type/href"));
        Element metadata = dom.getElement(obsElt, "metadata/*");
        if (metadata != null) {
            obs.getMetaDataPropertyList().add((Object)metadata.cloneNode(true));
        }
        NodeList relObsElts = dom.getElements(obsElt, "relatedObservation/ObservationContext");
        for (int i = 0; i < relObsElts.getLength(); ++i) {
            Element refElt = (Element)relObsElts.item(i);
            String href = dom.getElementValue(refElt, "relatedObservation");
            CachedReference obsRef = new CachedReference(href);
            obsRef.setRole(dom.getElementValue(refElt, "role"));
            obs.addRelatedObservation((IXlinkReference<IObservation>)obsRef);
        }
        Element timeElt = dom.getElement(obsElt, "phenomenonTime/*");
        TimeExtent time = this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, timeElt);
        obs.setPhenomenonTime(time);
        timeElt = dom.getElement(obsElt, "resultTime/*");
        time = this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, timeElt);
        obs.setResultTime(time);
        timeElt = dom.getElement(obsElt, "validTime/*");
        if (timeElt != null) {
            time = this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, timeElt);
            obs.setValidTime(time);
        }
        if ((procPropElt = dom.getElement(obsElt, "procedure")) != null && !dom.existAttribute(procPropElt, "nil")) {
            if (dom.existAttribute(procPropElt, "href")) {
                ProcedureRef ref = new ProcedureRef();
                XlinkUtils.readXlinkAttributes((DOMHelper)dom, (Element)procPropElt, (IXlinkReference)ref);
                obs.setProcedure(ref);
            } else {
                Element procXML = dom.getFirstChildElement(procPropElt);
                if (procXML != null) {
                    obs.setProcedure(new ProcedureXML((Element)procXML.cloneNode(true)));
                }
            }
        }
        NodeList paramElts = dom.getElements(obsElt, "parameter/*");
        for (int i = 0; i < paramElts.getLength(); ++i) {
            Node paramValue;
            Element paramElt = (Element)paramElts.item(i);
            String paramName = dom.getAttributeValue(paramElt, "name/href");
            Element valueElt = dom.getElement(paramElt, "value/*");
            try {
                paramValue = valueElt.getNamespaceURI().equals("http://www.opengis.net/swe/2.0") ? this.sweUtils.readComponent(dom, valueElt) : valueElt.cloneNode(true);
            }
            catch (XMLReaderException e) {
                throw new XMLReaderException("Error while parsing observation parameter", (Node)paramElt, (Exception)((Object)e));
            }
            obs.addParameter(paramName, paramValue);
        }
        Element obsPropElt = dom.getElement(obsElt, "observedProperty");
        if (obsPropElt != null && !obsPropElt.hasAttribute("nil")) {
            DefinitionRef ref = new DefinitionRef();
            XlinkUtils.readXlinkAttributes((DOMHelper)dom, (Element)obsPropElt, (IXlinkReference)ref);
            obs.setObservedProperty((IXlinkReference<IDefinition>)ref);
        }
        if ((foiPropElt = dom.getElement(obsElt, "featureOfInterest")) != null && !dom.existAttribute(foiPropElt, "nil")) {
            obs.setFeatureOfInterest(this.readFOI(dom, foiPropElt));
        }
        NodeList qualityElts = dom.getElements(obsElt, "resultQuality/*");
        for (int i = 0; i < qualityElts.getLength(); ++i) {
            obs.addResultQuality(qualityElts.item(i).cloneNode(true));
        }
        Element resultElt = dom.getElement(obsElt, "result/*");
        if (resultElt != null) {
            try {
                DataComponent result = this.sweUtils.readComponent(dom, resultElt);
                obs.setResult(result);
            }
            catch (XMLReaderException e) {
                throw new XMLReaderException("Error while parsing observation result", (Node)resultElt, (Exception)((Object)e));
            }
        }
        return obs;
    }

    protected GenericFeature readFOI(DOMHelper dom, Element foiPropElt) throws XMLReaderException {
        Element featureElt = dom.getFirstChildElement(foiPropElt);
        if (featureElt != null) {
            return this.gmlUtils.readFeature(dom, featureElt);
        }
        if (dom.existAttribute(foiPropElt, "href")) {
            FeatureRef ref = new FeatureRef();
            XlinkUtils.readXlinkAttributes((DOMHelper)dom, (Element)foiPropElt, (IXlinkReference)ref);
            return ref;
        }
        return null;
    }
}

