/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.om;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.swe.v20.DataComponent;
import org.vast.ogc.def.IDefinition;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.IProcedure;
import org.vast.ogc.om.OMUtils;
import org.vast.ogc.xlink.IXlinkReference;
import org.vast.util.TimeExtent;
import org.vast.util.URIResolver;

public class ObservationRef
extends FeatureRef
implements IObservation {
    public ObservationRef() {
    }

    public ObservationRef(String href) {
        this.setHref(href);
    }

    @Override
    protected IObservation fetchTarget(String href) {
        try {
            URIResolver resolver = new URIResolver(new URI(href));
            InputStream is = resolver.openStream();
            return new OMUtils("2.0").readObservation(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<IXlinkReference<IObservation>> getRelatedObservations() {
        return this.getTarget().getRelatedObservations();
    }

    @Override
    public void addRelatedObservation(IXlinkReference<IObservation> obsUri) {
        this.getTarget().addRelatedObservation(obsUri);
    }

    @Override
    public TimeExtent getPhenomenonTime() {
        return this.getTarget().getPhenomenonTime();
    }

    @Override
    public void setPhenomenonTime(TimeExtent time) {
        this.getTarget().setPhenomenonTime(time);
    }

    @Override
    public TimeExtent getResultTime() {
        return this.getTarget().getResultTime();
    }

    @Override
    public void setResultTime(TimeExtent time) {
        this.getTarget().setResultTime(time);
    }

    @Override
    public TimeExtent getValidTime() {
        return this.getTarget().getValidTime();
    }

    @Override
    public void setValidTime(TimeExtent time) {
        this.getTarget().setValidTime(time);
    }

    @Override
    public IXlinkReference<IDefinition> getObservedProperty() {
        return this.getTarget().getObservedProperty();
    }

    @Override
    public void setObservedProperty(IXlinkReference<IDefinition> propRef) {
        this.getTarget().setObservedProperty(propRef);
    }

    @Override
    public AbstractFeature getFeatureOfInterest() {
        return this.getTarget().getFeatureOfInterest();
    }

    @Override
    public void setFeatureOfInterest(AbstractFeature foi) {
        this.getTarget().setFeatureOfInterest(foi);
    }

    @Override
    public IProcedure getProcedure() {
        return this.getTarget().getProcedure();
    }

    @Override
    public void setProcedure(IProcedure procedure) {
        this.getTarget().setProcedure(procedure);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.getTarget().getParameters();
    }

    @Override
    public void addParameter(String name, Object value) {
        this.getTarget().addParameter(name, value);
    }

    @Override
    public List<Object> getResultQuality() {
        return this.getTarget().getResultQuality();
    }

    @Override
    public void addResultQuality(Object qualityInfo) {
        this.getTarget().addResultQuality(qualityInfo);
    }

    @Override
    public DataComponent getResult() {
        return this.getTarget().getResult();
    }

    @Override
    public void setResult(DataComponent result) {
        this.getTarget().setResult(result);
    }

    public IObservation getTarget() {
        return (IObservation)super.getTarget();
    }
}

