/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.om;

import java.text.NumberFormat;
import java.util.Map;
import net.opengis.gml.v32.AbstractFeature;
import net.opengis.gml.v32.Code;
import net.opengis.swe.v20.DataComponent;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ogc.om.IObservation;
import org.vast.ogc.om.IProcedure;
import org.vast.ogc.om.OMUtils;
import org.vast.ogc.om.ProcedureRef;
import org.vast.ogc.xlink.IXlinkReference;
import org.vast.ogc.xlink.XlinkUtils;
import org.vast.swe.SWEUtils;
import org.vast.xml.DOMHelper;
import org.vast.xml.IXMLWriterDOM;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObservationWriterV20
implements IXMLWriterDOM<IObservation> {
    protected GMLUtils gmlUtils = new GMLUtils("3.2");
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected int currentId = 1;
    protected NumberFormat idFormatter = NumberFormat.getNumberInstance();

    public ObservationWriterV20() {
        this.idFormatter.setMinimumIntegerDigits(3);
        this.idFormatter.setGroupingUsed(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element write(DOMHelper dom, IObservation obs) throws XMLWriterException {
        IProcedure proc;
        dom.addUserPrefix("swe", OGCRegistry.getNamespaceURI((String)"SWE", (String)"2.0"));
        dom.addUserPrefix("om", OGCRegistry.getNamespaceURI((String)OMUtils.OM, (String)"2.0"));
        dom.addUserPrefix("gml", OGCRegistry.getNamespaceURI((String)"GML", (String)"3.2"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element obsElt = dom.createElement("om:" + obs.getQName().getLocalPart());
        String id = obs.getId();
        if (id == null || id.length() == 0) {
            id = "OBS_" + this.idFormatter.format(this.currentId++);
        }
        dom.setAttributeValue(obsElt, "gml:id", id);
        String desc = obs.getDescription();
        if (desc != null) {
            dom.setElementValue(obsElt, "gml:description", desc);
        }
        if (obs.isSetIdentifier()) {
            Element elt = dom.setElementValue(obsElt, "gml:identifier", obs.getUniqueIdentifier());
            dom.setAttributeValue(elt, "@codeSpace", "uid");
        }
        for (Code name : obs.getNameList()) {
            Element nameElt = dom.addElement((Node)obsElt, "+gml:name");
            dom.setElementValue(nameElt, name.getValue());
            if (name.getCodeSpace() == null || name.getCodeSpace().length() <= 0) continue;
            dom.setAttributeValue(nameElt, "@codeSpace", name.getCodeSpace());
        }
        String obsType = obs.getType();
        if (obsType != null) {
            dom.setAttributeValue(obsElt, "om:type/xlink:href", obsType);
        }
        if (obs.getRelatedObservations() != null) {
            for (IXlinkReference<IObservation> obsRef : obs.getRelatedObservations()) {
                Element obsRefElt = dom.addElement((Node)obsElt, "+om:relatedObservation/om:ObservationContext");
                dom.setElementValue(obsRefElt, "om:relatedObservation", obsRef.getHref());
                if (obsRef.getRole() == null) continue;
                dom.setElementValue(obsRefElt, "om:role", obsRef.getRole());
            }
        }
        Element timePropElt = dom.addElement((Node)obsElt, "om:phenomenonTime");
        Element timeElt = this.gmlUtils.writeTimeExtentAsTimePrimitive(dom, obs.getPhenomenonTime());
        timePropElt.appendChild(timeElt);
        timePropElt = dom.addElement((Node)obsElt, "om:resultTime");
        timeElt = this.gmlUtils.writeTimeExtentAsTimePrimitive(dom, obs.getResultTime());
        timePropElt.appendChild(timeElt);
        if (obs.getValidTime() != null) {
            timePropElt = dom.addElement((Node)obsElt, "om:validTime");
            timeElt = this.gmlUtils.writeTimeExtentAsTimePrimitive(dom, obs.getValidTime());
            timePropElt.appendChild(timeElt);
        }
        if ((proc = obs.getProcedure()) != null) {
            Element propElt = dom.addElement((Node)obsElt, "om:procedure");
            if (!(proc instanceof ProcedureRef)) throw new XMLWriterException("Unsupported procedure type: " + proc.getClass().getCanonicalName());
            XlinkUtils.writeXlinkAttributes((DOMHelper)dom, (Element)propElt, (IXlinkReference)((ProcedureRef)proc));
        } else {
            dom.setXsiNil(obsElt, "om:procedure");
        }
        if (obs.getParameters() != null) {
            for (Map.Entry<String, Object> param : obs.getParameters().entrySet()) {
                Object value = param.getValue();
                Element nvElt = dom.addElement((Node)obsElt, "+om:parameter/om:NamedValue");
                dom.setAttributeValue(nvElt, "om:name/xlink:href", param.getKey());
                Element valueElt = dom.addElement((Node)nvElt, "om:value");
                if (value instanceof DataComponent) {
                    try {
                        Element componentElt = this.sweUtils.writeComponent(dom, (DataComponent)value, true);
                        valueElt.appendChild(componentElt);
                        continue;
                    }
                    catch (XMLWriterException e) {
                        throw new XMLWriterException("Error while writing observation parameter " + param.getKey(), (Node)nvElt, (Exception)((Object)e));
                    }
                }
                if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                    dom.setElementValue(nvElt, value.toString());
                    continue;
                }
                if (!(value instanceof Element)) throw new RuntimeException("Unsupported parameter type: " + value.getClass());
                Element importedElt = (Element)nvElt.getOwnerDocument().importNode((Element)value, true);
                valueElt.appendChild(importedElt);
            }
        }
        if (obs.getObservedProperty() != null) {
            dom.setAttributeValue(obsElt, "om:observedProperty/xlink:href", obs.getObservedProperty().getHref());
        } else {
            dom.setXsiNil(obsElt, "om:observedProperty");
        }
        Element foiPropElt = dom.addElement((Node)obsElt, "om:featureOfInterest");
        AbstractFeature foi = obs.getFeatureOfInterest();
        if (foi != null) {
            this.writeFOI(dom, foiPropElt, foi);
        } else {
            dom.setXsiNil(obsElt, "om:featureOfInterest");
        }
        Element resultElt = dom.addElement((Node)obsElt, "om:result");
        if (obs.getResult() == null) return obsElt;
        try {
            Element componentElt = this.sweUtils.writeComponent(dom, obs.getResult(), true);
            resultElt.appendChild(componentElt);
            String sweQName = componentElt.getLocalName();
            dom.addUserPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            dom.setAttributeValue(resultElt, "xsi:type", "swe:" + sweQName + "PropertyType");
            return obsElt;
        }
        catch (XMLWriterException e) {
            throw new XMLWriterException("Error while writing observation result", (Node)resultElt, (Exception)((Object)e));
        }
    }

    protected void writeFOI(DOMHelper dom, Element foiPropElt, AbstractFeature foi) throws XMLWriterException {
        if (foi instanceof FeatureRef) {
            XlinkUtils.writeXlinkAttributes((DOMHelper)dom, (Element)foiPropElt, (IXlinkReference)((FeatureRef)foi));
        } else {
            Element foiElt = this.gmlUtils.writeFeature(dom, foi);
            foiPropElt.appendChild(foiElt);
        }
    }
}

