/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ogc.om;

import javax.xml.namespace.QName;
import net.opengis.gml.v32.AbstractGeometry;
import org.vast.ogc.gml.FeatureRef;
import org.vast.ogc.gml.GenericFeatureImpl;
import org.vast.ogc.xlink.CachedReference;

public abstract class SamplingFeature<GeomType extends AbstractGeometry>
extends GenericFeatureImpl {
    public static final String SAMS_NS_PREFIX = "sams";
    public static final String SAMS_NS_URI = "http://www.opengis.net/samplingSpatial/2.0";
    public static final String SF_NS_PREFIX = "sf";
    public static final String SF_NS_URI = "http://www.opengis.net/sampling/2.0";
    public static final QName PROP_SAMPLED_FEATURE = new QName("http://www.opengis.net/sampling/2.0", "sampledFeature", "sf");
    public static final QName PROP_HOSTED_PROCEDURE = new QName("http://www.opengis.net/samplingSpatial/2.0", "hostedProcedure", "sams");
    public static final QName PROP_SHAPE = new QName("http://www.opengis.net/samplingSpatial/2.0", "shape", "sams");

    public SamplingFeature(String type) {
        super(new QName(SAMS_NS_URI, "SF_SpatialSamplingFeature", SAMS_NS_PREFIX));
        QName qname = new QName(SF_NS_URI, "type", SF_NS_PREFIX);
        this.setProperty(qname, (Object)new CachedReference(type));
    }

    public void setSampledFeatureUID(String featureUID) {
        this.setProperty(PROP_SAMPLED_FEATURE, (Object)new FeatureRef(featureUID));
    }

    public String getSampledFeatureUID() {
        FeatureRef ref = (FeatureRef)this.getProperty(PROP_SAMPLED_FEATURE);
        if (ref == null) {
            return null;
        }
        return ref.getHref();
    }

    public void setHostedProcedureUID(String processUID) {
        this.setProperty(PROP_HOSTED_PROCEDURE, (Object)new FeatureRef(processUID));
    }

    public String getHostedProcedureUID() {
        FeatureRef ref = (FeatureRef)this.getProperty(PROP_HOSTED_PROCEDURE);
        if (ref == null) {
            return null;
        }
        return ref.getHref();
    }

    public void setShape(GeomType geom) {
        this.setProperty(PROP_SHAPE, geom);
    }

    public GeomType getShape() {
        return (GeomType)((AbstractGeometry)this.getProperty(PROP_SHAPE));
    }

    @Override
    public AbstractGeometry getLocation() {
        AbstractGeometry location = super.getLocation();
        if (location != null) {
            return location;
        }
        return this.getShape();
    }
}

