/*
 * Decompiled with CFR 0.152.
 */
package org.vast.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import net.opengis.gml.v32.Envelope;
import net.opengis.gml.v32.impl.EnvelopeImpl;
import org.vast.util.SpatialExtent;

public class Bbox
extends SpatialExtent {
    public Bbox() {
    }

    public Bbox(double minX, double minY, double maxX, double maxY) {
        this.setMinX(minX);
        this.setMinY(minY);
        this.setMaxX(maxX);
        this.setMaxY(maxY);
    }

    public Bbox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.setMinX(minX);
        this.setMinY(minY);
        this.setMinZ(minZ);
        this.setMaxX(maxX);
        this.setMaxY(maxY);
        this.setMaxZ(maxZ);
    }

    public Bbox(double minX, double minY, double maxX, double maxY, String crs) {
        this(minX, minY, maxX, maxY);
        this.crs = crs;
    }

    public Bbox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, String crs) {
        this(minX, minY, minZ, maxX, maxY, maxZ);
        this.crs = crs;
    }

    @Override
    public Bbox copy() {
        Bbox bbox = new Bbox();
        bbox.setMinX(this.minX);
        bbox.setMinY(this.minY);
        bbox.setMinZ(this.minZ);
        bbox.setMaxX(this.maxX);
        bbox.setMaxY(this.maxY);
        bbox.setMaxZ(this.maxZ);
        return bbox;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public com.vividsolutions.jts.geom.Envelope toJtsEnvelope() {
        return new com.vividsolutions.jts.geom.Envelope(this.minX, this.maxX, this.minY, this.maxY);
    }

    public Polygon toJtsPolygon() {
        Geometry geom = new GeometryFactory().toGeometry(this.toJtsEnvelope());
        if (geom instanceof Point) {
            geom = geom.buffer(1.0E-6, 1, 3);
        } else if (geom instanceof LineString) {
            geom = geom.buffer(1.0E-6, 1, 2);
        }
        return (Polygon)geom;
    }

    public Envelope toGmlEnvelope() {
        if (Double.isNaN(this.minZ)) {
            return new EnvelopeImpl(this.crs, this.minX, this.maxX, this.minY, this.maxY);
        }
        return new EnvelopeImpl(this.crs, this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    public void checkValid() {
        if (this.minX > this.maxX) {
            throw new IllegalArgumentException("MinX > MaxX");
        }
        if (this.minY > this.maxY) {
            throw new IllegalArgumentException("MinY > MaxY");
        }
        if (this.minZ > this.maxZ) {
            throw new IllegalArgumentException("MinZ > MaxZ");
        }
    }
}

