/*
 * Decompiled with CFR 0.152.
 */
package org.vast.util;

public class SpatialExtent {
    protected String crs;
    protected double minX = Double.NaN;
    protected double maxX = Double.NaN;
    protected double minY = Double.NaN;
    protected double maxY = Double.NaN;
    protected double minZ = Double.NaN;
    protected double maxZ = Double.NaN;

    public SpatialExtent copy() {
        SpatialExtent bbox = new SpatialExtent();
        bbox.crs = this.crs;
        bbox.minX = this.minX;
        bbox.minY = this.minY;
        bbox.minZ = this.minZ;
        bbox.maxX = this.maxX;
        bbox.maxY = this.maxY;
        bbox.maxZ = this.maxZ;
        return bbox;
    }

    public double[] getCenter() {
        double[] center = new double[3];
        center[0] = (this.minX + this.maxX) / 2.0;
        center[0] = (this.minY + this.maxY) / 2.0;
        center[0] = (this.minZ + this.maxZ) / 2.0;
        return center;
    }

    public double getDiagonalDistance() {
        double dx = this.maxX - this.minX;
        double dy = this.maxY - this.minY;
        double dz = this.maxZ - this.minZ;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        if (Double.isNaN(dz)) {
            return Math.sqrt(dx2 + dy2);
        }
        double dz2 = dz * dz;
        return Math.sqrt(dx2 + dy2 + dz2);
    }

    public double getMaxDistance() {
        double dx = this.maxX - this.minX;
        double dy = this.maxY - this.minY;
        double dz = this.maxZ - this.minZ;
        if (Double.isNaN(dz)) {
            return Math.max(dx, dy);
        }
        return Math.max(Math.max(dx, dy), dz);
    }

    public double getSizeX() {
        return this.maxX - this.minX;
    }

    public double getSizeY() {
        return this.maxY - this.minY;
    }

    public double getSizeZ() {
        return this.maxZ - this.minZ;
    }

    public boolean isNull() {
        if (Double.isNaN(this.minX)) {
            return true;
        }
        if (Double.isNaN(this.minY)) {
            return true;
        }
        if (Double.isNaN(this.maxX)) {
            return true;
        }
        return Double.isNaN(this.maxY);
    }

    public void nullify() {
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.minZ = Double.NaN;
        this.maxZ = Double.NaN;
    }

    public void resizeToContain(double x, double y, double z) {
        if (this.isNull()) {
            this.minX = this.maxX = x;
            this.minY = this.maxY = y;
            this.minZ = this.maxZ = z;
            return;
        }
        if (x < this.minX) {
            this.minX = x;
        } else if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        } else if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    public void add(SpatialExtent bbox) {
        this.checkCrs(bbox);
        if (this.isNull()) {
            this.minX = bbox.minX;
            this.minY = bbox.minY;
            this.minZ = bbox.minZ;
            this.maxX = bbox.maxX;
            this.maxY = bbox.maxY;
            this.maxZ = bbox.maxZ;
            return;
        }
        if (this.minX > bbox.minX) {
            this.minX = bbox.minX;
        }
        if (this.minY > bbox.minY) {
            this.minY = bbox.minY;
        }
        if (this.minZ > bbox.minZ) {
            this.minZ = bbox.minZ;
        }
        if (this.maxX < bbox.maxX) {
            this.maxX = bbox.maxX;
        }
        if (this.maxY < bbox.maxY) {
            this.maxY = bbox.maxY;
        }
        if (this.maxZ < bbox.maxZ) {
            this.maxZ = bbox.maxZ;
        }
    }

    public boolean intersects(SpatialExtent bbox) {
        this.checkCrs(bbox);
        double bboxX1 = bbox.getMinX();
        double bboxX2 = bbox.getMaxX();
        double bboxY1 = bbox.getMinY();
        double bboxY2 = bbox.getMaxY();
        if (bboxX1 < this.minX && bboxX2 < this.minX) {
            return false;
        }
        if (bboxX1 > this.maxX && bboxX2 > this.maxX) {
            return false;
        }
        if (bboxY1 < this.minY && bboxY2 < this.minY) {
            return false;
        }
        return !(bboxY1 > this.maxY) || !(bboxY2 > this.maxY);
    }

    public boolean contains(SpatialExtent bbox) {
        this.checkCrs(bbox);
        double bboxX1 = bbox.getMinX();
        double bboxX2 = bbox.getMaxX();
        double bboxY1 = bbox.getMinY();
        double bboxY2 = bbox.getMaxY();
        if (bboxX1 < this.minX || bboxX1 > this.maxX) {
            return false;
        }
        if (bboxX2 < this.minX || bboxX2 > this.maxX) {
            return false;
        }
        if (bboxY1 < this.minY || bboxY1 > this.maxY) {
            return false;
        }
        return !(bboxY2 < this.minY) && !(bboxY2 > this.maxY);
    }

    protected void checkCrs(SpatialExtent bbox) {
        if (this.crs != null && bbox.crs != null && !this.crs.equals(bbox.crs)) {
            throw new IllegalStateException("CRS must match");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpatialExtent)) {
            return false;
        }
        SpatialExtent otherBbox = (SpatialExtent)obj;
        if (this.crs != null && otherBbox.crs == null || this.crs == null && otherBbox.crs != null) {
            return false;
        }
        if (this.crs != null && otherBbox.crs != null && !this.crs.equals(otherBbox.crs)) {
            return false;
        }
        if (this.minX != otherBbox.minX || this.maxX != otherBbox.maxX) {
            return false;
        }
        if (this.minY != otherBbox.minY || this.maxY != otherBbox.maxY) {
            return false;
        }
        return this.minZ == otherBbox.minZ && this.maxZ == otherBbox.maxZ;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(double maxZ) {
        this.maxZ = maxZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public void setMinZ(double minZ) {
        this.minZ = minZ;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.minX);
        buf.append(',');
        buf.append(this.minY);
        buf.append(" - ");
        buf.append(this.maxX);
        buf.append(',');
        buf.append(this.maxY);
        if (this.crs != null) {
            buf.append(" (");
            buf.append(this.crs);
            buf.append(')');
        }
        return buf.toString();
    }
}

