/*
 * Decompiled with CFR 0.152.
 */
package org.vast.util;

import org.vast.util.DateTimeFormat;

public class TimeExtent {
    public static final double NOW_ACCURACY = 1000.0;
    public static final double UNKNOWN = Double.MAX_VALUE;
    public static final double NOW = Double.MIN_VALUE;
    protected double baseTime = Double.NaN;
    protected double timeBias = 0.0;
    protected double timeStep = 0.0;
    protected double leadTimeDelta = 0.0;
    protected double lagTimeDelta = 0.0;
    protected boolean baseAtNow = false;
    protected boolean endNow = false;
    protected boolean beginNow = false;
    protected int timeZone = 0;
    private double now = 0.0;

    public static TimeExtent getNowInstant() {
        TimeExtent time = new TimeExtent();
        time.setBaseAtNow(true);
        return time;
    }

    public static TimeExtent getPeriodStartingNow(double stopTime) {
        TimeExtent time = new TimeExtent();
        time.setBeginNow(true);
        time.setStopTime(stopTime);
        return time;
    }

    public static TimeExtent getPeriodEndingNow(double startTime) {
        TimeExtent time = new TimeExtent();
        time.setStartTime(startTime);
        time.setEndNow(true);
        return time;
    }

    public TimeExtent() {
    }

    public TimeExtent(double baseJulianTime) {
        this.baseTime = baseJulianTime;
    }

    public TimeExtent(double startTime, double stopTime) {
        this.setStartTime(startTime);
        this.setStopTime(stopTime);
    }

    public TimeExtent copy() {
        TimeExtent timeExtent = new TimeExtent();
        timeExtent.baseTime = this.getBaseTime();
        timeExtent.timeBias = this.timeBias;
        timeExtent.timeStep = this.timeStep;
        timeExtent.leadTimeDelta = this.leadTimeDelta;
        timeExtent.lagTimeDelta = this.lagTimeDelta;
        timeExtent.baseAtNow = this.baseAtNow;
        timeExtent.endNow = this.endNow;
        timeExtent.beginNow = this.beginNow;
        return timeExtent;
    }

    public TimeExtent(double baseJulianTime, double timeBiasSeconds, double timeStepSeconds, double leadTimeDeltaSeconds, double lagTimeDeltaSeconds) {
        this.baseTime = baseJulianTime;
        this.timeBias = timeBiasSeconds;
        this.timeStep = timeStepSeconds;
        this.leadTimeDelta = Math.abs(leadTimeDeltaSeconds);
        this.lagTimeDelta = Math.abs(lagTimeDeltaSeconds);
    }

    public void setBaseTime(double baseJulianTime) {
        this.baseTime = baseJulianTime;
    }

    public void setTimeBias(double seconds) {
        this.timeBias = seconds;
    }

    public void setTimeStep(double seconds) {
        this.timeStep = seconds;
    }

    public void setLeadTimeDelta(double seconds) {
        this.leadTimeDelta = Math.abs(seconds);
    }

    public void setLagTimeDelta(double seconds) {
        this.lagTimeDelta = Math.abs(seconds);
    }

    public void setDeltaTimes(double leadDeltaSeconds, double lagDeltaSeconds) {
        this.leadTimeDelta = Math.abs(leadDeltaSeconds);
        this.lagTimeDelta = Math.abs(lagDeltaSeconds);
    }

    public double getBaseTime() {
        if (this.baseAtNow) {
            return this.getNow();
        }
        return this.baseTime;
    }

    public double getAdjustedTime() {
        return this.getBaseTime() + this.timeBias;
    }

    public double getTimeBias() {
        return this.timeBias;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public double getLeadTimeDelta() {
        return this.leadTimeDelta;
    }

    public double getLagTimeDelta() {
        return this.lagTimeDelta;
    }

    public double getTimeRange() {
        return this.getAdjustedLeadTime() - this.getAdjustedLagTime();
    }

    public double getAdjustedLeadTime() {
        if (this.endNow) {
            return this.getNow() + this.timeBias;
        }
        return this.getBaseTime() + this.timeBias + this.leadTimeDelta;
    }

    public double getAdjustedLagTime() {
        if (this.beginNow) {
            return this.getNow() + this.timeBias;
        }
        return this.getBaseTime() + this.timeBias - this.lagTimeDelta;
    }

    public boolean isBaseAtNow() {
        return this.baseAtNow;
    }

    public void setBaseAtNow(boolean baseAtNow) {
        this.baseAtNow = baseAtNow;
    }

    public boolean isBeginNow() {
        return this.beginNow;
    }

    public void setBeginNow(boolean beginNow) {
        this.beginNow = beginNow;
    }

    public boolean isEndNow() {
        return this.endNow;
    }

    public void setEndNow(boolean endNow) {
        this.endNow = endNow;
    }

    public int getNumberOfSteps() {
        if (this.timeStep == 0.0) {
            return 1;
        }
        return (int)((this.getAdjustedLeadTime() - this.getAdjustedLagTime()) / this.timeStep);
    }

    public double[] getTimes() {
        double[] times;
        double time = this.getAdjustedLeadTime();
        double lagTime = this.getAdjustedLagTime();
        if (this.timeStep == 0.0) {
            return new double[]{time, lagTime};
        }
        double timeRange = Math.abs(time - lagTime);
        double remainder = timeRange % this.timeStep;
        int steps = (int)(timeRange / this.timeStep) + 1;
        if (remainder != 0.0) {
            times = new double[steps + 1];
            times[steps] = lagTime;
        } else {
            times = new double[steps];
        }
        for (int i = 0; i < steps; ++i) {
            times[i] = time - (double)i * this.timeStep;
        }
        return times;
    }

    public String toString() {
        String tString = new String("TimeExtent:");
        tString = tString + "\n  baseTime = " + (this.baseAtNow ? "now" : Double.valueOf(this.baseTime));
        tString = tString + "\n  timeBias = " + this.timeBias;
        tString = tString + "\n  timeStep = " + this.timeStep;
        tString = tString + "\n  leadTimeDelta = " + this.leadTimeDelta;
        tString = tString + "\n  lagTimeDelta = " + this.lagTimeDelta;
        return tString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeExtent)) {
            return false;
        }
        return this.equals((TimeExtent)obj);
    }

    public boolean equals(TimeExtent timeExtent) {
        if (!this.baseAtNow) {
            if (!(this.getAdjustedLagTime() == timeExtent.getAdjustedLagTime() || this.isBeginNow() && timeExtent.isBeginNow())) {
                return false;
            }
            if (!(this.getAdjustedLeadTime() == timeExtent.getAdjustedLeadTime() || this.isEndNow() && timeExtent.isEndNow())) {
                return false;
            }
        } else {
            if (!timeExtent.isBaseAtNow()) {
                return false;
            }
            if (this.getLagTimeDelta() != timeExtent.getLagTimeDelta()) {
                return false;
            }
            if (this.getLeadTimeDelta() != timeExtent.getLeadTimeDelta()) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(double time) {
        double thisLag = this.getAdjustedLagTime();
        double thisLead = this.getAdjustedLeadTime();
        if (time < thisLag) {
            return false;
        }
        return !(time > thisLead);
    }

    public boolean contains(TimeExtent timeExtent) {
        double thisLag = this.getAdjustedLagTime();
        double thisLead = this.getAdjustedLeadTime();
        double otherLag = timeExtent.getAdjustedLagTime();
        double otherLead = timeExtent.getAdjustedLeadTime();
        if (otherLag < thisLag) {
            return false;
        }
        if (otherLag > thisLead) {
            return false;
        }
        if (otherLead < thisLag) {
            return false;
        }
        return !(otherLead > thisLead);
    }

    public boolean intersects(TimeExtent timeExtent) {
        double thisLag = this.getAdjustedLagTime();
        double thisLead = this.getAdjustedLeadTime();
        double otherLag = timeExtent.getAdjustedLagTime();
        double otherLead = timeExtent.getAdjustedLeadTime();
        if (otherLag > thisLag && otherLag < thisLead) {
            return true;
        }
        if (otherLead > thisLag && otherLead < thisLead) {
            return true;
        }
        return otherLag <= thisLag && otherLead >= thisLead;
    }

    public boolean isNull() {
        return Double.isNaN(this.baseTime) && !this.baseAtNow && !this.beginNow && !this.endNow;
    }

    public boolean isTimeInstant() {
        if (this.leadTimeDelta != 0.0) {
            return false;
        }
        if (this.lagTimeDelta != 0.0) {
            return false;
        }
        return this.baseAtNow || !this.beginNow && !this.endNow;
    }

    public void nullify() {
        this.baseTime = Double.NaN;
        this.timeBias = 0.0;
        this.timeStep = 0.0;
        this.leadTimeDelta = 0.0;
        this.lagTimeDelta = 0.0;
        this.baseAtNow = false;
        this.endNow = false;
        this.beginNow = false;
    }

    public void resizeToContain(double t) {
        if (this.isNull()) {
            this.baseTime = t;
            this.timeBias = 0.0;
            return;
        }
        double adjBaseTime = this.getAdjustedTime();
        if (t > this.getAdjustedLeadTime()) {
            this.leadTimeDelta = t - adjBaseTime;
        } else if (t < this.getAdjustedLagTime()) {
            this.lagTimeDelta = adjBaseTime - t;
        }
    }

    private double getNow() {
        double exactNow = (double)System.currentTimeMillis() / 1000.0;
        if (exactNow - this.now > 1000.0) {
            this.now = exactNow;
        }
        return this.now;
    }

    public double getStartTime() {
        return this.getAdjustedLagTime();
    }

    public void setStartTime(double startTime) {
        this.beginNow = false;
        if (Double.isNaN(this.baseTime) || this.baseAtNow) {
            this.baseTime = startTime;
            this.lagTimeDelta = 0.0;
            this.baseAtNow = false;
        } else if (startTime > this.baseTime) {
            double stopTime = this.baseTime + this.leadTimeDelta;
            this.baseTime = startTime;
            this.leadTimeDelta = Math.max(0.0, stopTime - this.baseTime);
            this.lagTimeDelta = 0.0;
        } else {
            this.lagTimeDelta = this.baseTime - startTime;
        }
    }

    public double getStopTime() {
        return this.getAdjustedLeadTime();
    }

    public void setStopTime(double stopTime) {
        this.endNow = false;
        if (Double.isNaN(this.baseTime) || this.baseAtNow) {
            this.baseTime = stopTime;
            this.leadTimeDelta = 0.0;
            this.baseAtNow = false;
        } else if (stopTime < this.baseTime) {
            double startTime = this.baseTime - this.lagTimeDelta;
            this.baseTime = stopTime;
            this.lagTimeDelta = Math.max(0.0, this.baseTime - startTime);
            this.leadTimeDelta = 0.0;
        } else {
            this.leadTimeDelta = stopTime - this.baseTime;
        }
    }

    public String getIsoString(int zone) {
        DateTimeFormat timeFormat = new DateTimeFormat();
        if (this.isTimeInstant()) {
            String time = this.baseAtNow ? "now" : timeFormat.formatIso(this.getBaseTime(), zone);
            return time;
        }
        String start = this.beginNow ? "now" : timeFormat.formatIso(this.getStartTime(), zone);
        String stop = this.endNow ? "now" : timeFormat.formatIso(this.getStopTime(), zone);
        return start + "/" + stop;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(int timeZone) {
        this.timeZone = timeZone;
    }
}

