/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.query.DatastoreQuery;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.AbstractQueryResult;

class PojoDatastoreBridge {
    PojoDatastoreBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> List<T> toPojoResult(final ExecutionContext ec, Class<T> cls, Iterable<Entity> queryResultIterable, Cursor endCursor) {
        final ClassLoaderResolver clr = ec.getClassLoaderResolver();
        final AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
        Utils.Function<Entity, Object> func = new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return EntityUtils.entityToPojo(from, acmd, clr, ec, true, ec.getFetchPlan().getCopy());
            }
        };
        DummyQuery query = new DummyQuery(ec.getStoreManager(), ec);
        final ManagedConnection mconn = ec.getStoreManager().getConnection(ec);
        try {
            List<?> results = DatastoreQuery.newStreamingQueryResultForEntities(queryResultIterable, func, endCursor, query);
            if (results instanceof AbstractQueryResult) {
                final AbstractQueryResult qr = (AbstractQueryResult)results;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void managedConnectionPreClose() {
                        qr.disconnect();
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn.removeListener((ManagedConnectionResourceListener)this);
                    }

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr.disconnect();
                    }
                };
                mconn.addListener(listener);
                qr.addConnectionListener(listener);
            }
            List<?> list = results;
            return list;
        }
        finally {
            mconn.release();
        }
    }

    private static final class DummyQuery
    extends AbstractJavaQuery {
        private DummyQuery(StoreManager storeMgr, ExecutionContext ec) {
            super(storeMgr, ec);
        }

        public String getSingleStringQuery() {
            throw new UnsupportedOperationException();
        }

        protected void compileInternal(Map parameterValues) {
            throw new UnsupportedOperationException();
        }

        protected Object performExecute(Map parameters) {
            throw new UnsupportedOperationException();
        }
    }
}

