/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.query.QueryExceptionWrappers;
import com.google.appengine.datanucleus.query.RuntimeExceptionObserver;
import com.google.appengine.datanucleus.query.RuntimeExceptionWrappingIterator;
import java.util.Iterator;
import org.datanucleus.api.ApiAdapter;

class RuntimeExceptionWrappingIterable
implements Iterable<Entity>,
RuntimeExceptionObserver {
    private final ApiAdapter api;
    private final Utils.Supplier<Iterator<Entity>> iteratorSupplier;
    private boolean hasError = false;

    RuntimeExceptionWrappingIterable(ApiAdapter api, final Iterable<Entity> inner) {
        if (inner == null) {
            throw new NullPointerException("inner cannot be null");
        }
        this.api = api;
        Utils.Supplier<Iterator<Entity>> supplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Iterator<Entity>>(){

            @Override
            public Iterator<Entity> get() {
                return RuntimeExceptionWrappingIterable.this.newIterator(inner.iterator());
            }
        });
        this.iteratorSupplier = QueryExceptionWrappers.dataNucleusToApi(api, supplier);
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.iteratorSupplier.get();
    }

    Iterator<Entity> newIterator(Iterator<Entity> innerIter) {
        return new RuntimeExceptionWrappingIterator(this.api, innerIter, this);
    }

    @Override
    public void onException() {
        this.hasError = true;
    }

    boolean hasError() {
        return this.hasError;
    }
}

